
#include "pvm3.h"
#include "pvm_consts.h"
#include "../src/bfunc.h"

void
FUNCTION(pvmftasks)
	ARGS(`where,
		ntaskp,
		tidp,
		ptidp,
		hostp,
		flagp,
		STRING_ARG(a_out),
		infop')

	int  *where, *ntaskp, *tidp, *ptidp, *hostp, *flagp, *infop;
	STRING_ARG_DECL(a_out);
{
	static struct pvmtaskinfo *tip = 0;
	static int ntask = 0;
	static int next = 0;

	int cc;
	struct pvmtaskinfo *tip2;

	char *malloc();

/* if user sets ntaskp to -1 then pvmftasks() will be reset */

    if (tip && (*ntaskp == -1)) {
        free((char*)tip);
        tip = 0;
    }

	if (!tip) {
		if ((cc = pvm_tasks(*where, &ntask, &tip2)) < 0) {
			*infop = cc;
			return;
		}
		tip = (struct pvmtaskinfo*)malloc(ntask * sizeof(struct pvmtaskinfo));
		BCOPY((char*)tip2, (char*)tip, ntask * sizeof(struct pvmtaskinfo));
		next = 0;
	}

	if (next < ntask) {
		*ntaskp = ntask;
		*tidp = tip[next].ti_tid;
		*ptidp = tip[next].ti_ptid;
		*hostp = tip[next].ti_host;
		*flagp = tip[next].ti_flag;
		ctofstr(STRING_PTR(a_out), STRING_LEN(a_out), tip[next].ti_a_out);
		*infop = 1;
		next++;
	}

/* can not return ti_pid without changing interface */
/* users needing this will have to use C            */

	if (next == ntask) {
		free((char*)tip);
		tip = 0;
	}
}

