#ifndef __NQS_GENERIC_TCI_HEADER
#define __NQS_GENERIC_TCI_HEADER

/*
 * nqs_generic/TCI.h
 * Transaction completion information
 * 
 * See ChangeLog for modification list
 */

#include <nqs_generic/license.h>

/*
 * NOTES:
 * 
 * 	1) The TCI_ values are used by both local and peer machines,
 * 	   and so cannot be changed without making Monsanto-NQS
 * 	   *incompatible* with other NQS implementations.
 */

/*
 *	This file describes the information flags that are valid
 *	for the 21-bits of information data in an NQS completion
 *	code.
 *
 *	All NQS request and transaction completion codes fit in
 *	a long integer.  Each NQS completion code is broken down
 *	into four (4) sections:
 *
 *	.----------------------------------------------------------.
 *	| 0 | 21-bits of additional information | T | 9-bit reason |
 *	`----------------------------------------------------------'
 *
 *	The highest-order bit must be zero, to make the value positive,
 *	for "32-bit machines."
 *
 *	The 'T' bit when set, indicates that the code is a TRANSACTION
 *	completion code.  Otherwise, the code is a REQUEST completion
 *	code.
 */

/*
 *	Quota limit violation transaction information (TCI_) flags:
 */

#define	TCI_COPLIMEXC	000000002000L
  /* Copy limit exceeded */
#define	TCI_PP_CFLEXC	000000004000L
  /* Per-proc corefile limit too big */
#define	TCI_PP_CTLEXC	000000010000L
  /* Per-proc CPU time limit too big */
#define	TCI_PP_DSLEXC	000000020000L
  /* Per-proc dataseg limit too big */
#define	TCI_PP_MSLEXC	000000040000L
  /* Per-proc memsize limit too big */
#define	TCI_PP_NELEXC	000000100000L
  /* Per-proc nice value limit too big*/
#define	TCI_PP_PFLEXC	000000200000L
  /* Per-proc permfile limit too big */
#define	TCI_PP_QFLEXC	000000400000L
  /* Per-proc quick file limit too big */
#define	TCI_PP_SSLEXC	000001000000L
  /* Per-proc stackseg limit too big */
#define	TCI_PP_TFLEXC	000002000000L
  /* Per-proc tempfile limit too big */
#define	TCI_PP_WSLEXC	000004000000L
  /* Per-proc workset quota too big */
#define	TCI_PRILIMEXC	000010000000L
  /* Print file too large */
#define	TCI_PR_CTLEXC	000020000000L
  /* Per-req CPU time limit too big */
#define TCI_PR_DRIEXC	000040000000L
  /* Per-req tape drives limit too big */
#define	TCI_PR_MSLEXC	000100000000L
  /* Per-req memsize limit too big */
#define	TCI_PR_NCPEXC	000200000000L
  /* Per-req # of cpus limit too big */
#define	TCI_PR_PFLEXC	000400000000L
  /* Per-req permfile limit too big */
#define	TCI_PR_QFLEXC	001000000000L
  /* Per-req quick file limit too big */
#define	TCI_PR_TFLEXC	002000000000L
  /* Per-req tempfile limit too big */

#endif 		/* __NQS_GENERIC_TCI_HEADER */