/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.1   JRR     24-Aug-1992     Initial version.
*	V01.2	JRR	26-Feb-1993	Added Boeing enhancement for Mids.
*	V01.3	JRR	01-Mar-1994	Added support for SOLARIS.
*	V01.4	JRR	20-Jul-1994	Print rap when doing load dump.
*/
/*++ nqs_upm.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.36/src/RCS/nqs_memdump.c,v $
 *
 * DESCRIPTION:
 *
 *	NQS dump internal data structures module.
 *
 *
 *	Author:
 *	-------
 *	John Roman, Monsanto Company.
 *	August 24, 1992.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.4 $ $Date: 1994/09/02 17:39:41 $ $State: Exp $)
 * $Log: nqs_memdump.c,v $
 * Revision 1.4  1994/09/02  17:39:41  jrroma
 * Version 3.36
 *
 * Revision 1.3  1994/03/30  20:36:43  jrroma
 * Version 3.35.6
 *
 * Revision 1.2  93/07/13  21:33:54  jrroma
 * Version 3.34
 * 
 * Revision 1.1  92/12/22  15:40:43  jrroma
 * Version 3.30
 * 
 * 
 *
 */
#include "nqs.h"
#include "nqsxvars.h"
#include "transactcc.h"		/* Transaction completion codes */
#include <time.h>
#include <string.h>

#ifndef __CEXTRACT__
#if __STDC__

static int dump_load ( void );
static int dump_req ( void );

#else /* __STDC__ */

static int dump_load (/* void */);
static int dump_req (/* void */);

#endif /* __STDC__ */
#endif /* __CEXTRACT__ */

/*** nqs_memdump
 *
 *
 *		TCML_COMPLETE:	if successful;
 */
long nqs_memdump (int dump_flag)
{
    
    if (Debug > 2) {
        printf("D$Nqs_memdump: Entering with flags %d.\n", dump_flag);
	fflush(stdout);
    }
    switch (dump_flag) {
	case MEMDUMP_REQ:
	    dump_req();
	    break;
	case MEMDUMP_LOAD:
	    dump_load();
	    break;
	default:
	    printf("D$Unknown dump flag %d\n",  dump_flag);
    }
    return (TCML_COMPLETE);
}
/*** dump_req
 *
 *
 *	int dump_req():
 *
 */
static int dump_req ()
{
	register struct nqsqueue *queue;	/* Queue set to traverse */
	register struct request *req;
	register short set;		/* Request set [0..6] */
	int status;			/* Status of write to fifo */

	queue = Nonnet_queueset;	/* The request will always be */
					/* located in a non-network queue */
	while (queue != (struct nqsqueue *) 0) {
	    printf("D$Nqs_memdump: Queue: %s.\n",  queue->q.namev.name);
	    for (set = 0; set <= 6; set++) {
		/*
		 *  Search each
		  set for the request.
		 */
		req = (struct request *) 0;
		switch (set) {
		    case 0:
		       req = queue->departset;
		       break;
		    case 1:
		       req = queue->runset;
		       break;
		    case 2: 
			req = queue->stageset;
			break;
		    case 3:
			req = queue->queuedset;
			break;
		    case 4:
		    	req = queue->waitset;
			break;
		    case 5:
		    	req = queue->holdset;
			break;
		    case 6: 
			req = queue->arriveset;
			break;
		}
		while (req != (struct request *) 0 ) {
		    printf("D$Request %d name is %s\n",  req->v1.req.orig_seqno, 
				req->v1.req.reqname); 
		    req = req->next;
		}
	    }
	    /*
	     *  Examine the next queue in the queue set.
	     */
	    queue = queue->next;
	}
	return ( 0);	
}
/*
 * Dump the load information data structures.
 */
static int 
dump_load()
{
    struct loadinfo *loadinfo_ptr;
    float load1,  load5,  load15;
    char  *time_ptr,  *cp;

    /*
     * Look through the list of loadinfos printing as we go.
     */
    loadinfo_ptr = Loadinfo_head.next;
    if (loadinfo_ptr == (struct loadinfo *) 0) {
	printf("I$Nqs_memdump: No load data structures.\n");
	fflush(stdout);
	return (0);
    }
    while (loadinfo_ptr != (struct loadinfo *) 0) {
        time_ptr = ctime(&loadinfo_ptr->time);
	cp = strchr(time_ptr,  '\n');
	if (cp != NULL ) *cp = '\0';
	printf("I$Nqs_memdump: Mid %u Time %s Jobs %d RAP %d\n", loadinfo_ptr->mid, 
			    time_ptr,  loadinfo_ptr->no_jobs,
			    loadinfo_ptr->rap);
	printf("I$NQS_memdump: Load %f %f %f\n",  loadinfo_ptr->load1, 
			    loadinfo_ptr->load5, loadinfo_ptr->load15);
	fflush (stdout);
        loadinfo_ptr = loadinfo_ptr->next;
    }
  
}
