/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.20  JRR     16-Jan-1992	Added support for RS6000.
*	V01.3	JRR	17-Jun-1992	Added header.
*	V01.4	JRR	05-Mar-1993	Added Boeing enhancement for files.
*	V01.5
*	V01.6	JRR	18-Aug-1993	Miniscule change to includes.
*/
/*++ nqspriv.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.35/lib/RCS/nqspriv.c,v $
 *
 * DESCRIPTION:
 *
 *	Determine the Qmgr privilege bits for the user running the
 *	NQS Qmgr program.  The value returned is the privilege mask
 *	for the user.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	August 12, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.6 $ $Date: 1993/09/10 13:55:17 $ $State: Exp $)
 * $Log: nqspriv.c,v $
 * Revision 1.6  1993/09/10  13:55:17  jrroma
 * Version 3.35
 *
 * Revision 1.5  93/07/13  21:31:30  jrroma
 * Version 3.34
 * 
 * Revision 1.4  92/11/06  13:45:47  jrroma
 * Added support for HPUX.
 * 
 * Revision 1.3  92/06/18  13:24:18  jrroma
 * Added gnu header
 * 
 * Revision 1.2  92/01/16  16:57:35  jrroma
 * Added support for RS6000.
 * 
 * Revision 1.1  92/01/16  16:56:42  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"			/* NQS definitions and types */
#include "nqsxdirs.h"			/* NQS external directories */


/*** nqspriv
 *
 *
 *	nqspriv():
 *	Returns:
 *		The Qmgr privilege bits for the user running the
 *		NQS Qmgr program.  The value returned is the
 *		privilege mask for the user.
 */
int nqspriv (
	uid_t real_uid,		/* REAL user-id of user at */
	Mid_t user_mid,		/* machine: machine_id. */
	Mid_t local_mid)	/* Machine-id of local machine */
{
	register struct confd *file;	/* NQS database file descriptor */
	register struct gendescr *descr;/* Generic descriptor */
	char path [MAX_PATHNAME+1];	/* Pathname of NQS mgr acct file */
	char *root_dir;

	if (real_uid == 0 && user_mid == local_mid) {
		/*
		 *  The caller is running as root on the local machine,
		 *  and thus has all possible NQS Qmgr privileges.
		 */
		return (~0);
	}
        root_dir = getfilnam (Nqs_root, SPOOLDIR);
        if (root_dir == (char *)NULL) return (0);
        sprintf (path, "%s/%s", root_dir, Nqs_mgracct);
	relfilnam (root_dir);
	if ((file = opendb (path, O_RDONLY)) == (struct confd *) 0) return (0);
	descr = nextdb (file);		/* Get next allocated record */
	while (descr != (struct gendescr *)0) {
		if (descr->v.mgr.manager_uid == real_uid &&
		    descr->v.mgr.manager_mid == user_mid) {
			closedb (file);
			return (descr->v.mgr.privileges);
					/* Access permitted */
		}
		descr = nextdb (file);
	}
	closedb (file);			/* Access denied */
	return (0);			/* NO NQS privileges */
}
