#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>

char cTable[] =
{
  '!', '!' , '!' , '!', '!' , '!', '!' , '!', '!', '!', '!', '!', '!', '!', '!' , '!', /*  00 - 15 */
  '!', '!' , '!' , '!', '!' , '!', '!' , '!', '!', '!', '!', '!', '!', '!', '!' , '!', /*  16 - 31 */
  '!', '!' , '!' , '!', '!' , '!', '!' , '!', '!', '!', '!', '!', '!', '!', '!' , '!', /*  32 - 47 */
  '!', '!' , '!' , '!', '!' , '!', '!' , '!', '!', '!', '!', '!', '!', '!', '!' , '!', /*  48 - 63 */
  '!', '!' , '!' , '!', '!' , '!', '!' , '!', '!', '!', '!', '!', '!', '!', '!' , '!', /*  64 - 79 */
  '!', '!' , '!' , '!', '!' , '!', '!' , '!', '!', '!', '!', '!', '!', '!', '!' , '!', /*  80 - 95 */
  '!', '\a', '\b', '!', '!' , '!', '\f', '!', '!', '!', '!', '!', '!', '!', '\n', '!', /*  96 - 111 */
  '!', '!' , '\r', '!', '\t', '!', '\v', '!', '!', '!', '!', '!', '!', '!', '!' , '!', /* 112 - 127 */
  '!', '!' , '!' , '!', '!' , '!', '!' , '!', '!', '!', '!', '!', '!', '!', '!' , '!', /* we do not care */
  '!', '!' , '!' , '!', '!' , '!', '!' , '!', '!', '!', '!', '!', '!', '!', '!' , '!', /* once we reach here */
  '!', '!' , '!' , '!', '!' , '!', '!' , '!', '!', '!', '!', '!', '!', '!', '!' , '!',
  '!', '!' , '!' , '!', '!' , '!', '!' , '!', '!', '!', '!', '!', '!', '!', '!' , '!',
  '!', '!' , '!' , '!', '!' , '!', '!' , '!', '!', '!', '!', '!', '!', '!', '!' , '!',
  '!', '!' , '!' , '!', '!' , '!', '!' , '!', '!', '!', '!', '!', '!', '!', '!' , '!',
  '!', '!' , '!' , '!', '!' , '!', '!' , '!', '!', '!', '!', '!', '!', '!', '!' , '!',
  '!', '!' , '!' , '!', '!' , '!', '!' , '!', '!', '!', '!', '!', '!', '!', '!' , '!'
};

char * do_convert(char *szIn)
{
  char *szFormat;
  char *szWalker;
  int   boSlash = 0;
  
  if ((szFormat = (char *) malloc(strlen(szIn) + 1)) == NULL)
  {
    perror("Insufficent free memory\n");
    exit(1);
  }
  
  szWalker = szFormat;
  
  for (; *szIn != '\0'; szIn++)
  {
    if (boSlash)
    {
      *szWalker = cTable[(int) *szIn];
      szWalker++;
      boSlash = 0;
    }
    else if (*szIn == '\\')
      boSlash = 1;
    else
    {
      *szWalker = *szIn;
       szWalker++;
    }
  }
  
  *szWalker = '\0';
  return szFormat;
}

void do_printf(char *szFormat, ...)
{
  char *szFormatted;
  va_list vTmp;
  
  szFormatted = do_convert(szFormat);
  va_start(vTmp, szFormat);
  vfprintf(stdout, szFormatted, vTmp);
  va_end(vTmp);
}

int main(int argc, char *argv[])
{
  if (argc < 2)
  {
    fprintf(stderr,"Usage: %s format [ argument ... ]\r\n", argv[0]);
    fprintf(stderr,"       This program does NOT support octal escape sequences (\\xxx)\r\n");
    exit(1);
  }
  
  /*
   * yes, the following is a nasty kludge, but the alternative is to write the
   * actual printf(3) code here instead ... this is the shorter solution.
   */
  
  switch(argc)
  {
   case 2:
    do_printf(argv[1], argv[2]);
    break;
   case 3:
    do_printf(argv[1], argv[2], argv[3]);
    break;
   case 4:
    do_printf(argv[1], argv[2], argv[3], argv[4]);
    break;
   case 5:
    do_printf(argv[1], argv[2], argv[3], argv[4], argv[5]);
    break;
   case 6:
    do_printf(argv[1], argv[2], argv[3], argv[4], argv[5], argv[6]);
    break;
   case 7:
    do_printf(argv[1], argv[2], argv[3], argv[4], argv[5], argv[6], argv[7]);
    break;
   case 8:
    do_printf(argv[1], argv[2], argv[3], argv[4], argv[5], argv[6], argv[7], argv[8]);
    break;
   default:
    fprintf(stderr, "%s: too many arguments\r\n", argv[0]);
    exit(1);
  }
  exit(0);
}
