/*
 * nqs_generic/all-systems/isdecstr.c
 * Test string to ensure it contains only numeric characters.
 */

#include <nqs_generic/license.h>
  /* NQS license information */
#include <nqs_generic/debug.h>
  /* debugging information */
#include <stdio.h>
  /* for NULL definition */

/*** isdecstr
 *
 *	int isdecstr():
 *
 *	Returns:
 *		1: if the specified string of length n characters
 *		   contains decimal digits and nothing but decimal digits;
 *		0: otherwise.
 */
int isdecstr (char *szName, int iLen)
{
  ENTER_FUNCTION("nqs_generic/all-systems/isdecstr");
    /* debugging info */
  TEST_ARG(szName != NULL, 1);
  TEST_ARG(iLen   >  0,    2);
    /* ensure we are not working with garbage */
  
  while (iLen && *szName >= '0' && *szName <= '9')
  {
    iLen--;
    szName++;
  }
  if (iLen == 0)
  {
    EXIT_FUNCTION;
    return (1);
  }
  else if (*szName == '\0')
  {    
    ERROR_DATA(INFO, GET_MESSAGE(NQSM_RANGE_SMALLLEN));
  }
  else
  {
    EXIT_FUNCTION;
    return 0;
  }
  NEVER;
    /* this should never be reached */
  return 0;
    /* to keep the compiler happy ... */
}
