/*
 * nqs_generic/all-systems/fmttime.c
 * Format a time string.
 */

#include <nqs_generic/license.h>
  /* NQS license information */
#include <nqs_generic/debug.h>
  /* debugging support */
#include <time.h>
#include <stdio.h>

extern char *tzname [2];
extern void tzset();
  /* Set local timezone */

/* 
 * FIXME: 
 * where do these variables come from !?!
 */

/*** fmttime
 *
 *	char *fmttime():
 *
 *	Return a pointer to a formatted time string where the time
 *	is specified as a long integer defining the number of seconds
 *	since 00:00:00 GMT, January 1, 1970.
 */
char *fmttime (time_t *stTimeinsecs)
{
  static char szBuffer [40];
    /* Output buffer */
  char *szTzn;
    /* Time zone name */
  char *szTs;
    /* Time string */
  struct tm *stTp;
    /* Time structure pointer */

  ENTER_FUNCTION("nqs_generic/all-systems/fmttime");
    /* debugging information */
  TEST_ARG(stTimeinsecs != NULL, 1);
    /* ensure we are not being passed garbage */
  
  tzset();
    /* Get local timezone */
  stTp  = localtime (stTimeinsecs);
  szTs  = asctime (stTp);
  szTzn = tzname [stTp->tm_isdst];

  if (szTzn == NULL)
    *szTzn = '\0';
  
  szTs [24] = '\0';
    /* Zap newline character */
  sprintf (szBuffer, "%.20s%s%s", szTs, szTzn, szTs+19);
  
  EXIT_FUNCTION;
  return (szBuffer);
}
