/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*++ seekdb.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.30/lib/RCS/seekdb.c,v $
 *
 * DESCRIPTION:
 *
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	August 12, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.3 $ $Date: 1992/12/22 15:46:27 $ $State: Exp $)
 * $Log: seekdb.c,v $
 * Revision 1.3  1992/12/22  15:46:27  jrroma
 * Version 3.30
 *
 * Revision 1.2  92/06/18  13:24:40  jrroma
 * Added gnu header
 * 
 * Revision 1.1  92/06/18  12:47:24  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"
#include <unistd.h>

/*** seekdb
 *
 *
 *	void seekdb():
 *
 *	Seek on the specified NQS database file.
 */
void seekdb (struct confd *file, long newposition)
{
	if (newposition > file->size) newposition = file->size;
	else if (newposition < 0) newposition = 0;
	file->rposition = blockdb (newposition) * ATOMICBLKSIZ;
	file->vposition = newposition;
	if (lseek (file->fd, file->rposition, 0) == -1) {
		printf ("E$Lseek error in seekdb().\n");
		fflush (stdout);
	}
	if (file->rposition < file->size) {
		/*
		 *  The file has at least one block in it that we
		 *  can read.
		 *
		 *  Read the current block into the cache.  We ALWAYS
		 *  throw away the current cache block, since many of
		 *  the NQS utilities scan NQS database files AFTER an
		 *  update has been made BY THE NQS DAEMON, and with-
		 *  out this forced reloading of the cache block, such
		 *  programs would not necessarily get the updated
		 *  version of the database file....
		 */
		if (read (file->fd, file->cache->v.chars,
			  ATOMICBLKSIZ) != ATOMICBLKSIZ) {
			printf ("E$Read error in seekdb().\n");
			fflush (stdout);
		}
		file->rposition += ATOMICBLKSIZ;
	}
}
