/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*++ nqsmail.h - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.30/h/RCS/nqsmail.h,v $
 *
 * DESCRIPTION:
 *
 *	NQS mail suffix codes and mail file definitions.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	April 26, 1986.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.3 $ $Date: 1992/12/22 15:45:21 $ $State: Exp $)
 * $Log: nqsmail.h,v $
 * Revision 1.3  1992/12/22  15:45:21  jrroma
 * Version 3.30
 *
 * Revision 1.2  92/06/18  09:46:23  jrroma
 * Added gnu header
 * 
 * Revision 1.1  92/06/18  09:14:40  jrroma
 * Initial revision
 * 
 *
 */

#ifndef _NQS_MAILH_
#define _NQS_MAILH_
/*
 *	Mail suffix codes.
 */
#define	MSX_ABORTED	0	/* "aborted" */
#define	MSX_ABORTSHUTDN	1	/* "aborted for NQS shutdown" */
#define	MSX_BEGINNING	2	/* "beginning" */
#define	MSX_DELETED	3	/* "deleted" */
#define	MSX_DELIVERED	4	/* "delivered" */
#define	MSX_ENDED	5	/* "ended */
#define	MSX_FAILED	6	/* "files being placed in NQS failed */
				/*  directory" */
#define	MSX_REQUEUED	7	/* "requeued" */
#define	MSX_RESTARTING	8	/* "restarting" */
#define	MSX_MAXMSX	MSX_RESTARTING
				/* Used in ../src/nqs_mai.c */


/*
 *	NQS mail requestlog structure.
 *
 *	This structure is passed to nqs_mai() for both batch and device
 *	requests, to report completion information.  However, this
 *	structure is not stored in permanent memory (i.e. disk), except
 *	for batch requests, which use this structure to preserve information
 *	across crashes and system shutdowns.
 *
 *	WARNING:
 *	    This structure must NOT be larger than ATOMICBLKSIZ bytes
 *	    in size (see ../h/nqs.h) for the crash recovery mechanisms
 *	    of NQS to properly work.  This restriction is verified in
 *	    ../src/nqs_ldconf.c.
 */
struct requestlog {
	short reqrcmknown;		/* Boolean request RCM code known */
	struct servermssg svm;		/* Request completion code and */
					/* server message */
	long outrcmknown;		/* Bit mask of known RCM_ */
					/* stageout event completion codes */
	long outrcm [MAX_OUSTAPERREQ+2];/* RCM_ codes for stageout events */
};

#endif
