/*
 * nqs_generic/all-systems/rcimsgs.c
 * Diagnose request code information (RCI).
 */

#include <nqs_generic/license.h>
  /* NQS license information */
#include <nqs_generic/debug.h>
  /* Debugging support */
#include <nqs_generic/proto.h>
  /* ANSI C prototypes */

#include <stdio.h>		/* FILE definition */
#include <nqs_generic/RCI.h>
  /* NQS information completion codes */
#include <nqs_generic/tblmsgs.h>

static msg_table stRCImsgs [] =
{
  { RCI_ACCESSDEN,	"RCI_ACCESSDEN",	NULL,	"  Access denied;\n"						, NULL },
  { RCI_CLIMIDUNKN,	"RCI_CLIMIDUNKN",	NULL,	"  Client machine-id is unknown at transaction peer;\n"		, NULL },
  { RCI_EFBIG,		"RCI_EFBIG",		NULL,	"  File size limit exceeded;\n"					, NULL },
  { RCI_FATALABORT,	"RCI_FATALABORT",	NULL,	"  Non-recoverable transaction failure;\n"			, NULL },
  { RCI_MIDCONFLICT,	"RCI_MIDCONFLICT",	NULL,	"  Machine-id conflict between client and destination;\n"	, NULL },
  { RCI_NETNOTSUPP,	"RCI_NETNOTSUPP",	NULL,	"  Networking not supported at NQS site.\n"			, NULL },
  { RCI_NETPASSWD,	"RCI_NETPASSWD",	NULL,	"  Network password verification error;\n"			, NULL },
  { RCI_NOSUCHFORM,	"RCI_NOSUCHFORM",	NULL,	"  No such device forms;\n"					, NULL },
  { RCI_NOSUCHQUE,	"RCI_NOSUCHQUE",	NULL,	"  No such queue;\n"						, NULL },
  { RCI_PEERINTERR,	"RCI_PEERINTERR",	NULL,	"  NQS internal error at transaction peer;\n"			, NULL },
  { RCI_PEERMIDUNKN,	"RCI_PEERMIDUNKN",	NULL,	"  Local machine-id is unknown at transaction peer;\n"		, NULL },
  { RCI_PEERNETDB,	"RCI_PEERNETDB",	NULL,	"  Network database error at transaction peer;\n"		, NULL },
  { RCI_PEERNOACATH,	"RCI_PEERNOACATH",	NULL,	"  No account authorization at transaction peer;\n"		, NULL },
  { RCI_PROTOFAIL,	"RCI_PROTOFAIL",	NULL,	"  NQS protocol failure;\n"					, NULL },
  { RCI_QUOTALIMIT,	"RCI_QUOTALIMIT",	NULL,	"  Explicit request quota limits exceed maximums;\n"		, NULL },
  { RCI_RRFUNKNMID,	"RCI_RRFUNKNMID",	NULL,	"  Request refers to mids unknown at transaction peer;\n"	, NULL },
  { RCI_WROQUETYP,	"RCI_WROQUETYP",	NULL,	"  Wrong queue type for request;\n"				, NULL },
  { RCI_UNAFAILURE,	"RCI_UNAFAILURE",	NULL,	"  Unanticipated transaction failure;\n"			, NULL },
  { 0,			NULL,			NULL,	NULL								, NULL }
};

/*** rcimsgs
 *
 *	void rcimsgs():
 *	Diagnose request code information bits.
 */
void rcimsgs (
	long code,		/* Completion code */
	FILE *stream,		/* Output stream */
	char *prefix,		/* Output prefix */
	void (*headerfn)(FILE *, char *))	/* Header display function */
{
  ENTER_FUNCTION("nqs_generic/all-systems/rcimsgs");
    /* Debugging info */
  TEST_ARG(stream   != NULL, 2);
  TEST_ARG(prefix   != NULL, 3);
  TEST_ARG(headerfn != NULL, 4);
    /* ensure we are not working with garbage */
  
  tblmsgs(code, stream, prefix, headerfn, &stRCImsgs[0]);
  EXIT_FUNCTION;
}
