#ifndef __NQS_GENERIC_HEADER
#define __NQS_GENERIC_HEADER

/*
 * nqs_generic/all-systems/nqs_generic.h
 * Generic NQS header file
 */

#include <nqs_generic/license.h>

/*
 * This is a modified version of the header nqs.h from
 * Monsanto-NQS.  Entries in here will migrate to a better
 * home as I work through the source code - Stu.
 */

/*
 * $Source: /usr2/jrroma/nqs/nqs-3.36/h/RCS/nqs.h,v $
 *
 * DESCRIPTION:
 *
 *	NQS daemon constant definitions file.
 *
 *	WARNINGS:
 *	  Eight system types are defined:  BSD43, SGI, SYS53, IBMRS, ULTRIX
 *	  DECOSF, HPUX, & SOLARIS.  Accordingly, the flag: SYSTEM_TYPE
 *	  in the Makefile must be appropriately defined.
 *
 *	  The #define type:  ALIGNTYPE  should be configured for the
 *	  appropriate supporting hardware (see below).
 *
 *	  See the file:
 *
 *		../npsn_compat/ioblksiz.h	(Non-NPSN UNIX systems)
 *
 *	  for the definition of the constant:  ATOMICBLKSIZ, which may
 *	  need to be changed depending upon the configuration of the
 *	  supporting system.
 */

/*
 *
 *	Configurable parameters.  These #defines may be changed on a
 *	per-system basis as necessary.
 *
 *
 *	See also:
 *		/usr/include/ioblksiz.h		(NPSN UNIX systems)
 *
 *
 *	WARNING #1:
 *
 *		Once the NQS configuration database files
 *		have been created, the value of: ATOMICBLKSIZ
 *		as defined in ioblksiz.h (see above comments)
 *		must NEVER change!  To change ATOMICBLKSIZ
 *		after any of the NQS configuration database
 *		files have been created means certain death.
 *		If it becomes necessary to change ATOMICBLKSIZ,
 *		then shutdown NQS, rebuild NQS, delete all of
 *		the NQS configuration database files in the
 *		directory:
 *
 *			/usr/spool/nqs/root/database
 *
 *		restart NQS, and then redefine the NQS
 *		configuration via the qmgr program.
 *
 *		ALL other files can remain untouched, including
 *		the control and data files describing existing
 *		NQS requests.  Any queued requests on the local
 *		host will NOT be damaged by this operation.
 *
 *
 *	We also define which set of resource limits can be enforced by
 *	the supporting UNIX operating system here (see VALID_LIMITS),
 *	and the queue access set uid/gid cluster size (ACCLIST_SIZE).
 *
 *	Lastly, we define several key parameters controlling the
 *	maximum number of running NQS processes, and various transaction
 *	quota parameters.  These parameters are:
 *
 *
 *		MAX_GBLACCLIMIT:
 *			Global maximum number of simultaneous
 *			network connections that will be
 *			accepted by the local NQS network
 *			daemon FROM the progeny of all NQS
 *			daemons at all remote machines.
 *
 *			This value acts only as a ceiling.
 *			Lower values can be configured via
 *			the Qmgr program.
 *
 *		MAX_GBLBATLIMIT:
 *			Global maximum number of simultaneous
 *			running batch requests
 *
 *			This value acts only as a ceiling.
 *			Lower values can be configured via
 *			the Qmgr program.
 *
 *		MAX_GBLPIPLIMIT:
 *			Global maximum number of simultaneous
 *			running pipe queue servers.
 *
 *			This value acts only as a ceiling.
 *			Lower values can be configured via
 *			the Qmgr program.
 *
 *		MAX_GBLNETLIMIT:
 *			Global maximum number of simultaneous
 *			running network queue servers.
 *
 *			This value acts only as a ceiling.
 *			Lower values can be configured via
 *			the Qmgr program.
 *
 *		MAX_NOOFDEVICES:
 *			Global maximum number of NQS devices.
 *
 *		MAX_TRANSACTS:
 *			The maximum number of concurrent
 *			transactions.  Every request on the
 *			system has a transaction descriptor
 *			associated with it.  Thus, the value
 *			of this parameter sets a ceiling on
 *			the maximum number of requests that
 *			can be queued on the local host.
 *
 *			See WARNINGS #2, #3 and #4 if this
 *			value ever needs to be changed.
 *
 *		MAX_EXTREQUESTS:
 *			The maximum number of requests that
 *			can be queued at any given time on
 *			this machine, that have arrived from
 *			other remote machines.
 *
 *			See WARNINGS #2, #3 and #4 if this
 *			value ever needs to be changed.
 *
 *
 *
 *	There are two rules (or warnings), that the NQS system maintainer
 *	must observe when changing any of these parameters:
 *
 *
 *	    WARNING #2:
 *
 *		The following relation must hold:
 *
 *			MAX_EXTREQUESTS <= MAX_TRANSACTS.
 *
 *
 *	    WARNING #3:
 *
 *		Any change of:  MAX_TRANSACTS  must be CAREFULLY
 *		considered.  If there are any NQS requests present
 *		on the local host, then the value of MAX_TRANSACTS
 *		can only be INCREASED.  The presence of one or more
 *		requests on the local host DISALLOWS the possibility
 *		of MAX_TRANSACTS being DECREASED.
 *		  
 *		If MAX_TRANSACTS must be INCREASED, then NQS must be
 *		recompiled when the editing of this file is complete.
 *		When recompilation is complete, NQS must be shutdown,
 *		and reinstalled (while running as root) by the command:
 *
 *			make -f Makefile install
 *
 *		Then, the additional 'make' command of:
 *
 *			make -f Makefile transactions
 *
 *		must also be issued (again while running as root).
 *		At this point, the NQS daemon can be restarted and
 *		the effort is complete.
 *
 *		ALL other files can remain untouched, including the
 *		control and data files describing existing NQS
 *		requests.  Any queued requests on the local host
 *		will NOT be damaged by an INCREASE of MAX_TRANSACTS.
 *
 *		If it becomes necessary to reduce MAX_TRANSACTS,
 *		then the system maintainer(s) must follow the steps
 *		for INCREASING the value of MAX_TRANSACTS, with the
 *		exception that all requests queued on the local
 *		system, and all transaction descriptors on the local
 * 		system must be deleted, prior to the issuance of the
 *		command:
 *
 *			make -f Makefile transactions
 *
 *		Reducing the value of MAX_TRANSACTS essentially
 *		requires that NQS be reinstalled almost from scratch.
 *
 *
 *	    WARNING #4:
 *
 *		Any change of MAX_EXTREQUESTS must also be carefully
 *		considered.  Any INCREASE in this value is always
 *		perfectly safe.  There is a danger however in
 *		DECREASING this value.
 *
 *		One can only reduce MAX_EXTREQUESTS if one knows that
 *		the number of requests currently queued on the local
 *		system is LESS THAN or EQUAL TO the reduced value of
 *		MAX_EXTREQUESTS.  If this condition is not true, then
 *		NQS will be unable to requeue all of the requests upon
 *		rebooting.
 *
 *
 */

#include <SETUP/SETUP.h>
  /* Include variables created by SETUP software. */

#define	ALIGNTYPE	long		/* Machine-alignment type */
#define ATOMICBLKSIZ	1024		/* we use 1K blocks	*/

#if	BSD43 | ULTRIX | DECOSF		/* Berkeley UNIX and ULTRIX */
#define	VALID_LIMITS	(LIM_PPCORE | LIM_PPDATA | LIM_PPPFILE | \
			 LIM_PPSTACK | LIM_PPWORK | LIM_PPCPUT | LIM_PPNICE)
#define ACCLIST_SIZE	13
#define	MAX_GBLACCLIMIT	10
#define	MAX_GBLBATLIMIT 10
#define	MAX_GBLPIPLIMIT 5
#define	MAX_GBLNETLIMIT	10
#define	MAX_NOOFDEVICES	10
#define	MAX_TRANSACTS	200		/* See WARNINGS #2, #3, #4 at the */
#define	MAX_EXTREQUESTS	200		/* beginning of this file before */
					/* changing any of these parameters */
#else
#if	SGI				/* Silicon Graphics Iris UNIX */
#define	VALID_LIMITS	(LIM_PPCORE | LIM_PPDATA | LIM_PPPFILE | \
			 LIM_PPSTACK | LIM_PPWORK | LIM_PPCPUT | LIM_PPNICE)
/*   #define	VALID_LIMITS	(LIM_PPPFILE | LIM_PPNICE) */
#define ACCLIST_SIZE	13
#define	MAX_GBLACCLIMIT	10
#define	MAX_GBLBATLIMIT 10
#define	MAX_GBLPIPLIMIT 5
#define	MAX_GBLNETLIMIT	10
#define	MAX_NOOFDEVICES	10
#define	MAX_TRANSACTS	200		/* See WARNINGS #2, #3, #4 at the */
#define	MAX_EXTREQUESTS	160		/* beginning of this file before */
					/* changing any of these parameters */
#else
#if     SOLARIS | LINUX                 /* Sun Solaris UNIX */
#define VALID_LIMITS    (LIM_PPCORE | LIM_PPDATA | LIM_PPPFILE | \
                         LIM_PPSTACK | LIM_PPWORK | LIM_PPCPUT | LIM_PPNICE)
/*   #define    VALID_LIMITS    (LIM_PPPFILE | LIM_PPNICE) */
#define ACCLIST_SIZE    13
#define MAX_GBLACCLIMIT 10
#define MAX_GBLBATLIMIT 10
#define MAX_GBLPIPLIMIT 5
#define MAX_GBLNETLIMIT 10
#define MAX_NOOFDEVICES 10
#define MAX_TRANSACTS   200             /* See WARNINGS #2, #3, #4 at the */
#define MAX_EXTREQUESTS 160             /* beginning of this file before */
                                        /* changing any of these parameters */
#define SOLARIS_OPEN_MAX    100		/* Maximum open files for Solaris */
					/*      *** KLUDGE ***            */
#else
#if	HPUX				/* Hewlett Packard UNIX */
#define	VALID_LIMITS	(LIM_PPCORE | LIM_PPDATA | LIM_PPPFILE | \
			 LIM_PPSTACK | LIM_PPWORK | LIM_PPCPUT | LIM_PPNICE)
/*   #define	VALID_LIMITS	(LIM_PPPFILE | LIM_PPNICE) */
#define ACCLIST_SIZE	13
#define	MAX_GBLACCLIMIT	10
#define	MAX_GBLBATLIMIT 10
#define	MAX_GBLPIPLIMIT 5
#define	MAX_GBLNETLIMIT	10
#define	MAX_NOOFDEVICES	10
#define	MAX_TRANSACTS	200		/* See WARNINGS #2, #3, #4 at the */
#define	MAX_EXTREQUESTS	160		/* beginning of this file before */
					/* changing any of these parameters */
#else
#if	SYS52 | SYS53 			/* AT&T UNIX */
#define	VALID_LIMITS	(LIM_PPPFILE | LIM_PPNICE)
#define ACCLIST_SIZE	13
#define	MAX_GBLACCLIMIT	10
#define	MAX_GBLBATLIMIT 10
#define	MAX_GBLPIPLIMIT 5
#define	MAX_GBLNETLIMIT	10
#define	MAX_NOOFDEVICES	10
#define	MAX_TRANSACTS	500		/* See WARNINGS #2, #3, #4 at the */
#define	MAX_EXTREQUESTS	400		/* beginning of this file before */
					/* changing any of these parameters */
#else
#if	IBMRS				/* IBM RS6000 AIX  */
#define	VALID_LIMITS	(LIM_PPCORE | LIM_PPDATA | LIM_PPPFILE | \
			 LIM_PPSTACK | LIM_PPWORK | LIM_PPCPUT | LIM_PPNICE)
/*  #define	VALID_LIMITS	(LIM_PPPFILE | LIM_PPNICE) */
#define ACCLIST_SIZE	13
#define	MAX_GBLACCLIMIT	10
#define	MAX_GBLBATLIMIT 10
#define	MAX_GBLPIPLIMIT 5
#define	MAX_GBLNETLIMIT	10
#define	MAX_NOOFDEVICES	10
#define	MAX_TRANSACTS	500		/* See WARNINGS #2, #3, #4 at the */
#define	MAX_EXTREQUESTS	400		/* beginning of this file before */
					/* changing any of these parameters */
#else
#endif
#endif
#endif
#endif
#endif
#endif

#if	IRIX5
#define _KMEMUSER
#endif
#include	<sys/types.h>		/* Get time_t definition */
#include 	<stdio.h>
#include	<nmap/nmap.h>		/* Network mapping definitions */
#include	<nqs_queue/quolim.h>	/* Quota limit definitions */

/*
 *	More configurable parameters.
 */
#define	ABORT_WAIT	60		/* Default time in secs to wait after */
					/* sending SIGTERM to all processes */
					/* for each req running in a queue */
					/* for which a PKT_ABOQUE packet */
					/* (see ../h/nqspacket.h) has */
					/* been received.  At the end of this */
					/* time, any remaining processes for */
					/* the queue in question receive a */
					/* SIGKILL signal.... */
#define	BSET_CPUVECSIZE	8		/* Size of bit-vector for CPU */
					/* resource allocation for a batch */
					/* queue (cardinality of set is */
					/* BSET_CPUVECSIZE * sizeof (ulong) */
					/* in bits) */
					/* *** WARNING *** */
					/* If this value is changed, then */
					/* the queues file will have to be */
					/* rebuilt.... */
#define	BSET_RS1VECSIZE	4		/* Size of bit-vector for RESERVED */
#define	BSET_RS2VECSIZE	4		/* resource allocation (types 1, 2) */
					/* for a batch queue (set cardinality*/
					/* is BSET_RS1VECSIZE * sizeof(ulong)*/
					/* in bits) */
					/* *** WARNING *** */
					/* If these values are changed, then */
					/* the queues file will have to be */
					/* rebuilt.... */
#define	EXPIRATION_SCAN	3600		/* Number of seconds to wait between */
					/* scanning for expired requests */
#define	MAX_COMPLXSPERQ	4		/* Maximum number of queue complexes */
					/* of which a given batch queue can */
					/* be a member */
#define	MAX_CTRLSUBDIRS	30		/* Number of ctrl file subdirs */
					/* *** WARNING *** */
					/* If this parameter is changed */
					/* AFTER NQS has already been */
					/* installed, then NQS must be */
					/* REINSTALLED.  Don't change this */
					/* unless you are compelled to do so.*/
#define	MAX_DATASUBDIRS	30		/* Number of data file subdirs */
					/* *** WARNING *** */
					/* (See WARNING for MAX_CTRLSUBDIRS) */
#define	MAX_ENVIRONMENT	5120		/* The maximum #of chars allowed */
					/* in the environment */
#define	MAX_ENVIRONVARS	400		/* Maximum #of environment vars for */
					/* a request server */
					/* WARNING: This value MUST be >= */
					/* MAX_QDESTS+6. */
#define	MAX_MACHINENAME	255		/* Longest acceptable machine-name */
#if	HPUX | SGI | SOLARIS | SYS52 | SYS53 | IBMRS | LINUX
#define	MAX_NICE	19		/* Maximum nice-value for local host */
#else
#if	BSD43 | ULTRIX | DECOSF
#define	MAX_NICE	20		/* Maximum nice-value for local host */
#else
BAD SYSTEM TYPE
#endif
#endif
#define	MIN_NICE	(-20)		/* Minimum nice-value for local host */

#define MIN_QUENDP 128			/* Minimum queue nondegrading pri */
#define MAX_QUENDP 254			/* Maximum queue nondegrading pri */

#define	MAX_OUTPSUBDIRS	30		/* Number of output file subdirs */
					/* *** WARNING *** */
					/* (See WARNING for MAX_CTRLSUBDIRS) */
#define	MAX_PATHNAME	255		/* Longest pathname supported by NQS */
					/* with the exception of MAX_REQPATH*/
#define	MAX_QCOMPLXNAME	15		/* Maximum length of a queue complex */
					/* name */
					/* *** WARNING *** */
					/* If this parameter is changed, */
					/* then the queue complex file will */
					/* have to be rebuilt */
#define	MAX_QDESTS	100		/* Maximum number of queue destina- */
					/* tions allowed for a pipe queue. */
					/* WARNING: This value MUST be <= */
					/* MAX_ENVIRONVARS. */
					/* WARNING: The queue destination */
					/* set for a queue server is passed */
					/* via the environment set.  This */
					/* value must not be so large as to */
					/* exceed the maximum environment */
					/* size of 5,120 bytes on many */
					/* UNIX systems.  Each destination */
					/* entry in the environment for a */
					/* for a pipe-queue server takes */
					/* up to 42-bytes. */
#define	MAX_QPRIORITY	63		/* The maximum priority that can be */
					/* assigned to an NQS queue.  This */
					/* value MUST be in the range: */
					/* [0..Max_int] */
#define	MAX_QSPERCOMPLX	15		/* Maximum number of queues per */
					/* batch queue complex */
					/* *** WARNING *** */
					/* If this parameter is changed, */
					/* then the queue complex file will */
					/* have to be rebuilt */
#define	MAX_SERVERARGS	63		/* Maximum number of server arguments,*/
					/* including the server pathname. */
					/* WARNING: This constant MUST be */
					/* >= 2.  Code in nqs_reqser.c depends*/
					/* on this boundary condition */
#define	MAX_SERVERNAME	127		/* Maximum length of NQS server name */
#define	MAX_SERVMESSAGE	100		/* Maximum length of an NQS server */
					/* message */
#define	MAX_STATMSG	41		/* Maximum length of an NQS device */
					/* server status message */
#define MAX_SERVERPERF  1024		/* Maximum allowable server performance */
#define	MAX_TDSCSUBDIRS	30		/* Number of transaction descriptor */
					/* subdirectories */
					/* *** WARNING *** */
					/* (See WARNING for MAX_CTRLSUBDIRS) */
#define MAKEGID		020000000000L	/* Store gids with this bit on */
#define	QAFILE_CACHESIZ	512		/* This many gids and uids are */
					/* read or written at a time */
					/* for a queue access file */
#define	QOFILE_CACHESIZ	100		/* This many queue entries are */
					/* are read or written at a time */
					/* for a queue ordering file */
#define	RESOURCE_WAIT	120		/* Number of seconds to wait for a */
					/* resource between attempts to get */
					/* the resource (see */
					/* ../src/netclient.c) */
#define	SHUTDOWN_WAIT	60		/* Default time in secs to wait after */
					/* sending SIGTERM to all processes */
					/* for each req running in any queue */
					/* upon reception of a PKT_SHUTDOWN */
					/* packet (see ../h/nqspacket.h). */
					/* At the end of this time, all */
					/* remaining processes of any */
					/* remaining NQS reqs receive a */
					/* SIGKILL signal. */
#define SOCKBUFSIZ	4096		/* When writing to a socket, */
					/* buffer to 4096 characters */
#define	TERMSIG_DEFAULT	9		/* Default signal sent to the pgrp */
					/* of an exiting request (SIGKILL) */
#define LOAD_NO_JOBS 9999		/* Flag indicating no job information */
/*
 *	These #defines should NEVER be changed.
 *
 *	ALL of the #defines below configure maximums which MUST be of
 *	identical value on ALL NQS machines.  If the maximum values
 *	are not identical, then it becomes impossible to safely pass
 *	requests between NQS machines.
 *
 *	Furthermore, some of these #defines should NEVER be changed
 *	for implementation reasons.
 *
 *	I repeat.  Do not change any of these #defines.
 */
#define	MAX_ACCOUNTNAME	15		/* Maximum number of chars in an */
					/* account-name (7 extra for UNIX */
					/* implementations) */
#define	MAX_COPIES	32767		/* The maximum #of output copies for */
					/* a device request.  This value */
					/* MUST be in the range: [0..Max_int]*/
#define	MAX_DEVNAME	15		/* Longest shorthand device name */
#define	MAX_DEVPREF	4		/* Maximum number of devices in a */
					/* device request preference list */
#define	MAX_FORMNAME	15		/* Longest forms name */
#define	MAX_INSTAPERREQ	29		/* Maximum number of stage-in events */
					/* per-request.  The present */
					/* implementation will break if */
					/* this number is larger than 32.... */
#define	MAX_NETPASSWORD	15		/* Maximum size of an NQS network */
					/* connection password */
#define	MAX_OUSTAPERREQ	29		/* Maximum number of stage-out files */
					/* per-request.  The present */
					/* implementation will break if */
					/* this number is larger tnan 29.... */
#define	MAX_PACKET	4096		/* The maximum number of bytes that */
					/* can be contained in an NQS */
					/* inter-process communication */
					/* packet.  This value CANNOT and */
					/* MUST not be greater than 8k */
					/* (8192).  See ../lib/interwrite.c */
					/* and ../lib/interread.c.  */
					/* For System V based implementa- */
					/* tions of NQS, this value also */
					/* CANNOT be greater than the named- */
					/* pipe buffersize on the supporting */
					/* local system (usually 5120 bytes),*/
					/* in order to write packets to the */
					/* local NQS daemon in an indivisi- */
					/* ble fashion.  */
					/* For similar reasons, Berkeley */
					/* implementations of NQS cannot */
					/* have a MAX_PACKET value any */	
					/* than 4096.  */
					/* It is also EXTREMELY important */
					/* that this size be large enough */
					/* to accomodate the largest */
					/* message packet that might be sent.*/
					/* To summarize, do NOT ever change */
					/* this number! */
#define	MAX_PKTINTEGERS	150		/* The maximum number of integers */
					/* that can be contained in an NQS */
					/* inter-process communication */
					/* message packet.  This value */
					/* CANNOT be greater than 255. */
#define	MAX_PKTSTRINGS	150		/* The maximum number of strings */
					/* that can be contained in an NQS */
					/* inter-process communication */
					/* message packet.  This value */
					/* CANNOT be greater than 255. */
#define	MAX_PREDECESSOR	4		/* Maximum number of request */
					/* predecessors */
#define	MAX_QUEUENAME	31		/* Longest queue name */
#define	MAX_REQNAME	63		/* Longest request name */
#define	MIN_REQNICE	(-127)		/* Minimum request nice value */
#define	MAX_REQNICE	127		/* Maximum request nice value */
#define	MAX_REQPATH	1023		/* Longest batch request output file */
					/* path name or staged-file path name */
					/* excluding any explicit machine */
					/* name specification of the form: */
					/* <machine-name>:<path/filename> */
#define	MAX_RPRIORITY	63		/* Intra-queue req request priorities */
					/* are in the range [0..63], 63 */
					/* being the highest.  */
#define MAX_POSIX_RPRIORITY 1023	/* Maximum POSIX intra-queue priority */
#define	MAX_SEQNO_USER	99999		/* Seq# for batch and device requests*/
					/* are in [0..MAX_SEQNO_USER] */
#define	MAX_SHELLNAME	63		/* Maximum length of a shell spec */
					/* on a Qsub or Qmod command line */
#define	TRANS_TIMEOUT	240		/* Number of seconds allowed to */
					/* complete a remote transaction */


/*
 *	ALL of the remaining #defines in this header file are not
 *	configurable, unless of course the affected implementation
 *	of NQS is changed appropriately.
 *
 *
 *	File descriptors.
 */
#define	STDIN		0		/* Standard-input is fd 0 */
#define	STDOUT		1		/* Standard-output is fd 1 */
#define	STDERR		2		/* Standard-error is fd 2 */

#include <nqs_queue/QUE.h>
  /* Queue status flags */
#include <nqs_queue/DEV.h>
  /* Device status flags */
#include <nqs_queue/PIPE.h>
  /* Pipe queue destination status flags */

/*
 *	NQS Queue manager Qmgr) privilege flags.
 */
#define	QMGR_OPER_PRIV	0000001		/* Account has operator privileges */
#define	QMGR_MGR_PRIV	0000002		/* Account has manager privileges */

#include <nqs_queue/SHELL.h>
  /* Shell strategy flags */
#include <nqs_db/PRM.h>
  /* NQS record types */

/*
 *	NQS database descriptor types:
 */
#define	DSC_QUEUE	0		/* Queue descriptor */
#define	DSC_DEVICE	1		/* Device descriptor */
#define	DSC_QMAP	2		/* Queue/device mapping descriptor */
#define	DSC_PIPEQDEST	3		/* Pipe queue destination descriptor */
#define	DSC_PARAM	4		/* General parameter descriptor */
#define	DSC_MGR		5		/* NQS manager account-name descriptor*/
#define	DSC_FORM	6		/* NQS forms descriptor */
#define DSC_QCOMPLEX    7               /* Queue complex descriptor */
#define DSC_SERVER	8		/* Compute server descriptor */

#include <nqs_queue/SHO.h>
  /* show selection flags */
#include <nqs_queue/SEL.h>
  /* Request selection type */
#include <nqs_queue/RQF.h>
  /* request flags */
#include <nqs_queue/TRA.h>
  /* transaction types */
#include <nqs_queue/RQS.h>
  /* request queue states */
#include <nqs_queue/RTS.h>
  /* request transaction states */
#include <nqs_queue/RTYPE.h>
  /* request type specifiers */
#include <nqs_queue/OMD.h>
  /* request output mode specifiers */
#include <nqs_queue/REQ.h>
  /* request header magic number(s) */

#include <nqs_queue/LIM.h>
  /* resource limits */
#include <nqs_queue/MEMDUMP.h>
  /* memdump flags */

/*
 * Flags for commands to start / stop daemons.
 */
#define START_DAEMON 1
#define STOP_DAEMON 2

#define LOAD_DAEMON 1
#define NET_DAEMON 2

/*
 *      Additions for NAS NQS
 */
#define NQS_VERSION "3.50.0"               /* version number for NQS */
#define SUCCESS 0
#define FAILURE -1
/*
 * NQS Daemon independent directory structure definitions.
 */
#define LIBDIR 0			/* NQS Library directory flag */
#define MAPDIR 1			/* NQS Network map directory flag */
#define SPOOLDIR 2			/* NQS Spool directory flag */

#define SEQNO_TOKEN '#'			/* Token for sequence number in */
					/* stdout/stderr file name */
/*
 *	All NQS constants are now defined.
 *	Include the NQS data structure definitions file.
 */
#include <nqs_generic/nqsstruct.h>	/* Data structure definitions */
#include <nqs_mail/nqsmail.h>
/*
 * Include anything else we need before the prototypes
 */
#include <pwd.h>
#include <time.h>
#include <sys/stat.h>
#if     HPUX | SGI | SOLARIS | SYS52 | IBMRS | LINUX
#include <sys/times.h>                  /* Get struct tms definition */
#include <fcntl.h>                      /* O_CREAT etc. for accounting */
#else
#if     BSD43 | ULTRIX | DECOSF
#include <sys/time.h>
#include <sys/resource.h>               /* Get struct rusage definition */
#include <sys/file.h>                   /* O_CREAT etc. for accounting */
#include <stdlib.h>			/* Fix malloc calls */
#else
BAD SYSTEM TYPE
#endif
#endif

#include <nqs_generic/proto.h>

#endif /* __NQS_GENERIC_HEADER */