/*
 * nqs_generic/all-systems/fmtmidname.c
 * Format an mid_t type.
 */

#include <nqs_generic/license.h>
  /* NQS license information */
#include <nqs_generic/debug.h>
  /* debugging support */
#include <nqs_generic/proto.h>
  /* ANSI C prototypes */
#include <stdio.h>

#include <sys/types.h>
#include <nmap/nmap.h>
  /* Include network mapping definitions */

/*** fmtmidname
 *
 *	char *fmtmidname():
 *
 *	Return a pointer to the principal name of the machine
 *	identified by the specified machine-id.
 */
char *fmtmidname (Mid_t mid)
{
  static char szStandInBuf [14];
    /* Stand-in buffer */
  register char *szName;
    /* Pointer to name */
  
  ENTER_FUNCTION("nqs_generic/all-systems/fmtmidname");
  DEBUGGING(INFO, DEBUG_HIGH, "This routine is due for removal soon\n");
    /* 
     * This is a high priority to annoy people, so that they annoy me
     * to actually get this done ;-)
     */
  
  szName = nmap_get_nam (mid);
  if (szName == NULL)
  {
    /*
     *  No such machine!  Format a "stand-in" name.
     */
    
    sprintf (szStandInBuf, "[%1lu]",  mid);
    szName = szStandInBuf;
  }
  return (szName);
}
