/*
 * nqs_generic/all-systems/bytecopy.c
 * Copy n bytes around the place.
 */

#include <nqs_generic/license.h>
  /* NQS license information */
#include <nqs_generic/debug.h>
  /* debugging support */
#include <nqs_generic/proto.h>
  /* ANSI C prototypes */
#include <string.h>
#include <stdlib.h>
#include <assert.h>

/*** bytecopy
 *
 *	bytecopy():
 *	Copy exactly N bytes.
 */
void bytecopy (char *to, char *from, int n)
{
  ENTER_FUNCTION("nqs_generic/all-systems/bytecopy");
  
  TEST_ARG(to   != NULL, 1);
  TEST_ARG(from != NULL, 2);
  TEST_ARG(n    >  0,    3);
  
  memmove((void *) to, (void *) from, (size_t) n);
  
  EXIT_FUNCTION;
}
