/*
 * nqs_generic/all-systems/tcmmsgs.c
 * Output TCM messages
 */

#include <nqs_generic/license.h>
  /* NQS license information */
#include <nqs_generic/debug.h>
  /* NQS debugging information */
#include <nqs_generic/proto.h>
  /* ANSI C prototype information */

#include <stdio.h>		/* FILE definition */

#include <nqs_generic/XCI.h>
  /* NQS information completion codes */
#include <nqs_req/TCM.h>
  /* NQS transaction completion codes */
#include <nqs_generic/tblmsgs.h>

static char szRetry[]    = "Retry later.\n";
static char szSeekHelp[] = "Seek staff support.\n";
  /* These are used in the table below */

static msg_table stTCMtbl [] =
{
  MSGTBLE_2(TCML_ACCESSDEN,	TCMP_ACCESSDEN,		NULL,	"Access denied", 									NULL		),
  MSGTBLE  (TCML_ALREADACC,				NULL,	"Already has access", 									NULL		),
  MSGTBLE  (TCML_ALREADEXI,				NULL,	"Already exists", 									NULL		),
  MSGTBLE_2(TCML_BADCDTFIL,	TCMP_BADCDTFIL,		NULL,	"Corrupt request control/data file(s) detected",					szSeekHelp	),
  MSGTBLE  (TCMP_CLIMIDUNKN,				NULL,	"Client machine-id unknown",								szSeekHelp	),
  MSGTBLE_2(TCML_COMPLETE,	TCMP_COMPLETE,		NULL,	"Transaction complete",									NULL		),
  MSGTBLE  (TCMP_CONNBROKEN,				NULL,	"Network connection lost",								szRetry		),
  MSGTBLE  (TCMP_CONNTIMOUT,				NULL,	"Network connection timeout",								szRetry		),
  MSGTBLE  (TCMP_CONTINUE,				NULL,	"Subtransaction complete",								NULL		),
  MSGTBLE  (TCML_CPUALRESVD,				NULL,	"CPU already allocated to another queue",						NULL		),
  MSGTBLE  (TCML_DEVACTIVE,				NULL,	"Device is active",									NULL		),
  MSGTBLE  (TCML_DEVENABLE,				NULL,	"Device is enabled",									NULL		),
  MSGTBLE_2(TCML_EACCESS,	TCMP_EACCESS,		NULL,	"File access denied",									NULL		),
  MSGTBLE_2(TCML_EFBIG,		TCMP_EFBIG,		NULL,	"File size limit exceeded",								NULL		),
  MSGTBLE_2(TCML_EISDIR,	TCMP_EISDIR,		NULL,	"Operation on directory is prohibited",							NULL		),
  MSGTBLE_2(TCML_ELOOP,		TCMP_ELOOP,		NULL,	"Symbolic link translation limit exceeded",						NULL		),
  MSGTBLE_2(TCML_ENFILE,	TCMP_ENFILE,		NULL,	"Insufficient file descriptors",							szRetry		),
  MSGTBLE_2(TCML_ENOBUFS,	TCMP_ENOBUFS,		NULL,	"Insufficient buffer space",								szRetry		),
  MSGTBLE_2(TCML_ENOENT,	TCMP_ENOENT,		NULL,	"Component in file path does not exist",						NULL		),
  MSGTBLE_2(TCML_ENOMEM,	TCMP_ENOMEM,		NULL,	"Insufficient memory",									szRetry		),
  MSGTBLE_2(TCML_ENOSPC,	TCMP_ENOSPC,		NULL,	"File system resource shortage",							szRetry		),
  MSGTBLE_2(TCML_ENOTDIR,	TCMP_ENOTDIR,		NULL,	"Invalid file path",									NULL		),
  MSGTBLE_2(TCML_ENXIO,		TCMP_ENXIO,		NULL,	"Device error",										szSeekHelp	),
  MSGTBLE_2(TCML_EPERM,		TCMP_EPERM,		NULL,	"Permission denied",									NULL		),
  MSGTBLE_2(TCML_EPIPE,		TCMP_EPIPE,		NULL,	"FIFO error",										szSeekHelp	),
  MSGTBLE_2(TCML_EROFS,		TCMP_EROFS,		NULL,	"Attempt to modify a readonly file system",						NULL		),
  MSGTBLE_2(TCML_ERRORRETRY,	TCMP_ERRORRETRY,	NULL,	"Recoverable transaction failure",							szRetry		),
  MSGTBLE  (TCML_ETIMEDOUT,				NULL,	"Connect(2) timeout",									szRetry		),
  MSGTBLE_2(TCML_ETXTBSY,	TCMP_ETXTBSY,		NULL,	"Text file operation denied",								szRetry		),
  MSGTBLE_2(TCML_FATALABORT,	TCMP_FATALABORT,	NULL,	"Non-recoverable transaction failure",							NULL		),
  MSGTBLE  (TCML_FIXBYNQS,				NULL,	"Limit set to enforeable value other than originally requested",			NULL		),
  MSGTBLE  (TCML_GRANFATHER,				NULL,	"Transaction successful, but one or more requests were given a grandfather clause",	NULL		),
  MSGTBLE  (TCML_INSHUTDOWN,				NULL,	"NQS is shutting down",									NULL		),
  MSGTBLE_2(TCML_INSQUESPA,	TCMP_INSQUESPA,		NULL,	"Insufficient space to queue request",							NULL		),
  MSGTBLE  (TCML_INSUFFMEM,				NULL,	"Insufficient memory",									NULL		),
  MSGTBLE  (TCML_INSUFFPRV,				NULL,	"Insufficient privilege",								NULL		),
  MSGTBLE_2(TCML_INTERNERR,	TCMP_INTERNERR,		NULL,	"Internal NQS error",									szSeekHelp	),
  MSGTBLE  (TCML_LOGFILERR,				NULL,	"Cannot open or create new logfile",							NULL		),
  MSGTBLE  (TCMP_MAXNETCONN,				NULL,	"Maximum network connection limit reached",						szRetry		),
  MSGTBLE  (TCML_MAXQDESTS,				NULL,	"Maximum destination set cardinality reached",						NULL		),
  MSGTBLE  (TCMP_MIDCONFLCT,				NULL,	"Machine-id conflict between client and peer",						szSeekHelp	),
  MSGTBLE_2(TCML_NETDBERR,	TCMP_NETDBERR,		NULL,	"Local network database error",								szSeekHelp	),
  MSGTBLE  (TCML_NETNOTSUPP,				NULL,	"Networking not supported by implementation",						NULL		),
  MSGTBLE  (TCMP_NETPASSWD,				NULL,	"NQS Network password verification failure",						szSeekHelp	),
  MSGTBLE_2(TCML_NOACCAUTH,	TCMP_NOACCAUTH,		NULL,	"No account authorisation",								NULL		),
  MSGTBLE  (TCML_NOACCNOW,				NULL,	"Does not have access now",								NULL		),
  MSGTBLE_2(TCML_NOESTABLSH,	TCMP_NOESTABLSH,	NULL,	"Unable to make connection with NQS daemon",						szSeekHelp	),
  MSGTBLE_2(TCML_NOLOCALDAE,	TCMP_NOLOCALDAE,	NULL,	"NQS local daemon is not present",							szSeekHelp	),
  MSGTBLE_2(TCML_NOMOREPROC,	TCMP_NOMOREPROC,	NULL,	"Insufficient processes to perform transaction",					szRetry		),
  MSGTBLE  (TCMP_NONETDAE,				NULL,	"NQS network daemon is not present",							szSeekHelp	),
  MSGTBLE  (TCMP_NONSECPORT,				NULL,	"Non-secure network port verification error",						szSeekHelp	),
  MSGTBLE  (TCML_NOPORTAVAI,				NULL,	"No network port available",								szRetry		),
  MSGTBLE  (TCML_NOSUCHACC,				NULL,	"No such account",									NULL		),
  MSGTBLE  (TCML_NOSUCHCPU,				NULL,	"No such CPU",										NULL		),
  MSGTBLE  (TCML_NOSUCHDES,				NULL,	"No such destination",									NULL		),
  MSGTBLE  (TCML_NOSUCHDEV,				NULL,	"No such device",									NULL		),
  MSGTBLE_2(TCML_NOSUCHFORM,	TCMP_NOSUCHFORM,	NULL,	"No such form",										NULL		),
  MSGTBLE  (TCML_NOSUCHGRP,				NULL,	"No such group",									NULL		),
  MSGTBLE  (TCML_NOSUCHMAC,				NULL,	"No such machine",									NULL		),
  MSGTBLE  (TCML_NOSUCHMAN,				NULL,	"No such manager/operator",								NULL		),
  MSGTBLE  (TCML_NOSUCHMAP,				NULL,	"No such mapping",									NULL		),
  MSGTBLE_2(TCML_NOSUCHQUE,	TCMP_NOSUCHQUE,		NULL,	"No such queue",									NULL		),
  MSGTBLE  (TCML_NOSUCHQUO,				NULL,	"No such quota supported",								NULL		),
  MSGTBLE_2(TCML_NOSUCHREQ,	TCMP_NOSUCHREQ,		NULL,	"No such request",									NULL		),
  MSGTBLE_2(TCML_NOSUCHSIG,	TCMP_NOSUCHSIG,		NULL,	"No such signal",									NULL		),
  MSGTBLE_2(TCML_NOTREQOWN,	TCMP_NOTREQOWN,		NULL,	"Not request owner",									NULL		),
  MSGTBLE_2(TCML_PATHLEN,	TCMP_PATHLEN,		NULL,	"Resolved output filename for batch request exceeds the maximum supported path length",	NULL		),
  MSGTBLE  (TCML_PEERARRIVE,				NULL,	"Request arriving",									NULL		),
  MSGTBLE  (TCML_PEERDEPART,				NULL,	"Request departing",									NULL		),
  MSGTBLE  (TCML_PLOCKFAIL,				NULL,	"NQS daemon call to plock() failed",							NULL		),
  MSGTBLE_2(TCML_PROTOFAIL,	TCMP_PROTOFAIL,		NULL,	"NQS protocol failure",									szSeekHelp	),
  MSGTBLE_2(TCML_QUEDISABL,	TCMP_QUEDISABL,		NULL,	"Queue is disabled",									szRetry		),
  MSGTBLE  (TCML_QUEENABLE,				NULL,	"Queue is enabled",									NULL		),
  MSGTBLE  (TCML_QUEHASREQ,				NULL,	"Queue has request(s)",									NULL		),
  MSGTBLE_2(TCML_QUOTALIMIT,	TCMP_QUOTALIMIT,	NULL,	"Explicit request quota limits exceed maximums",					NULL		),
  MSGTBLE_2(TCML_REQCOLLIDE,	TCMP_REQCOLLIDE,	NULL,	"Attempt to queue already existing request",						NULL		),
  MSGTBLE_2(TCML_REQDELETE,	TCMP_REQDELETE,		NULL,	"Request deleted",									NULL		),
  MSGTBLE_2(TCML_REQRUNNING,	TCMP_REQRUNNING,	NULL,	"Request is running",									NULL		),
  MSGTBLE_2(TCML_REQSIGNAL,	TCMP_REQSIGNAL,		NULL,	"Request was running and has been signalled",						NULL		),
  MSGTBLE  (TCML_ROOTINDEL,				NULL,	"Root cannot be deleted",								NULL		),
  MSGTBLE  (TCMP_RRFUNKNMID,				NULL,	"Request refers to unknown machines",							NULL		),
  MSGTBLE_2(TCML_SELMIDUNKN,	TCMP_SELMIDUNKN,	NULL,	"Local machine-id unknown",								szSeekHelp	),
  MSGTBLE  (TCML_SELREFDES,				NULL,	"Attempt to create self-referential destination",					NULL		),
  MSGTBLE  (TCML_SHUTERROR,				NULL,	"Shutdown error",									NULL		),
  MSGTBLE_2(TCML_SUBMITTED,	TCMP_SUBMITTED,		NULL,	"Request successfully submitted",							NULL		),
  MSGTBLE  (TCML_TOOMANDEV,				NULL,	"Too many devices",									NULL		),
  MSGTBLE_2(TCML_UNAFAILURE,	TCMP_UNAFAILURE,	NULL,	"Unanticipated transaction failure",							NULL		),
  MSGTBLE_2(TCML_UNDEFINED,	TCMP_UNDEFINED,		NULL,	"Undefined transaction code",								szSeekHelp	),
  MSGTBLE  (TCML_UNRESTR,				NULL,	"Access is currently unrestricted",							NULL		),
  MSGTBLE_2(TCML_WROQUETYP,	TCMP_WROQUETYP,		NULL,	"Wrong queue type for transaction",							NULL		),
  MSGTBLE  (TCML_NOSUCHCOM,				NULL,	"Queue complex does not exist",								NULL		),
  MSGTBLE  (TCML_TOOMANQUE,				NULL,	"Too many queues defined for a queue complex",						NULL		),
  MSGTBLE  (TCML_TOOMANCOM,				NULL,	"Too many queue complexes defined for a queue",						NULL		),
  MSGTBLE  (TCML_ALREADCOM,				NULL,	"Queue is already a member of the queue complex",					NULL		),
  MSGTBLE  (TCML_NOTMEMCOM,				NULL,	"Queue is not a member of the queue complex",						NULL		),
  MSGTBLE_2(TCML_REQRESUMED,	TCMP_REQRESUMED,	NULL,	"The request was resumed",								NULL		),
  MSGTBLE_2(TCML_REQSUSPENDED,	TCMP_REQSUSPENDED,	NULL,	"The request was suspended",								NULL		),
  MSGTBLE_2(TCML_REQWASRUNNING,	TCMP_REQWASRUNNING,	NULL,	"The request was already running",							NULL		),
  MSGTBLE_2(TCML_REQWASSUSPENDED, TCMP_REQWASSUSPENDED,	NULL,	"The request was already suspended",							NULL		),
  MSGTBLE_2(TCML_QUEBUSY,	TCMP_QUEBUSY,		NULL,	"Queue to run this request is busy",							NULL		),
  MSGTBLE  (TCML_NOMOREMEM,				NULL,	"Unable to allocate more memory for NQS daemon",					NULL		),
  MSGTBLE  (TCML_REQNOTHELD,				NULL,	"Request is not on hold",								NULL		),
  MSGTBLE  (TCML_INVLDLBFLAGS,				NULL,	"The other load balancing switch is already set",					NULL		),
  MSGTBLE  (TCML_DAEALRRUN,				NULL,	"The daemon is already running",							NULL		),
  MSGTBLE_2(TCML_DAENOTRUN,	TCMP_DAENOTRUN,		NULL,	"The daemon is not running",								NULL		),
  MSGTBLE  (TCML_NOSUCHSERV,				NULL,	"No such compute server",								NULL		),
  MSGTBLE_END
};
    
/*** tcmmsgs
 *
 *	void tcmmsgs():
 *
 *	Diagnose a transaction completion code WITHOUT
 *	diagnosing any TCI_ information bits that might
 *	be present in the transaction code.
 */
void tcmmsgs (long code, FILE *stream, char *prefix)
{
  register short reason;
    /* Reason bits of completion code */

  ENTER_FUNCTION("nqs_generic/all-systems/tcmmsgs");
  TEST_ARG(stream != NULL, 2);
  TEST_ARG(prefix != NULL, 3);
    /* ensure we are not working with garbage */
  
  reason = (code & XCI_REASON_MASK);
  if (reason > (TCM_MAXTCM & (XCI_REASON_MASK & ~XCI_PEER_MASK)) ||
     !(code & XCI_TRANSA_MASK))
  {
    /*
     *  The transaction code is invalid.
     */
    reason = (TCML_UNDEFINED & XCI_REASON_MASK);
  }

  tblmsgs(reason, stream, prefix, NULL, &stTCMtbl[0]);
  
  if (code & XCI_PEER_MASK)
  {
    /*
     *  The transaction code originated at the transaction
     *  peer machine.
     */
    fputs (" at transaction peer.\n", stream);
  }
  else
  {
    /*
     *  The transaction code originated at the local host.
     */
    fputs (" at local host.\n", stream);
  }

  fflush(stream);
  EXIT_FUNCTION;
}
