/*
 * nqs_generic/all-systems/tblmsgs.c
 * Handle generic NQS message tables.
 */

#include <nqs_generic/license.h>
  /* NQS license information */
#include <nqs_generic/debug.h>
  /* Debugging support */
#include <nqs_generic/proto.h>
  /* ANSI C prototypes */
#include <nqs_generic/tblmsgs.h>

/*** tblmsgs
 *
 *	void tblmsgs():
 *	Diagnose request code information bits.
 */
void tblmsgs (
		long code,		/* Completion code */
		FILE *stream,		/* Output stream */
		char *prefix,		/* Output prefix */
		void (*headerfn)(FILE *, char *),
	        msg_table *pstMsgTable)	/* Header display function */
{
  register short  preamble;	/* Preamble seen flag */
  msg_table      *pstTable;

  ENTER_FUNCTION("nqs_generic/all-systems/tblmsgs");
    /* Debugging info */
  TEST_ARG(stream      != NULL, 2);
  TEST_ARG(prefix      != NULL, 3);
  TEST_ARG(headerfn    != NULL, 4);
  TEST_ARG(pstMsgTable != NULL, 5);
    /* ensure we are not working with garbage */
  
  preamble = -1;			/* No preamble yet */
  for (pstTable = pstMsgTable; 
       pstTable->lCode != 0 || pstTable->szPrefix != NULL || pstTable->szSuffix != NULL;
       pstTable++)
  {
    if (code & pstTable->lCode == 0)
    {
      if (pstTable->szPrefix != NULL)
	fputs(pstTable->szPrefix, stream);
      if (!(++preamble))
	(*headerfn)(stream, prefix);
      if (pstTable->szSuffix != NULL)
	fputs(pstTable->szSuffix, stream);
      fflush(stream);
    }
  }
  EXIT_FUNCTION;
}
