/*
 * nqs_generic/all-systems/bytezero.c
 * Zero blocks of memory
 */

#include <nqs_generic/license.h>
  /* NQS license information */
#include <nqs_generic/debug.h>
  /* debugging support */
#include <nqs_generic/proto.h>
  /* ANSI C prototypes */
#include <string.h>
#include <stdlib.h>

/*** bytezero
 *
 *	bytezero():
 *	Zero-out exactly N bytes.
 */
void bytezero (char *to, int n)
{
  ENTER_FUNCTION("nqs_generic/all-systems/bytezero");
  
  TEST_ARG(to != NULL, 1);
  TEST_ARG(n  >  0,    2);
  
  memset((void *)to, (int)'\0', (size_t) n);
  EXIT_FUNCTION;
}
