/*
 * nqs_generic/all-systems/serexit.c
 * Server cleanup code
 */

#include <nqs_generic/license.h>
  /* NQS license information */
#include <nqs_generic/debug.h>
  /* debugging support */
#include <nqs_generic/proto.h>
  /* ANSI C prototypes */

#include <unistd.h>
#include <string.h>

/*** serexit
 *
 *	void serexit():
 *
 *	Send a server-complete message to the shepherd process
 *	(parent of the server) on file descriptor 3, and exit(0).
 */
void serexit (long rcm, char servermssg[256])
{
  struct servermssg ret_packet;

  ENTER_FUNCTION("nqs_generic/all-systems/serexit");
    /* debugging information */
  
  ret_packet.rcm = rcm;	/* Store req/server completion message */
  if (servermssg == NULL)
    ret_packet.mssg [0] = '\0';
  else
    strcpy (ret_packet.mssg, servermssg);
  
  /*
   *  If you change the file descriptor that the req/server
   *  completion message is reported on, then you must also
   *  change nqs_spawn.c.
   */
  
  write (3, (char *) &ret_packet, sizeof (ret_packet));
  DEBUGGING(INFO, DEBUG_MEDIUM, "Exiting server!!\n");
  exit (0);		/* Exit */
  
  EXIT_FUNCTION;
    /* This never gets executed ;-) because of the exit call above */
}
