/*
 * nqs_generic/all-systems/fopendata.c
 * Open a data file
 */

#include <nqs_generic/license.h>
  /* NQS license information */
#include <nqs_generic/debug.h>
  /* debugging support */
#include <nqs_generic/proto.h>
  /* ANSI C prototypes */
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <nqs_req/nqs_req.h>
  /* Get definition of mid_t */

/*** fopendata
 *
 *
 *	FILE *fopendata():
 *
 *	Open an NQS req data file as called from a server returning
 *	the opened file stream.
 *
 *	Note that the current directory of the caller must be the
 *	NQS root directory (which is the directory at the time that
 *	the server is exec'd from the NQS daemon).
 *
 *	Returns:
 *		The opened file stream if successful, otherwise
 *		NULL is returned.
 */

/*
 * orig_seqno		: Sequence number for req
 * orig_mid		: Machine ID for the request
 * datano		: Data file number
 *
 * RETURNS
 * 	FILE * for the open stream, or NULL if cannot open.
 */

FILE *fopendata (long orig_seqno, Mid_t orig_mid, int datano)
{
  int iFd;
    /* Opened file descr */

  ENTER_FUNCTION("nqs_generic/all-systems/fopendata");
  
  if ((iFd = opendata (orig_seqno, orig_mid, datano)) > -1)
  {
    EXIT_FUNCTION;
    return (fdopen (iFd, "r"));
  }
  return (NULL);
}
