/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.20  JRR     16-Jan-1992	Added support for RS6000.
*	V01.3	JRR	17-Jun-1992	Added header.
*	V01.4	
*	V01.5	JRR	06-Apr-1993	Added support for DECOSF.
*	V01.6	JRR	02-Mar-1994	Added support for SOLARIS.
*/
/*++ nmapcommon.h -
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.35.6/npsn_compat/RCS/nmapcommon.h,v $
 *
 * DESCRIPTION:
 *	Nmapcommon.h:  Header file containing definitions for use with nmap
 *
 * STANDARDS VIOLATIONS:
 *
 * REVISION HISTORY: ($Revision: 1.6 $ $Date: 1994/03/30 20:35:38 $ $State: Exp $)
 * $Log: nmapcommon.h,v $
 * Revision 1.6  1994/03/30  20:35:38  jrroma
 * Version 3.35.6
 *
 * Revision 1.5  93/07/13  21:33:15  jrroma
 * Version 3.34
 * 
 * Revision 1.4  92/12/22  15:52:01  jrroma
 * Version 3.30
 * 
 * Revision 1.3  92/06/18  14:39:19  jrroma
 * Added gnu header
 * 
 * Revision 1.2  92/01/17  12:48:57  jrroma
 * Added support for RS6000.
 * 
 * Revision 1.1  92/01/17  12:48:21  jrroma
 * Initial revision
 * 
 *
 */

#if	POSIX | SYSVr4
#include <fcntl.h>
#else
#if	BSD
#include <sys/file.h>
#else
BAD SYSTEM TYPE
#endif
#endif
#include <errno.h>
#include <netdb.h>		/* Berkeley network database */
#include <sys/types.h>
#include <nmap.h>		/* Network mapping headers */
#include "ioblksiz.h"
#include <nmapdb.h>
#if	NEWCASTLE
#include "syscall.h"		/* Non-Newcastle system calls */
#define gethostbyname _gthstbynm  /* Newcastle version sans stdio */
#else
#define	CLOSE	close
#define	LSEEK	lseek
#define	OPEN	open
#define	READ	read
#define	WRITE	write
#endif

extern int errno;		/* In case not declared in errno.h */

/*
 *	Mapping modes:
 */
#define	BY_NAM	0001		/* Request by name */
#define	BY_UID	0002		/* Request by user-id */
#define	BY_GID	0004		/* Request by group-id */
#define	ADD_OP	0010		/* Add mapping */
#define	DEL_OP	0020		/* Delete mapping */
#define	GET_OP	0040		/* New map request */
#define	ADD_UID	(BY_UID|ADD_OP)
#define	ADD_GID	(BY_GID|ADD_OP)
#define	ADD_NAM	(BY_NAM|ADD_OP)
#define	DEL_UID	(BY_UID|DEL_OP)
#define	DEL_GID	(BY_GID|DEL_OP)
#define	DEL_NAM	(BY_NAM|DEL_OP)
#define	GET_UID	(BY_UID|GET_OP)
#define	GET_GID	(BY_GID|GET_OP)
#define	GET_MID	(BY_NAM|GET_OP)

extern int name_mapfile;	/* File descriptor for machines		*/
				/* database: -1 if closed, > -1 if open.*/
extern int machine_file;	/* File descriptor for machine file	*/
				/* -1 if closed, > -1 if open.		*/
extern int nfds;		/* This variable determines the number	*/
				/* file descriptors that the network	*/
				/* mapping software will be allowed to	*/
				/* keep open between calls (0, 1, 2).	*/
