/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*++ verifyhdr.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.35.3/lib/RCS/verifyhdr.c,v $
 *
 * DESCRIPTION:
 *
 *	Verify the common portion of a rawreq structure.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	March 28, 1986.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.3 $ $Date: 1994/02/24 21:28:47 $ $State: Exp $)
 * $Log: verifyhdr.c,v $
 * Revision 1.3  1994/02/24  21:28:47  jrroma
 * Version 3.35.3
 *
 * Revision 1.2  92/06/18  13:25:00  jrroma
 * Added gnu header
 * 
 * Revision 1.1  92/06/18  12:51:21  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"


/*** verifyhdr
 *
 *
 *	int verifyhdr():
 *	Verify the common portion of a rawreq structure.
 *
 *	Returns:
 *		 0: if common header is valid.
 *		-1: otherwise.
 */
int verifyhdr (struct rawreq *rawreq)
{
	/*
	 * "rawreq->ndatafiles > 32767" will be an invariant comparison
	 * when compiled on a machine with 16 bit shorts.
	 */
	if (rawreq->magic1 != REQ_MAGIC1 ||
	    rawreq->trans_id < 0 || rawreq->trans_id > MAX_TRANSACTS ||
	    rawreq->trans_quename [MAX_QUEUENAME] != '\0' ||
	    rawreq->quename [0] == '\0' ||
	    rawreq->quename [MAX_QUEUENAME] != '\0' ||
	    rawreq->type != RTYPE_BATCH && rawreq->type != RTYPE_DEVICE ||
	    rawreq->orig_seqno < -1 || rawreq->orig_seqno > MAX_SEQNO_USER ||
	    rawreq->rpriority < -1 || rawreq->rpriority > MAX_POSIX_RPRIORITY ||
	    rawreq->ndatafiles < 0 || rawreq->ndatafiles > 32766 ||
	    rawreq->reqname [0] == '\0' ||
	    rawreq->reqname [MAX_REQNAME] != '\0' ||
	    rawreq->username [0] == '\0' ||
	    rawreq->username [MAX_ACCOUNTNAME] != '\0' ||
	    rawreq->mail_name [0] == '\0' ||
	    rawreq->mail_name [MAX_ACCOUNTNAME] != '\0') {
		/*
		 *  Values out of bounds.
		 */
		return (-1);
	}
	/*
	 *  No errors detected in the common portion of the rawreq.
	 */
	return (0);
}
