/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*++ destdev.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs-3.21/lib/RCS/destdev.c,v $
 *
 * DESCRIPTION:
 *
 *	Return a pointer to the device-name portion of a remote
 *	device specification.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	October 15, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.2 $ $Date: 92/06/18 13:23:40 $ $State: Exp $)
 * $Log:	destdev.c,v $
 * Revision 1.2  92/06/18  13:23:40  jrroma
 * Added gnu header
 * 
 * Revision 1.1  92/06/18  09:53:30  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"			/* NQS types and definitions */

/*** destdev
 *
 *
 *	char *destdev():
 *
 *	Return a pointer to the device-name portion of a remote
 *	device specification.
 */
char *destdev (char *remote_device)
{
	static char devname [MAX_DEVNAME+2];
					/* Remote device name of one */
					/* extra byte so that mgr_scan.c */
					/* can tell a remote device */
					/* name that is too long. */
	register char *copyto;		/* Copyto pointer */
	register unsigned size;		/* Copy size */

	size = 0;			/* Nothing copied yet */
	copyto = devname;		/* Where to copy */
	while (*remote_device && *remote_device != '@' &&
	       size < MAX_DEVNAME+1) {
		*copyto++ = *remote_device++;
		size++;			/* One more character copied */
	}				/* specification */
	*copyto = '\0';			/* Null terminate */
	return (devname);		/* Return pointer to device name */
}
