/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.2   JRR     28-Feb-1992	Added Cosmic V2 changes.
*	V01.3	JRR	17-Jun-1992	Added header.
*	V01.4	JRR	07-Dec-1992	Modified for C prototypes.
*/
/*++ nextdb.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.30/lib/RCS/nextdb.c,v $
 *
 * DESCRIPTION:
 *
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	August 12, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.4 $ $Date: 1992/12/22 15:46:17 $ $State: Exp $)
 * $Log: nextdb.c,v $
 * Revision 1.4  1992/12/22  15:46:17  jrroma
 * Version 3.30
 *
 * Revision 1.3  92/06/18  13:24:17  jrroma
 * Added gnu header
 * 
 * Revision 1.2  92/02/28  15:13:34  jrroma
 * Added Cosmic V2 changes.
 * 
 * Revision 1.1  92/02/28  15:11:36  jrroma
 * Initial revision
 * 
 *
 */
#include "nqs.h"


/*** nextdb
 *
 *
 *	struct gendescr *nextdb()
 *
 *	Return a pointer to the next allocated descriptor in the
 *	specified database/configuration file;  If no more allocated
 *	descriptors exist in the specified file, then return NULL.
 */
struct gendescr *nextdb (struct confd *file)
{
	register struct gendescr *gendescr;
        short zero=0;   /* used to force signed comparison Intergraph */


	/*
	 *  Loop to get next generic descriptor from the database file
	 *  ignoring unallocated entries.
	 */
	do {
		gendescr = readdb (file);	/* Get next descriptor */
        } while (gendescr != (struct gendescr *)0 && gendescr->size < zero);
	return (gendescr);
}
