/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*++ nqs_upf.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.30/src/RCS/nqs_upf.c,v $
 *
 * DESCRIPTION:
 *
 *	NQS forms set update module.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	June 16, 1986.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.3 $ $Date: 1992/12/22 15:41:36 $ $State: Exp $)
 * $Log: nqs_upf.c,v $
 * Revision 1.3  1992/12/22  15:41:36  jrroma
 * Version 3.30
 *
 * Revision 1.2  92/06/18  17:31:27  jrroma
 * Added gnu header
 * 
 * Revision 1.1  92/06/18  17:09:30  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"
#include "nqsxvars.h"
#include "transactcc.h"		/* Transaction completion codes */
#include <string.h>

/*** upf_addfor
 *
 *
 *	long upf_addfor():
 *	Add a form to the local NQS forms set.
 *
 *	Returns:
 *		TCML_COMPLETE:	if successful;
 *		TCML_ALREADEXI:	if the specified form name is already
 *				present in the NQS forms set.
 */
long upf_addfor (newform)
char *newform;				/* Name of new forms */
{
	if (upf_valfor (newform)) {
		/*
		 *  The specified form is already present in the forms
		 *  set.
		 */
		return (TCML_ALREADEXI);
	}
	udb_addfor (newform);		/* Add the form to the forms set */
	return (TCML_COMPLETE);
}


/*** upf_delfor
 *
 *
 *	long upf_delfor():
 *	Delete a form from the local NQS forms set.
 *
 *	Returns:
 *		TCML_COMPLETE:	 if successful;
 *		TCML_NOSUCHFORM: if the specified form did not exist
 *				 in the NQS forms set.
 */
long upf_delfor (form)
char *form;				/* Name of forms to delete */
{
	if (upf_valfor (form)) {
		/*
		 *  The specified form to delete is present in the forms
		 *  set.
		 */
		udb_delfor (form);	/* Delete the form from the forms */
					/* set */
		return (TCML_COMPLETE);
	}
	return (TCML_NOSUCHFORM);	/* No such form */
}


/*** upf_valfor
 *
 *
 *	upf_valfor():
 *
 *	Return non-zero if the specified form is defined in the
 *	local NQS forms set.  Otherwise return 0.
 */
int upf_valfor (formname)
register char *formname;		/* Forms name to be validated */
{
	register struct gendescr *descr;

	seekdbb (Formsfile, 0L);	/* Seek to the beginning of the NQS */
					/* forms list file */
	/*
	 *  Search for the entry to be added, to see if it is already
	 *  present.
	 */
	descr = nextdb (Formsfile);
	while (descr != (struct gendescr *) 0) {
		if (strcmp (descr->v.form.forms, formname) == 0) {
			/*
			 *  The forms exists.
			 */
			return (1);	/* Form is valid */
		}
		else descr = nextdb (Formsfile);
	}
	return (0);			/* Form is not valid */
}
