/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*++ fsizedb.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.30/lib/RCS/fsizedb.c,v $
 *
 * DESCRIPTION:
 *
 *	Update the current size of the specified database file.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	August 12, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.3 $ $Date: 1992/12/22 15:46:02 $ $State: Exp $)
 * $Log: fsizedb.c,v $
 * Revision 1.3  1992/12/22  15:46:02  jrroma
 * Version 3.30
 *
 * Revision 1.2  92/06/18  13:23:50  jrroma
 * Added gnu header
 * 
 * Revision 1.1  92/06/18  10:18:22  jrroma
 * Initial revision
 * 
 *
 */
#include "nqs.h"

/*** fsizedb
 *
 *
 *	void fsizedb():
 *	Update the current size of the specified NQS database file.
 */
void fsizedb (file)
register struct confd *file;
{
	register long filesize;

	filesize = lseek (file->fd, 0L, 2);
	/*
	 *  Seek back to the original position (also reloading the
	 *  contents of the cache buffer, since the cache block could
	 *  be out of date)!!!!
	 */
	file->size = filesize;		/* Update size */
	seekdb (file, file->vposition);	/* Restore file position and */
					/* reload cache block */
}
