/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.20  JRR     16-Jan-1992	Added support for RS6000.
*       V01.3   JRR     28-Feb-1992	Added Cosmic V2 changes.
*	V01.4	JRR	17-Jun-1992	Added header.
*	V01.5	JRR	05-Nov-1992	Modified for C prototypes.
*	V01.6	JRR	03-Mar-1994	Fixed up NMAP.
*/
/*++ fmtgidname.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.35.6/lib/RCS/fmtgidname.c,v $
 *
 * DESCRIPTION:
 *
 *	Return a pointer to the groupname of the group
 *	identified by the local group-id.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	May 25, 1986.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.6 $ $Date: 1994/03/30 20:32:28 $ $State: Exp $)
 * $Log: fmtgidname.c,v $
 * Revision 1.6  1994/03/30  20:32:28  jrroma
 * Version 3.35.6
 *
 * Revision 1.5  92/12/22  15:45:59  jrroma
 * Version 3.30
 * 
 * Revision 1.4  92/06/18  13:23:46  jrroma
 * Added gnu header
 * 
 * Revision 1.3  92/02/28  14:02:03  jrroma
 * Added Cosmic V2 changes.
 * 
 * Revision 1.2  92/01/16  15:40:01  jrroma
 * Added support for RS6000.
 * 
 * Revision 1.1  92/01/16  15:38:46  jrroma
 * Initial revision
 * 
 *
 */

#include <nqs.h>
#include "nmap.h"				/* Mid_t (all OS's) */
					/* Uid_t and gid_t (if not BSD43) */
#include <grp.h>			/* Group database definitions */

/*
 *	External functions.
 */


/*** fmtgidname
 *
 *
 *	char *fmtgidname():
 *
 *	Return a pointer to the groupname of the group
 *	identified by the local group-id.
 */
char *fmtgidname (gid)
gid_t gid;				/* Local group-id */
{
	static char standinbuf [14];	/* Stand-in buffer */

	register char *name;		/* Pointer to name */
	register struct group *group;	/* Group entry */

	group = fetchgrgid ((int) gid);	/* Get group entry */
	if (group == (struct group *) 0) {
		/*
		 *  No such group!  Format a "stand-in" name.
		 */
		sprintf (standinbuf, "[%1d]", (int) gid);
		name = standinbuf;
	}
	else name = group->gr_name;
	return (name);
}
