/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*++ destqueue.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs-3.21/lib/RCS/destqueue.c,v $
 *
 * DESCRIPTION:
 *
 *	Return a pointer to the queue-name portion of a remote
 *	queue specification.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	October 15, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.2 $ $Date: 92/06/18 13:23:41 $ $State: Exp $)
 * $Log:	destqueue.c,v $
 * Revision 1.2  92/06/18  13:23:41  jrroma
 * Added gnu header
 * 
 * Revision 1.1  92/06/18  09:53:58  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"			/* NQS types and definitions */

/*** destqueue
 *
 *
 *	char *destqueue():
 *
 *	Return a pointer to the queue-name portion of a remote
 *	queue specification.
 */
char *destqueue (remote_queue)
register char *remote_queue;		/* Remote queue specification text */
{
	static char quename [MAX_QUEUENAME+2];
					/* Remote queue name of one */
					/* extra byte so that mgr_scan.c */
					/* can tell a remote queue */
					/* name that is too long. */
	register char *copyto;		/* Copyto pointer */
	register unsigned size;		/* Copy size */

	size = 0;			/* Nothing copied yet */
	copyto = quename;		/* Where to copy */
	while (*remote_queue && *remote_queue != '@' &&
	       size < MAX_QUEUENAME+1) {
		*copyto++ = *remote_queue++;
		size++;			/* One more character copied */
	}				/* specification */
	*copyto = '\0';			/* Null terminate */
	return (quename);		/* Return pointer to queue name */
}
