/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*++ telldb.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs-3.21/lib/RCS/telldb.c,v $
 *
 * DESCRIPTION:
 *
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	August 12, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.2 $ $Date: 92/06/18 13:24:57 $ $State: Exp $)
 * $Log:	telldb.c,v $
 * Revision 1.2  92/06/18  13:24:57  jrroma
 * Added gnu header
 * 
 * Revision 1.1  92/06/18  12:51:04  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"

/*** telldb
 *
 *
 *	long telldb():
 *
 *	Returns:
 *		The file offset position of the last descriptor
 *		read from the specified NQS database/configuration
 *		file.  A value of -1 indicates that no readdb()
 *		call has ever been performed on the specified file.
 */
long telldb (file)
register struct confd *file;
{
	return (file->lastread);
}
