/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR     		Initial version.
*	V01.20	JRR	16-Jan-1992	Add support for RS6000.
*	V01.3	JRR	17-Jun-1992	Added header.
*	V01.4	JRR	05-Nov-1992	Added support for HPUX.
*	V01.5	JRR	23-Dec-1992	Change index => strchr.
*/
/*++ destpath.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.31/lib/RCS/destpath.c,v $
 *
 * DESCRIPTION:
 *
 *	Return a pointer to the path-name portion of a remote
 *	path specification:  machine_name:path.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	November 5, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.5 $ $Date: 1993/02/05 23:13:14 $ $State: Exp $)
 * $Log: destpath.c,v $
 * Revision 1.5  1993/02/05  23:13:14  jrroma
 * Version 3.31
 *
 * Revision 1.4  92/11/06  11:09:00  jrroma
 * Added support for HPUX.
 * 
 * Revision 1.3  92/06/18  13:23:40  jrroma
 * Added gnu header
 * 
 * Revision 1.2  92/01/16  15:29:40  jrroma
 * Added support for RS6000.
 * 
 * Revision 1.1  92/01/16  15:26:40  jrroma
 * Initial revision
 * 
 *
 */

#include <string.h>
#include "nqs.h"			/* NQS types and definitions */

/*** destpath
 *
 *
 *	char *destpath():
 *
 *	Return a pointer to the path-name portion of a remote
 *	path specification:  machine_name:path.
 */
char *destpath (remote_path)
register char *remote_path;		/* Remote path specification text */
{
	static char pathname [MAX_REQPATH+2];
					/* Remote path name of one */
					/* extra byte so that caller can */
					/* tell if the path name is too */
					/* long. */
	register char *local_path;	/* Pointer to local path */

	if ((local_path = strchr (remote_path, ':')) == (char *) 0) {
		local_path = remote_path;
	}
	else local_path++;
	strncpy (pathname, local_path, MAX_REQPATH+2);
	pathname [MAX_REQPATH+1] = '\0';	/* Paranoia */
	return (pathname);
}
