/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.1   JRR     08-Apr-1994	Initial version.
*/
/*++ nqs_upserv.c - Network Queueing System
 *
 *
 * DESCRIPTION:
 *
 *	NQS compute server set update module.
 *
 *
 *	Author:
 *	-------
 *	John Roman, Monsanto Company.
 *	April 8, 1994.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 */

#include "nqs.h"
#include "nqsxvars.h"
#include "transactcc.h"		/* Transaction completion codes */


/*** upserv_setperf
 *
 *
 *	long upserv_setperf():
 *	Set the performance level for a compute server.
 *
 *	Returns:
 *		TCML_COMPLETE:	if successful;
 */
long upserv_setperf (server, performance)
Mid_t server;
int performance;
{
	udb_setservperf (server, performance);
	return (TCML_COMPLETE);		/* and we are done */
}


/*** upserv_setavail
 *
 *
 *	long upserv_setavail():
 *	Set a server available.
 *
 *	Returns:
 *		TCML_COMPLETE:	if successful;
 */
long upserv_setavail (server)
Mid_t server;
{
	udb_setservavail (server);
	return (TCML_COMPLETE);		/* and we are done */
}
