/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*++ shoalllim.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.30/lib/RCS/shoalllim.c,v $
 *
 * DESCRIPTION:
 *
 *	Show information about 
 *	1) all limits on the local machine and
 *	2) the shell strategy on the local machine,
 *	in both cases as selected by the display criteria flags.
 *
 *
 *	Author:
 *	-------
 *	Robert W. Sandstrom, Sterling Software Incorporated.
 *	January 13, 1986.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.3 $ $Date: 1992/12/22 15:46:30 $ $State: Exp $)
 * $Log: shoalllim.c,v $
 * Revision 1.3  1992/12/22  15:46:30  jrroma
 * Version 3.30
 *
 * Revision 1.2  92/06/18  13:24:44  jrroma
 * Added gnu header
 * 
 * Revision 1.1  92/06/18  12:49:57  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"

/*** shoalllim
 *
 *
 *	int shoalllim():
 *	Show status information on all local limits
 *	and the local shell strategy.
 *
 *	WARNING:
 *		It is assumed that the current position of
 *		the parameter definitions file is 0.
 *
 *	Returns:
 *		Always returns 0. Shoalllim always produces output.
 *
 */
int shoalllim (file, flags)
register struct confd *file;		/* NQS parameters file  or NULL */
register long flags;			/* Display flags */
{
    register struct gendescr *descr;	/* pointer into param file */
    int found;		/* boolean: found the correct param descriptor? */

    if (VALID_LIMITS == 0) {
	printf ("  No limits are supported for this machine.");
    }
    else {
	if (VALID_LIMITS & LIM_PRDRIVES) {
	    printf ("  Per-req. tape drive limit (-l6)\n");
	}
	if (VALID_LIMITS & LIM_PPCORE) {
	    printf ("  Core file size limit (-lc)\n");
	}
	if (VALID_LIMITS & LIM_PPDATA) {
	    printf ("  Data segment size limit (-ld)\n");
	}
	if (VALID_LIMITS & LIM_PPPFILE) {
	    printf ("  Per-process permanent file ");
	    printf ("size limit (-lf)\n");
	}
	if (VALID_LIMITS & LIM_PRPFILE) {
	    printf ("  Per-request permanent file ");
	    printf ("size limit (-lF)\n");
	}
	if (VALID_LIMITS & LIM_PPMEM) {
	    printf ("  Per-process memory size limit (-lm)\n");
	}
	if (VALID_LIMITS & LIM_PRMEM) {
	    printf ("  Per-request memory size limit (-lM)\n");
	}
	if (VALID_LIMITS & LIM_PPNICE) {
	    printf ("  Nice value (-ln)\n");
	}
	if (VALID_LIMITS & LIM_PRNCPUS) {
	    printf ("  Per-request # of cpus limit (-lP)\n");
	}
	if (VALID_LIMITS & LIM_PPQFILE) {
	    printf ("  Per-process quick file ");
	    printf ("size limit (-lq)\n");
	}
	if (VALID_LIMITS & LIM_PRQFILE) {
	    printf ("  Per-request quick file ");
	    printf ("size limit (-lQ)\n");
	}
	if (VALID_LIMITS & LIM_PPSTACK) {
	    printf ("  Stack segment size limit (-ls)\n");
	}
	if (VALID_LIMITS & LIM_PPCPUT) {
	    printf ("  Per-process cpu time limit (-lt)\n");
	}
	if (VALID_LIMITS & LIM_PRCPUT) {
	    printf ("  Per-request cpu time limit (-lT)\n");
	}
	if (VALID_LIMITS & LIM_PPTFILE) {
	    printf ("  Per-process temporary file ");
	    printf ("size limit (-lv)\n");
	}
	if (VALID_LIMITS & LIM_PRTFILE) {
	    printf ("  Per-request temporary file ");
	    printf ("size limit (-lV)\n");
	}
	if (VALID_LIMITS & LIM_PPWORK) {
	    printf ("  Working set limit (-lw)\n");
	}
    }
    putchar ('\n');
    if (flags & SHO_SHS) {		/* Show shell strategy */
	descr = nextdb (file);
	found = 0;
	while (descr != (struct gendescr *)0 && !found) {
	    if (descr->v.par.paramtype == PRM_GENPARAMS) {
		found = 1;
		printf ("  Shell strategy = ");
		switch (descr->v.par.v.genparams.shell_strategy) {
		case SHSTRAT_FREE:
		    printf ("FREE\n");
		    break;
		case SHSTRAT_LOGIN:
		    printf ("LOGIN\n");
		    break;
		case SHSTRAT_FIXED:
		    printf ("FIXED: %s\n",
			    descr->v.par.v.genparams.fixed_shell);
		    break;
		}
	    }
	    descr = nextdb (file);	/* Get the next param */
	}
	if (found == 0) {
	    printf ("  No shell strategy.\n");	
	}
	putchar ('\n');
    }
    return (0);
}
