/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.20  JRR     16-Jan-1992	Added support for RS6000.
*	V01.3	JRR	17-Jun-1992	Added header.
*	V01.4	JRR	06-Nov-1992	Added support for HPUX.
*	V01.5	JRR	06-Apr-1993	Added support for DECOSF
*					(by removing conditionals).
*/
/*++ opendata.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.34/lib/RCS/opendata.c,v $
 *
 * DESCRIPTION:
 *
 *	Open an NQS request data file as called from a server returning
 *	the opened file descriptor number.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	August 12, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.5 $ $Date: 1993/07/13 21:31:30 $ $State: Exp $)
 * $Log: opendata.c,v $
 * Revision 1.5  1993/07/13  21:31:30  jrroma
 * Version 3.34
 *
 * Revision 1.4  92/11/06  13:46:57  jrroma
 * Added support for HPUX
 * 
 * Revision 1.3  92/06/18  13:24:20  jrroma
 * Added gnu header
 * 
 * Revision 1.2  92/01/16  16:58:32  jrroma
 * Added support for RS6000.
 * 
 * Revision 1.1  92/01/16  16:57:54  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"
#include "nqsxdirs.h"			/* NQS directory definitions */

/*** opendata
 *
 *
 *	int opendata():
 *
 *	Open an NQS req data file as called from a server returning
 *	the opened file descriptor number.
 *
 *	Note that the current directory of the caller must be the
 *	NQS root directory (which is the directory at the time that
 *	the server is exec'd from the NQS daemon).
 *
 *	Returns:
 *	      >=0: as the file descriptor of the opened file if
 *		   successful;
 *	       -1: if an error occurs in which case errno is set.
 */
int opendata (orig_seqno, orig_mid, datano)
long orig_seqno;			/* Sequence# for req */
Mid_t orig_mid;				/* Machine-id for req */
int datano;				/* Data file number */
{
	char path [MAX_PATHNAME+1];	/* Pathname for data file */

	pack6name (path, Nqs_data, (int) (orig_seqno % MAX_OUTPSUBDIRS),
		  (char *) 0, (long) orig_seqno, 5, (long) orig_mid, 6,
		   datano-1, 3);
	return (open (path, O_RDONLY));
}
