/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*++ bytezero.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.30/lib/RCS/bytezero.c,v $
 *
 * DESCRIPTION:
 *
 * 	Zero-out exactly N bytes.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	November 29, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.3 $ $Date: 1992/12/22 15:45:57 $ $State: Exp $)
 * $Log: bytezero.c,v $
 * Revision 1.3  1992/12/22  15:45:57  jrroma
 * Version 3.30
 *
 * Revision 1.2  92/06/18  13:23:36  jrroma
 * Added gnu header
 * 
 * Revision 1.1  92/06/18  09:52:28  jrroma
 * Initial revision
 * 
 *
 */

/*** bytezero
 *
 *
 *	bytezero():
 *	Zero-out exactly N bytes.
 */
void bytezero (to, n)
register char *to;
register int n;
{
	while (n--) {
		*to++ = '\0';
	}
}
