/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                                              
*       V01.20  JRR     16-Jan-1992     Added support for RS6000.
*       V01.30  JRR     17-Jan-1992     Minor tweak to above.    
*       V01.40  JRR     12-Feb-1992     Fix setvbuf for Irix 4.0.
*	V01.5	JRR	17-Jun-1992	Added header.
*	V01.6	JRR	05-Nov-1992	Added support for HPUX.
*	V01.7	JRR	06-Jan-1993	Only support IRIX 4.0 now.
*	V01.8	JRR	06-Apr-1993	Added support for DECOSF.
*	V01.9	JRR	28-Feb-1994	Added support for SOLARIS.
*/
/*++ bufstdout.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.35.6/lib/RCS/bufstdout.c,v $
 *
 * DESCRIPTION:
 *
 *	Block buffer the output to the stdout file stream.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	October 27, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.9 $ $Date: 1994/03/30 20:32:25 $ $State: Exp $)
 * $Log: bufstdout.c,v $
 * Revision 1.9  1994/03/30  20:32:25  jrroma
 * Version 3.35.6
 *
 * Revision 1.8  93/07/13  21:30:59  jrroma
 * Version 3.34
 * 
 * Revision 1.7  93/02/05  23:13:13  jrroma
 * Version 3.31
 * 
 * Revision 1.6  92/11/06  10:58:21  jrroma
 * Added support for HPUX.
 * 
 * Revision 1.5  92/06/18  13:23:35  jrroma
 * Added gnu header
 * 
 * Revision 1.4  92/02/12  10:27:40  jrroma
 * Fix call to setvbuf for Irix 4.0.
 * 
 * Revision 1.3  92/01/17  16:16:28  jrroma
 * Fix to setvbuf call for RS6000.
 * 
 * Revision 1.2  92/01/16  15:13:43  jrroma
 * Added support for RS6000.
 * 
 * Revision 1.1  92/01/16  15:12:23  jrroma
 * Initial revision
 * 
 *
 */

#include <stdio.h>


/*** bufstdout
 *
 *
 *	void bufstdout():
 *	Block buffer the output to the stdout file stream.
 */
void bufstdout()
{
	static char stdout_buffer [BUFSIZ];	/* Stdout output buffer */

#if	BSD43 | ULTRIX | DECOSF
	setbuffer (stdout, stdout_buffer, BUFSIZ);
#else
#if	IBMRS | SGI | SOLARIS | HPUX | LINUX
	/*
	 *  These guys took AT&T at their word....
	 */
	setvbuf (stdout, stdout_buffer, _IOFBF, BUFSIZ);
#else
BAD SYSTEM TYPE
#endif
#endif
}
