/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.00  JRR     16-Mar-1992     Initial Version.
*       V01.1   JRR     16-Apr-1992     Added complex user limits.
*	V01.2	JRR	26-May-1992	Added IBMRS.
*	V01.3	JRR	17-Jun-1992	Added header.
*	V01.4	JRR	06-Nov-1992	Added support for HPUX.	
*	V01.5	JRR	09-Nov-1992	Fix calls to show_qcmplx_header.
*	V01.6	JRR	06-Apr-1993	Added support for DECOSF
*					(by deleting conditionals).
*					Return 1 if don't find complex.
*	V01.7	JRR	18-Aug-1993	Miniscule change to includes.
*/
#include <ctype.h>
#include "nqs.h"		/* NQS definitions */
#include "nqsxdirs.h"		/*  NQS directories */
#include "nqsxvars.h"		/* NQS directories */

static print_complex ( struct gendescr *descr, long flags );
static show_qcmplx_hdr ( void );

/*** showcomplex
 * 
 */
showcomplex( 
	register struct confd *qfile,   /* MUST be the NQS queue file */
	char * name,			/* complex name  */
	register long flags,            /* Display flags */
	uid_t whomuid,			/* Uid of whom we are interested in */
	struct reqset *reqset_ptr,     	/* pointer to the request set */
	short daepresent,
	struct confd *qmapfile,		/*NQS qmap definition file */
	struct confd *pipeqfile,	/*NQS qmap definition file */
	struct confd *qcomplexfile)	/*NQS queue complex definition file */
{

	register struct gendescr *descr;
	int shown_header = 0;		/* True if have shown header */

	/* read first record */
	descr = nextdb(qcomplexfile);
	if (descr == NULL) {
	    printf("\t\t No complexes on host. \n");
	    if (name != NULL) return (1);
	    return (0);
	}
	while (descr != NULL) {
	    if (name != NULL)   {
		if (strcmp(descr->v.qcom.name, name) == 0) {
		    if (!shown_header) {
			show_qcmplx_hdr();
			shown_header++;
		    }
		    print_complex(descr, flags);
		    return(0);
		}
	   } else { 
	 	/* name == NULL, so print all we can find.  */
		if (!shown_header) {
		    show_qcmplx_hdr();
		    shown_header++;
		}
		print_complex(descr, flags);
	   }
	   descr = nextdb(qcomplexfile);
	}
	/*
	 * If we were looking for a specific complex and did not find it, 
	 * return 1.  O/W return 0.
	 */
	if (!shown_header && name != NULL) return (1);
	return (0);
}
static print_complex(
	struct gendescr *descr,
	long flags)
{
	int	i;

	printf("%s \n",descr->v.qcom.name);
	if (flags & SHO_R_BRIEF) return;
        printf("  Complex run limit: %d;  ", descr->v.qcom.runlimit);
        printf("  Complex user limit: %d\n", descr->v.qcom.userlimit);
	if ( ! (flags & SHO_R_LONG) ) return;
        printf("  Queues for complex:\n");

        for(i=0; i< MAX_QSPERCOMPLX; i++) {
	    if (descr->v.qcom.queues[i][0] != (char)NULL) 
				printf("    %s\n", descr->v.qcom.queues[i]);
        }
}
static show_qcmplx_hdr()
{
        char hostname[256];

        gethostname(hostname,255);
        hostname[255] = '\0';

        printf("Queue Complexes:\n");
}

