/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.2   JRR     28-Feb-1992	Added Cosmic V2 changes.
*	V01.3	JRR	17-Jun-1992	Added header.
*	V01.4	JRR	12-Nov-1992	Added lb_scheduler.
*	V01.5	JRR	05-Mar-1993	Added Boeing enhancement for files.
*	V01.6	JRR	12-Aug-1993	Removed non-networked code.
*/
/*++ ldparam.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.35/lib/RCS/ldparam.c,v $
 *
 * DESCRIPTION:
 *
 *	Load the general NQS operating parameters.  This module is used
 *	by the main NQS daemon via ../src/nqs_ldconf.c  and by the Qmgr
 *	program via ../src/mgr_cmd.c.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	October 17, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.6 $ $Date: 1993/09/10 13:55:13 $ $State: Exp $)
 * $Log: ldparam.c,v $
 * Revision 1.6  1993/09/10  13:55:13  jrroma
 * Version 3.35
 *
 * Revision 1.5  93/07/13  21:31:25  jrroma
 * Version 3.34
 * 
 * Revision 1.4  92/12/22  15:46:06  jrroma
 * Version 3.30
 * 
 * Revision 1.3  92/06/18  13:24:00  jrroma
 * Added gnu header
 * 
 * Revision 1.2  92/02/28  14:12:52  jrroma
 * Added Cosmic V2 changes.
 * 
 * Revision 1.1  92/02/28  14:10:47  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"
#include "nqsxvars.h"			/* External global variables */
#include "nqsxdirs.h"


/*** ldparam
 *
 *
 *	void ldparam():
 *	Load the general NQS operating parameters.
 */
void ldparam ()
{
	register struct gendescr *gendescr;	/* Database descriptor */
	char	*daemon;			/* Fully quailified name */

	/*
	 *  Read and process the general NQS operating parameters
	 *  from the NQS parameter file.
	 */
	Debug = 0;				/* Set up defaults */
	Defbatpri = MAX_RPRIORITY / 2;
	LB_Scheduler = 0;
	Defbatque [0] = '\0';
	Defdesrettim = 3600L * 24 * 3;		/* 3 days of patience */
	Defdesretwai = 300;			/* 5-minute dest retry waits */
	Defdevpri = MAX_RPRIORITY / 2;
	Defnetrettim = 3600L * 24 * 3;		/* 3 days of patience */
	Defnetretwai = 300;			/* 5-minute net retry waits */
	Defloadint = 180;			/* 3-minute load reports */
	Defprifor [0] = '\0';
	Defprique [0] = '\0';
	Fixed_shell [0] = '\0';			/* No fixed shell by default */
	Lifetime = 86400 * 7;			/* 1-week pipe queue lifetime */
	Logfilename [0] = '\0';			/* No default logfile */
        /* TAC Intergraph gave logfile default strcpy(Logfilename,"/usr/lib/nqs                /logfile");     */
	Maxcopies = 2;
	Maxextrequests = MAX_EXTREQUESTS;
	Maxgblacclimit = MAX_GBLACCLIMIT;
	Maxgblbatlimit = MAX_GBLBATLIMIT;
	Maxgblnetlimit = MAX_GBLNETLIMIT;
	Maxgblpiplimit = MAX_GBLPIPLIMIT;
	Maxoperet = 2;
	Maxprint = 1000000;
	Mail_uid = 0;				/* Default mail acct is root */
        daemon = getfilnam ("netdaemon", LIBDIR);
        strcpy (Netdaemon, daemon);             /* Default network daemon */
        relfilnam (daemon);

        daemon = getfilnam ("netserver", LIBDIR);
        strcpy (Netserver, daemon);             /* Default network server */
        relfilnam (daemon);

        daemon = getfilnam ("netclient", LIBDIR);
        strcpy (Netclient, daemon);             /* Default emptier of */
        relfilnam (daemon);                     /* network queues */

        daemon = getfilnam ("loaddaemon", LIBDIR);
        strcpy (Loaddaemon, daemon);             /* Default load daemon */
        relfilnam (daemon);                     
	Opewai = 5;
	Plockdae = 0;				/* Not locked in mem by def */
	Shell_strategy = SHSTRAT_FREE;		/* Free shell-choice */
	Termsignal = TERMSIG_DEFAULT;		/* Default request termsig */
	Udbgenparams = -1;			/* Offset of these three */
	Udbnetprocs = -1;			/* database records is */
	Udblogfile = -1;			/* not known */
	gendescr = nextdb (Paramfile);
	while (gendescr != (struct gendescr *) 0 &&
	       gendescr->v.par.paramtype != PRM_NETPEER) {
	    /*
	     *  This entry defines the general NQS operating parameters
	     *  record, the logfile record, or the network server definition
	     *  record.  These three (3) records ALWAYS appear as the first
 	     *  three records in the parameters file.
	     */
	    switch (gendescr->v.par.paramtype) {
	    case PRM_GENPARAMS:
		Udbgenparams = telldb (Paramfile);
		Mail_uid = gendescr->v.par.v.genparams.mail_uid;
		Maxgblacclimit = gendescr->v.par.v.genparams.maxgblacclimit;
		Maxgblbatlimit = gendescr->v.par.v.genparams.maxgblbatlimit;
		Maxgblnetlimit = gendescr->v.par.v.genparams.maxgblnetlimit;
		Maxgblpiplimit = gendescr->v.par.v.genparams.maxgblpiplimit;
		Plockdae = gendescr->v.par.v.genparams.plockdae;
		Shell_strategy = gendescr->v.par.v.genparams.shell_strategy;
		Termsignal = gendescr->v.par.v.genparams.termsignal;
		Debug = gendescr->v.par.v.genparams.debug;
		LB_Scheduler = gendescr->v.par.v.genparams.lb_scheduler;
		Defbatpri = gendescr->v.par.v.genparams.defbatpri;
		Defdevpri = gendescr->v.par.v.genparams.defdevpri;
		Maxcopies = gendescr->v.par.v.genparams.maxcopies;
		Maxextrequests = gendescr->v.par.v.genparams.maxextrequests;
		Maxoperet = gendescr->v.par.v.genparams.maxoperet;
		Maxprint = gendescr->v.par.v.genparams.maxprint;
		Opewai = gendescr->v.par.v.genparams.opewai;
		Defdesrettim = gendescr->v.par.v.genparams.defdesrettim;
		Defdesretwai = gendescr->v.par.v.genparams.defdesretwai;
		Defnetrettim = gendescr->v.par.v.genparams.defnetrettim;
		Defloadint = gendescr->v.par.v.genparams.defloadint;
		Defnetretwai = gendescr->v.par.v.genparams.defnetretwai;
		Lifetime = gendescr->v.par.v.genparams.lifetime;
		strcpy (Defprifor, gendescr->v.par.v.genparams.defprifor);
		strcpy (Defbatque, gendescr->v.par.v.genparams.defbatque);
		strcpy (Defprique, gendescr->v.par.v.genparams.defprique);
		strcpy (Fixed_shell, gendescr->v.par.v.genparams.fixed_shell);
		strcpy (Netdaemon, gendescr->v.par.v.genparams.netdaemon);
		strcpy (Loaddaemon, gendescr->v.par.v.genparams.loaddaemon);
		break;
	    case PRM_LOGFILE:
		Udblogfile = telldb (Paramfile);
		strcpy (Logfilename, gendescr->v.par.v.logfile);
		break;
	    case PRM_NETPROCS:
		Udbnetprocs = telldb (Paramfile);
		strcpy (Netserver, gendescr->v.par.v.netprocs.netserver);
		strcpy (Netclient, gendescr->v.par.v.netprocs.netclient);
		break;
	    }
	    gendescr = nextdb (Paramfile);
	}
}
