#  This procedure produces a window which allows the user to add, delete
#  and save to PADE's internal list the hosts for a given project.  It also
#  allows the user to modify the files for a given host and to save all
#  information to a file.
#
#  Post : hflist contains the hosts, their files, the files' remote names,
#  the files' dependencies, and the dependencies' remote names in the form:
#  {h {f rf {d rd d2 rd2...} f2 rf2 {d3 rd3...} ...} h2 ...}
#  where h represents a host, f represents a file, rf represents the file's
#  remote name, d represents a dependency, and rd represents the dependency's
#  remote name.
#
#  NOTE: any or all of the lists may be empty
#

proc SetUp {{w .setup}} {
   global entry1 entry2
   global hlist hflist gflist plist pcompile
   global filename openfile
   global compile
   global modhost modfile
   global hostfile
   global confirm
   global version
   global ntcol

   set hlist $plist
   set compile $pcompile
   set modhost 0
   set modfile 0
   set openfile ""

   catch {destroy $w}
   toplevel $w
   wm title $w "PADE Setup"
   wm iconname $w "Setup"
   wm geometry $w +170+218
   $w config -cursor {arrow red white}

   grab set $w

   frame   $w.f1 -bd 1 -relief raised
   frame   $w.f2 -bd 1 -relief raised
   frame   $w.f3 -bd 1 -relief raised
   frame   $w.f3.l
   frame   $w.f3.r
   frame   $w.f4 -bd 1 -relief raised
   frame   $w.f5 -bd 1 -relief raised

   message $w.f2.msg1 -text "      Host list" -width 300
   message $w.f2.msg2 -text "      Host commands" -width 300
   pack    $w.f2.msg1 $w.f2.msg2 -expand 1 -pady 3m -side left

   text	   $w.f4.text -height 2 -font -*-helvetica-bold-r-normal--*-120-*-*-* \
     -fg red -relief sunken -bd 2 -width 1
   pack    $w.f4.text -anchor w -padx 2m -pady 2m -fill x -expand 1 -anchor center

   pack    $w.f1 $w.f2 $w.f3 -side top -fill x
   pack    $w.f4 -fill x -expand 1 -anchor center
   pack    $w.f5 -side top -fill x

#-------------------------------------------------------------------------------
#  scroll box

   listbox $w.f3.l.listbox -yscroll "$w.f3.l.yscroll set" \
      -xscroll "$w.f3.l.xscroll set" -relief sunken -exportselection no
   scrollbar $w.f3.l.xscroll -relief sunken -command "$w.f3.l.listbox xview" \
      -orient horiz

   scrollbar $w.f3.l.yscroll -relief sunken \
      -command "SetUpScrollBoth $w.f3.l.listbox $w.f3.r.listbox"

   listbox $w.f3.r.listbox -yscroll "$w.f3.l.yscroll set" \
      -xscroll "$w.f3.r.xscroll set" -relief sunken -exportselection no
   scrollbar $w.f3.r.xscroll -relief sunken -command "$w.f3.r.listbox xview" \
      -orient horiz

   pack $w.f3.l.xscroll -side bottom -fill x
   pack $w.f3.l.yscroll -side left -fill y
   pack $w.f3.l.listbox -expand 1 -fill both -ipady 12m

   pack $w.f3.r.xscroll -side bottom -fill x
   pack $w.f3.r.listbox -expand 1 -fill both -ipady 12m
   pack $w.f3.l $w.f3.r -side left -expand 1 -fill both

   tk_listboxSingleSelect $w.f3.l.listbox
   tk_listboxSingleSelect $w.f3.r.listbox
   
   if {$hlist!=""} {
      set ccount 0
      foreach host $hlist {
	 set ccount [expr $ccount+1]
	 if {[expr $ccount%2]!=0} {.setup.f3.l.listbox insert end $host}
      }
      set ccount 0
      foreach compcmd $compile {
	 set ccount [expr $ccount+1]
	 .setup.f3.r.listbox insert end $compcmd
      }
   }
      

#-------------------------------------------------------------------------------
#  add a new entry to the host list

   button $w.f1.addhost -text "Add Host" -command {

#  read the host's name into entry1
      .setup.f3.l.listbox select clear
      .setup.f3.r.listbox select clear
      .setup.f4.text delete 1.0 end
      set entry1 ""
      AddHost "" "" ""

#  insert the host name and an empty file list into the list of hosts
#  add the compile command to the compile list
#  add the host name to the end of the list box
      if {$entry1!="CANCEL" && $entry1!=""} {
         set hlist [linsert $hlist [llength $hlist] $entry1 {}]
         set compile [linsert $compile [llength $compile] $entry2]
         .setup.f3.l.listbox insert [llength $hlist] $entry1
         .setup.f3.r.listbox insert [llength $compile] $entry2
	 if {[expr [llength $hlist]/2]>14} {
	    .setup.f3.l.listbox yview [expr [llength $hlist]/2-14]
	    .setup.f3.r.listbox yview [expr [llength $hlist]/2-14]
	 }
         .setup.f3.l.listbox select from [expr [llength $hlist]-1]
         .setup.f3.r.listbox select clear
         set modhost 1
      }

      SetUpConfigBtns
   }

#-------------------------------------------------------------------------------
#  add all hosts from hostfile

   button $w.f1.addhostfile -text "Add Hosts from Hostfile" -command {
      .setup.f3.l.listbox select clear
      .setup.f3.r.listbox select clear
      .setup.f4.text delete 1.0 end
      set f_hostfile [open "$hostfile" r]
      set notdone [gets $f_hostfile line]
      set nitem 0
      while {$notdone >= 0} {
         set write 0
         if {$line!=""} {
            set line [string trim $line]
            set fblank [string first " " $line]
            if {$fblank == -1} {
               set write 1
            } else {
               set fchar [string index $line 0]
               if {$fchar!="#" && $fchar!="*" } {
                  set line [lindex [split $line " "] 0]
                  set write 1
               }
            }
         } 
         if {$write} {
            set hlist [linsert $hlist [llength $hlist] $line {}]
            set compile [linsert $compile [llength $compile] {}]
            .setup.f3.l.listbox insert [llength $hlist] $line
            .setup.f3.r.listbox insert [llength $compile] {}
            set modhost 1
            set nitem [expr $nitem+1]
         }
         set notdone [gets $f_hostfile line]
      }
      if {[expr [llength $hlist]/2]>14} {
	 .setup.f3.l.listbox yview [expr [llength $hlist]/2-14]
	 .setup.f3.r.listbox yview [expr [llength $hlist]/2-14]
      }
      .setup.f4.text delete 1.0 end
      .setup.f4.text insert end \
	 "$nitem hosts added from $hostfile"
      SetUpConfigBtns 
   }
   if {$hostfile!="" && [file isfile $hostfile]} {
       .setup.f1.addhostfile configure -state normal
   } else {
       .setup.f1.addhostfile configure -state disabled
   }

#-------------------------------------------------------------------------------

#  modify an entry in the host list
   button $w.f1.modhost -text "Modify Host" -command {
#  get all highlighted files
      set index2 ""
      set index2 [.setup.f3.l.listbox curselection]

      if {$index2==""} {
	 .setup.f4.text delete 1.0 end
	 .setup.f4.text insert end \
	    "You must first select a host from the Host list" 

#  read the host's name into entry1
      } else {
	 .setup.f4.text delete 1.0 end
         if {$index2 >= 14} {
	    .setup.f3.l.listbox yview [expr $index2-7]
	    .setup.f3.r.listbox yview [expr $index2-7]
	 }
         .setup.f3.r.listbox select from $index2
         set templist [lindex $compile $index2]
         AddHost [lindex $hlist [expr 2*$index2]] [lindex $compile $index2] ""
#         AddHost [lindex $hlist [expr 2*$index2]] [lindex $templist 0] \
#            [lreplace $templist 0 0]


#  insert the host name and an empty file list into the list of hosts
#  add the compile command to the compile list
#  replace the host name in the list box
         if {$entry1!="CANCEL" && $entry1!=""} {
            set hlist [lreplace $hlist [expr 2*$index2] [expr 2*$index2] \
               $entry1 ]
            set compile [lreplace $compile $index2 $index2 $entry2]
            .setup.f3.l.listbox delete $index2
            .setup.f3.l.listbox insert $index2 $entry1
            .setup.f3.r.listbox delete $index2
            .setup.f3.r.listbox insert $index2 $entry2
            .setup.f3.l.listbox select from $index2
            set modhost 1
         }
         .setup.f3.r.listbox select clear
      }
      SetUpConfigBtns
   }

#-------------------------------------------------------------------------------
#  delete the selected items

   button $w.f1.delhost -text "Delete Host" -command {
      .setup.f3.r.listbox select clear
      set index1 ""
      set index1 [.setup.f3.l.listbox curselection]

      if {$index1==""} {
	 .setup.f4.text delete 1.0 end
	 .setup.f4.text insert end \
	    "You must first select a host from the Host list" 

      } else {
	 .setup.f4.text delete 1.0 end
         if {$index1 >= 14} {
	    .setup.f3.l.listbox yview [expr $index1-7]
	    .setup.f3.r.listbox yview [expr $index1-7]
	 }
         .setup.f3.r.listbox select from $index1
         set pick [Dialog .d 200 278 {PADE Question} \
            {Are you sure you want to Delete the host and all its commands and\
            files?} questhead 0 {Yes} {No}]

#  delete from the listbox
         if {$pick==0} {
            set modhost 1
            set dcount 0
            foreach i $index1 {
               .setup.f3.l.listbox delete [expr $i-$dcount]
               .setup.f3.r.listbox delete [expr $i-$dcount]
               set dcount [expr $dcount+1]
            }

#  delete from the host list
            set dcount 0
            foreach i $index1 {
               set hlist [lreplace $hlist [expr 2*($i-$dcount)] \
                  [expr 2*($i-$dcount)+1]]
               set compile [lreplace $compile [expr $i-$dcount] \
                  [expr $i-$dcount]]
               set dcount [expr $dcount+1]
            }
         }
      }
      SetUpConfigBtns
   }


#-------------------------------------------------------------------------------

#  modify the files of a host
   button $w.f1.addfile -text "Setup Files" -command {
#  get all highlighted files
      set index3 ""
      set index3 [.setup.f3.l.listbox curselection]

      if {$index3==""} {
	 .setup.f4.text delete 1.0 end
	 .setup.f4.text insert end \
	    "You must first select a host from the Host list" 
      } else {
	 .setup.f4.text delete 1.0 end

#  if exactly one host is selected, call AddSource with the name of the
#  selected host and the list of files on that host
         .setup.f3.r.listbox select clear
         AddSource [.setup.f3.l.listbox get $index3] \
            [lindex $hlist [expr 2*$index3+1]]

#  if AddSource was not exited with the "Cancel" command, replace the
#  host's file list with the one returned by AddSource
         if {$gflist!="CANCEL"} {
            set hlist [lreplace $hlist [expr 2*$index3+1] \
               [expr 2*$index3+1] $gflist]
         }
         .setup.f3.l.listbox select from $index3
      }
   }

#-------------------------------------------------------------------------------

#  bring up a graphical display of the hosts, files, and dependencies
   button $w.f1.treeview -text "Tree View" -command {
      .setup.f3.l.listbox select clear
      .setup.f4.text delete 1.0 end
       Tree
      .setup.f3.l.listbox delete 0 end
      set n 1
      foreach i $hlist {
         if {$n%2} {
            .setup.f3.l.listbox insert end $i
         }
         set n [expr $n+1]
      }

      .setup.f3.r.listbox delete 0 end
      foreach i $compile {
         .setup.f3.r.listbox insert end $i
      }
      SetUpConfigBtns
   }

   pack $w.f1.addhost $w.f1.addhostfile $w.f1.modhost $w.f1.delhost \
      $w.f1.addfile $w.f1.treeview -side left -ipadx 2m -ipady 1m -expand 1

#-------------------------------------------------------------------------------
#  File menu, save or read a configuration file

#  read hosts, files, and dependencies from a file

   button $w.f5.read -text "Open File" -command {
      .setup.f3.l.listbox select clear
      .setup.f3.r.listbox select clear
      .setup.f4.text delete 1.0 end
      if {$modhost || $modfile} {
         set pick [Dialog .d 200 278 {PADE Question} \
            {Your current work has not been Saved.  Are you sure you want to\
            Open a new file?} questhead 0 {Yes} {No}]
         if {$pick==1} return
      }
      set init 1
      set filename [FSBox "Open PADE file"]
      if {[file isdirectory $filename]} {
	 .setup.f4.text delete 1.0 end
	 .setup.f4.text insert end "$filename  IS NOT A FILE" 
         set filename ""
      }
      if {$filename!=""} {
         .setup config -cursor {watch red white}
         update idletasks
	 set modhost 0
	 set modfile 0
         set hstr    "host:"
         set fstr    "file:"
         set rfstr   "remotefile:"
         set dstr    "dependency:"
         set rdstr   "remotedependency:"
         set cstr    "compile:"
         set fname   [open "$filename" r]
         set notdone [gets $fname line]
         while {$notdone >= 0} {

#  add a host to the list
            if {[string first $hstr $line] == 0} {
               if {$init} {
                  set hlist   {}
                  set compile {}
                  .setup.f3.l.listbox delete 0 end
                  .setup.f3.r.listbox delete 0 end
                  set init 0
                  set openfile $filename
               }

#  add a host to the listbox
               set htemp [string trim [string trimleft $line $hstr]]
               set hlist [concat $hlist [lindex $htemp 0]]
               .setup.f3.l.listbox insert end [lindex $htemp 0]
               set notdone [gets $fname line]

#  add compile command to the listbox
               set compile [linsert $compile [llength $compile] \
        	  [string trimleft [string trimleft $line $cstr] " "]]
               .setup.f3.r.listbox insert end \
                  [string trim [string trimleft $line $cstr]]

               set notdone [gets $fname line]
               set tflist {}
               while {[string first $fstr $line] == 0} {

#  add a file to the list of files for the current host
        	 set lfile [string trimleft $line $fstr]
        	 if {$lfile==""} {set lfile "{}"}
        	 set tflist [concat $tflist [lindex $lfile 0]]
        	 gets $fname line

#  add the remote file name
        	  set rfile [string trimleft $line $rfstr]
        	  if {$rfile==""} {set rfile "{}"}
        	  set tflist [concat $tflist $rfile]
        	  set notdone [gets $fname line]
        	  set tdlist {}
        	  while {[string first $dstr $line] == 0} {

#  add a dependency to the list of dependencies for the current file
                     lappend tdlist [string trimleft $line $dstr]
                     gets $fname line

#  add the remote dependency to the list
                     lappend tdlist [string trimleft $line $rdstr]
                     set notdone [gets $fname line]
        	  }
#  add the dependencies to the list
        	  lappend tflist $tdlist
               }
#  add the files to the list
               lappend hlist $tflist

             } else {
               set notdone [gets $fname line]
            }
         }
         .setup config -cursor {arrow red white}
         update idletasks
      }
      SetUpConfigBtns
      if {$init && $filename!="" } {
         Dialog .d 200 278 {PADE Warning} \
            [concat $filename " is not a valid PADE file"] error 0 {OK}
      } 
      if {$openfile!=""} {
	 .setup.f4.text delete 1.0 end
	 .setup.f4.text insert end "Opened file:  $openfile"
	 set ntcol 4 
	 set ntrow 24 
      }
   }

#-------------------------------------------------------------------------------
#  save the hosts, files, and dependencies to a file

   button $w.f5.save -text "Save File" -command {
      .setup.f3.l.listbox select clear
      .setup.f3.r.listbox select clear
      .setup.f4.text delete 1.0 end
      set hstr  "host:"
      set cstr  "compile:"
      set fstr  "file:"
      set rfstr "remotefile:"
      set dstr  "dependency:"
      set rdstr "remotedependency:"
      set filename [FSBox "Save PADE file" $openfile]
      if {[file isdirectory $filename]} {
	 .setup.f4.text delete 1.0 end
	 .setup.f4.text insert end "$filename  IS NOT A FILE" 
         set filename ""
      }
      if {$filename!=""} {
         if {[file exists $filename] && [file exists $filename.pvmmake]} {
            set pick [Dialog .d 200 278 {PADE Question} \
               [concat "Overwrite " $filename "\n AND " $filename.pvmmake " ?"] \
               questhead 0 {Overwrite} {Cancel}]
            if {$pick==1} return
         } elseif {[file exists $filename]} {
            set pick [Dialog .d 200 278 {PADE Question} \
               [concat "Overwrite " $filename " ?"] \
               questhead 0 {Overwrite} {Cancel}]
            if {$pick==1} return
         } elseif {[file exists $filename.pvmmake]} {
            set pick [Dialog .d 200 278 {PADE Question} \
               [concat "Overwrite " $filename.pvmmake " ?"] \
               questhead 0 {Overwrite} {Cancel}]
            if {$pick==1} return
         }
        .setup config -cursor {watch red white}
         update idletasks
	 set modhost 0
	 set modfile 0

#  PADE file
         set f_pade [open "$filename" w]
         set openfile $filename

#  pvmmake config file
#         set f_pvmmake [open "$filename.pvmmake" w]
#         set date [exec date]
#         puts $f_pvmmake \
#            "#  PVMMAKE configuration file"
#         puts $f_pvmmake \
#            "#  Written by PADE ($version) on $date\n "

#  list of hosts
         set indcompile1 0
         set indcompile2 0
         set indhost 0
         set nlf 0
         set nhst 0
         foreach shost $hlist {

#  write hosts
            if {[expr $indhost%2]==0} {
               puts $f_pade "$hstr $shost"
               puts $f_pade [concat $cstr [lindex $compile $indcompile1]]
#               puts $f_pvmmake \
#                  "#--------------------\n#  broadcast FILES to $shost\n"
               set writehost $shost
               set indcompile1 [expr 1+$indcompile1]
            }

#  write files
            set indfile 0
            if {[expr $indhost%2]==1} {
               foreach sfile $shost {

#  local file
                  if {[expr $indfile%3]==0} {
                     puts $f_pade [concat $fstr $sfile]
                     set plfile $sfile

                     set clf 0
                     Do i 1 $nlf {
                        if {"$lf($i)"==$sfile} {set clf $i}
                     }
                     if {$clf==0} {
                	set nlf [expr $nlf+1]
                	set lf($nlf) $sfile
                	set clf $nlf
                	set hrf($nlf) ""
                     }
                  }

#  remote file
                  if {[expr $indfile%3]==1} {
                     puts $f_pade [concat $rfstr $sfile]
                     if {($plfile!="") && ($sfile!="")} {
#                	puts $f_pvmmake $plfile
#                	puts $f_pvmmake "$writehost $sfile\n "
                     }
                     set tmphrf "$writehost $sfile"
                     lappend hrf($clf) $tmphrf 
                  }
                  if {[expr $indfile%3]==2} {

#  write dependencies
                     set inddep 0
                     foreach sdepend $sfile {
                        if {[expr $inddep%2]==0} {
                           puts $f_pade [concat $dstr $sdepend]
 #                          puts $f_pvmmake [string trimleft $sdepend]
                        }
                        if {[expr $inddep%2]==1} {
                           puts $f_pade [concat $rdstr $sdepend]
#                           puts $f_pvmmake \
#                              "$writehost [string trimleft $sdepend]\n "
                        }
                        set inddep [expr $inddep+1]
                     }
                  }
                  set indfile [expr $indfile+1]
               }

 #  write compile command to pvmmake configuration file
               set compcmd [lindex $compile $indcompile2]
#               puts $f_pvmmake \
#                  "#--------------------\n#  broadcast COMMANDS to $writehost\n"
               if {$compcmd!=""} {
#        	  puts $f_pvmmake "@ $writehost $compcmd +errors\n"
        	  set nhst [expr $nhst+1]
        	  set hcmd($nhst) "$writehost $compcmd"
               }
               set indcompile2 [expr $indcompile2+1]
            }
            set indhost [expr $indhost+1]
         }
         close $f_pade
#         close $f_pvmmake

#  pvmmake config file
         set f_pvmmake [open "$filename.pvmmake" w]
         set date [exec date]
         puts $f_pvmmake \
            "#  PVMMAKE configuration file"
         puts $f_pvmmake \
            "#  Written by PADE ($version) on $date"

         Do i 1 $nlf {
            puts $f_pvmmake \
               "\n#--------------------\n#  broadcast FILE $lf($i)\n"
            puts $f_pvmmake $lf($i)
            set j 0
            foreach line $hrf($i) {
               puts $f_pvmmake $line
            } 
         }
         Do i 1 $nhst {
            puts $f_pvmmake \
               "\n#--------------------\n#  broadcast COMMANDS to [lindex $hcmd($i) 0]\n"
            puts $f_pvmmake "@ $hcmd($i) +errors"
         }
            
         close $f_pvmmake

         .setup config -cursor {arrow red white}
         update idletasks

	 if {[string length $filename] < 60} {
	    set tmpname $filename
	 } else {
	    set tailname [file tail $filename]
	    set tmpname .../$tailname
	 }
	 .setup.f4.text delete 1.0 end
	 .setup.f4.text insert end "Saved pade file:  $tmpname  AND" 
	 .setup.f4.text insert end \
	    "\npvmmake config file:  $tmpname.pvmmake" 
      }
   }

#-------------------------------------------------------------------------------
   button $w.f5.done -text "Done" -command {
      .setup.f3.l.listbox select clear
      .setup.f3.r.listbox select clear
      .setup.f4.text delete 1.0 end
      if {$hlist!=""} {
         if {$modfile || $modhost} {
            set pick [Dialog .d 200 278 {PADE Question} \
               {Your current work has not been Saved.  Are you sure\
               you're done?} questhead 0 {Yes} {No}]
	 } else {
	    if {$confirm=="on"} {
               set pick [Dialog .d 200 278 {PADE Question} \
        	  {Are you sure you're done?} \
        	  questhead 0 {Yes} {No}]
            } else {
               set pick 0
            }
	 }
	 if {$pick==0} {
	    set openfile ""
            set hflist $hlist
            destroy .setup
	 }
      } else {
	 set openfile ""
         set hflist $hlist
         destroy .setup
      }
   }

   pack $w.f5.read $w.f5.save $w.f5.done \
      -side left -expand 1 -padx 3m -pady 4m -ipadx 2m -ipady 1m

#-------------------------------------------------------------------------------

   SetUpConfigBtns

   bind $w.f3.r.listbox <Any-ButtonPress> { }
   bind $w.f3.r.listbox <Any-ButtonRelease> { }
   bind $w.f3.r.listbox <B1-Motion> { }
   bind $w.f3.l.listbox <B2-Motion> { }
   bind $w.f3.r.listbox <B2-Motion> { }

   tkwait window $w

}

################################################################################

proc SetUpConfigBtns { } {
   global hlist
   if {$hlist==""} {
      .setup.f1.delhost configure -state disabled
      .setup.f1.modhost configure -state disabled
      .setup.f1.addfile configure -state disabled
      .setup.f5.save configure -state disabled
   } else {
      .setup.f1.delhost configure -state normal
      .setup.f1.modhost configure -state normal
      .setup.f1.addfile configure -state normal
      .setup.f5.save configure -state normal
   }
}
################################################################################

proc SetUpScrollBoth {l1 l2 args} {
   $l1 yview $args
   $l2 yview $args
}
   
################################################################################

#
#  PADE procedure allows the user to input values for a new host or to modify
#  an old one.  It inputs the host's name, its compile command, and any compile
#  options
#
#  Pre: hst, comp and libs are the existing values for the three inputs
#

proc AddHost {hst comp libs {w .addhst}} {
   global entry1 entry2
   catch {destroy $w}
   toplevel $w
   wm title $w "PADE Add Host"
   wm iconname $w "Add Host"
   wm geometry $w +230+338
   $w config -cursor {arrow red white}

   tkwait visibility $w
   grab set $w

   frame   $w.f1 -bd 1 -relief raised
   message $w.f1.msg -text "Host name:        " -width 1000
   entry   $w.f1.entry -textvariable hostname -relief sunken -width 55
   pack    $w.f1.msg $w.f1.entry -side left -expand 1 -padx 2m -pady 5m
   $w.f1.entry delete 0 end
   $w.f1.entry insert 0 $hst

   frame   $w.f2 -bd 1 -relief raised
   message $w.f2.msg -text "Host commands:" -width 1000
   entry   $w.f2.entry -textvariable compilecmd -relief sunken -width 55
   pack    $w.f2.msg $w.f2.entry -side left -expand 1 -padx 2m -pady 5m
   $w.f2.entry delete 0 end
   $w.f2.entry insert 0 $comp

#   frame     $w.f3 -borderwidth 10
#   message   $w.f3.msg -text \
#      "Compile line options (not implemented):" -width 1000
#   text      $w.f3.entry -relief sunken -bd 2 -yscrollcommand "$w.f3.s set" \
#      -setgrid true -width 50 -height 10
#   scrollbar $w.f3.s -relief sunken -command "$w.f3.entry yview"
#   pack      $w.f3.msg -side top
#   pack      $w.f3.entry $w.f3.s -side left -fill y
#   $w.f3.entry delete 0.0 end
#   $w.f3.entry insert 0.0 $libs
#   $w.f3.entry mark set insert 0.0

   frame   $w.f4 -bd 1 -relief raised
   button  $w.f4.clear1 -text "Clear Name" -command {
      .addhst.f1.entry delete 0 end
      set hostname ""
      focus .addhst.f1.entry
   }
   button  $w.f4.clear2 -text "Clear Commands" -command {
      .addhst.f2.entry delete 0 end
      set compilecmd ""
      focus .addhst.f2.entry
   }
   button  $w.f4.save -text "Save" -command {
      set hostname [string trim $hostname]
      set entry1 $hostname
      set iblank 0
      if {[string first " " $hostname]!=-1} {Dialog .d 260 398 {PADE Warning} \
            {The host name has a blank in it} error 0 {OK}}
      set entry2 $compilecmd
      destroy .addhst
   }
   button  $w.f4.cancel -text "Cancel" -command {
      set entry1 "CANCEL"
      destroy .addhst
   }
   pack $w.f4.clear1 $w.f4.clear2 $w.f4.save $w.f4.cancel \
     -side left -expand 1 -padx 3m -pady 4m -ipadx 2m -ipady 1m
    

   pack  $w.f1 $w.f2 -anchor w -fill x
   pack  $w.f4 -fill x
   focus $w.f1.entry

   bind $w.f1.entry <Return> {
      set hostname [string trim $hostname]
      focus .addhst.f2.entry
   }
   bind $w.f1.entry <Tab> {
      set hostname [string trim $hostname]
      focus .addhst.f2.entry
   }

   bind $w.f2.entry <Return> {
      set compilecmd [string trim $compilecmd]
#      focus .addhst.f3.entry
   }
   bind $w.f2.entry <Tab> {
      set compilecmd [string trim $compilecmd]
#      focus .addhst.f3.entry
   }

   tkwait window $w
}
