#  This procedure produces a window which allows the user to add, delete,
#  edit, modify the dependencies of, and save to PADE's internal list the names
#  and remote host locations of files corresponding to a particular host
#
#  Pre: host is the name of the host to which the files correspond
#      list contains the list of files, their remote hosts, and their
#      dependencies
#
#  Post: gflist contains the files, their remote names, and their dependencies
#       in the form:
#         {f1 rf1 {d11 rd11 d12 rd12...} f2 rf2 {d21 rd21 d22 rd22...}...}
#
#       where f# represents a file, rf# represents the file's name on the
#       remote host, d## represents a dependency, and rd## represents its remote
#       host name.
#       NOTE: any or all of the lists may be empty
#

proc AddSource {host list {w .addsrc}} {
   global entry1 entry2
   global flist gflist
   global modhost modfile
   global confirm

   set flist $list
   set modfile 0

   catch {destroy $w}
   toplevel $w
   wm title $w "PADE Files"
   wm iconname $w "Files"
   wm geometry $w +200+278
   $w config -cursor {arrow red white}

   grab set $w

   frame   $w.f1 -bd 1 -relief raised
   frame   $w.f2 -bd 1 -relief raised
   frame   $w.f3 -bd 1 -relief raised
   frame   $w.f4 -bd 1 -relief raised
   frame   $w.f5 -bd 1 -relief raised

   message $w.f2.msg \
     -text "File list for host $host (local --> remote)" -width 600
   pack    $w.f2.msg -expand 1 -pady 3m

   text	   $w.f5.text -height 2 -font -*-helvetica-bold-r-normal--*-120-*-*-* \
     -fg red -relief sunken -bd 2
   pack    $w.f5.text -anchor w -padx 2m -pady 2m -fill x

   pack    $w.f1 $w.f2 $w.f3 $w.f5 $w.f4 -side top -fill x

#-------------------------------------------------------------------------------

   scrollbar $w.f3.yscroll -relief sunken -command "$w.f3.listbox yview"
   scrollbar $w.f3.xscroll -relief sunken -command "$w.f3.listbox xview" \
      -orient horiz
   listbox $w.f3.listbox -yscroll "$w.f3.yscroll set" \
      -xscroll "$w.f3.xscroll set" -relief sunken
   pack $w.f3.xscroll -side bottom -fill x
   pack $w.f3.yscroll -side right -fill y
   pack $w.f3.listbox -expand 1 -fill both -ipady 20m
   tk_listboxSingleSelect $w.f3.listbox

#  Insert the files passed to the procedure into the listbox
   for {set i 0} {$i < [llength $list]} {set i [expr $i+3]} {
      .addsrc.f3.listbox insert end [concat [lindex $list $i] "-->" \
         [lindex $list [expr $i+1]]]
   }

#-------------------------------------------------------------------------------

#  add a new entry to the file list
   button $w.f1.add -text "Add Entry" -command {

#  read the file's local and remote names into entry1 and entry2
      .addsrc.f5.text delete 1.0 end
      .addsrc.f3.listbox select clear
      AddFile "" "" "ADD"

#  insert the values and an empty dependency list into the list of files
#  and add entry1 and entry2 to the listbox
      if {$entry1!="" || $entry2!=""} {
         set flist [linsert $flist [llength $flist] $entry1 $entry2 {}]
         .addsrc.f3.listbox insert [llength $flist] \
            [concat $entry1 "-->" $entry2]
         set modfile 1
	 if {[expr [llength $flist]/3]>17} \
	    {.addsrc.f3.listbox yview [expr [llength $flist]/3-17]}
         .addsrc.f3.listbox select from [expr [llength $flist]-1]
      }
      AddSrcConfigBtns
   }

#-------------------------------------------------------------------------------

#  delete the selected items
   button $w.f1.delete -text "Delete Entry" -command {
      set index4 ""
      set index4 [.addsrc.f3.listbox curselection]

      if {$index4==""} {
	 .addsrc.f5.text delete 1.0 end
	 .addsrc.f5.text insert end \
	    "You must first select an entry from the File list" 

      } else {
      
#  delete from the listbox
	 .addsrc.f5.text delete 1.0 end
         set modfile 1
         set dcount 0
         foreach i $index4 {
            .addsrc.f3.listbox delete [expr $i-$dcount]
            set dcount [expr $dcount+1]
         }

#  delete from the dependency list
         set dcount 0
         foreach i $index4 {
            set flist [lreplace $flist [expr 3*($i-$dcount)] \
               [expr 3*($i-$dcount)+2]]
            set dcount [expr $dcount+1]
         }
      }
      AddSrcConfigBtns
   }

#-------------------------------------------------------------------------------

#  modify the selected items
   button $w.f1.modify -text "Modify Entry" -command {
      set index5 ""
      set index5 [.addsrc.f3.listbox curselection]
      if {$index5==""} {
	 .addsrc.f5.text delete 1.0 end
	 .addsrc.f5.text insert end \
	    "You must first select an entry from the File list" 

      } else {
	 .addsrc.f5.text delete 1.0 end
         set modfile 1
         set lfile [lindex [split [.addsrc.f3.listbox get $index5] " -->"] 0]
         set rfile [lindex [split [.addsrc.f3.listbox get $index5] " -->"] 5]
         AddFile $lfile $rfile "MOD"
                     
#  null entry1s, same as deleting
         if {($entry1=="") && ($entry2=="")} {
            set dcount 0
            foreach i $index5 {
               .addsrc.f3.listbox delete [expr $i-$dcount]
               set dcount [expr $dcount+1]
            }
            set dcount 0
            foreach i $index5 {
               set flist [lreplace $flist [expr 3*($i-$dcount)] \
                  [expr 3*($i-$dcount)+2]]
               set dcount [expr $dcount+1]
            }
#  non-null entry1s            
         } else {
            set flist [lreplace $flist [expr 3*($index5)] \
               [expr 3*($index5)+1] $entry1 $entry2]
            .addsrc.f3.listbox delete $index5
            .addsrc.f3.listbox insert $index5 \
               [concat $entry1 "-->" $entry2]
           .addsrc.f3.listbox select from $index5
	 }
      }
      AddSrcConfigBtns
   }

#-------------------------------------------------------------------------------

#  copy local entries from another host
   button $w.f1.copy1 -text "Copy Entry" -command {
      set index6 ""
      set index6 [.addsrc.f3.listbox curselection]
      if {$index6==""} {
	 .addsrc.f5.text delete 1.0 end
	 .addsrc.f5.text insert end \
	    "You must first select an entry from the File list" 

      } else {
         set modfile 1
         set entry1 [lindex [split [.addsrc.f3.listbox get $index6] " -->"] 0]
         set entry2 [lindex [split [.addsrc.f3.listbox get $index6] " -->"] 5]
         set flist [linsert $flist [llength $flist] $entry1 $entry2 {}]
         .addsrc.f3.listbox insert [llength $flist] \
            [concat $entry1 "-->" $entry2]
         .addsrc.f3.listbox select from [expr [llength $flist]/3-1]
	 if {[expr [llength $flist]/3]>17} \
	    {.addsrc.f3.listbox yview [expr [llength $flist]/3-17]}
	 .addsrc.f5.text delete 1.0 end
	 .addsrc.f5.text insert end "Copied file: $entry1" 
      }
      AddSrcConfigBtns
   }

#-------------------------------------------------------------------------------

#  copy local entries from another host
   button $w.f1.copy2 -text "Duplicate Entries From Host" -command {
      .addsrc.f5.text delete 1.0 end
      .addsrc.f3.listbox select clear
      set clist ""
      set cmode "LR"
      CopyHost clist cmode chost
      if {$clist!="CANCEL"} {
	 set ccount 0
	 set nitem 0
	 foreach item $clist {
            set modfile 1
            set ccount [expr $ccount+1]
            if {$ccount==3} {
               set entry13 $item
               set flist [linsert $flist [llength $flist] \
        	  $entry1 $entry2 $entry13]
               .addsrc.f3.listbox insert [llength $flist] \
        	  [concat $entry1 "-->" $entry2]
               set ccount 0
               set nitem [expr $nitem+1]
            } elseif {$ccount==2} {
               if {$cmode=="LR"} {
        	  set entry2 $item
               } else {
        	  set entry2 ""
               }
            } else {
               set entry1 $item
            }
	 }

	 if {[expr [llength $flist]/3]>17} \
	    {.addsrc.f3.listbox yview [expr [llength $flist]/3-17]}
	 .addsrc.f3.listbox select clear
	 .addsrc.f5.text delete 1.0 end
	 .addsrc.f5.text insert end "$nitem files duplicated from $chost" 
      }
      AddSrcConfigBtns
   }

#-------------------------------------------------------------------------------

#  copy local entries from another host
   button $w.f1.replace -text "Global Replace Entries" -command {
      .addsrc.f5.text delete 1.0 end
      .addsrc.f3.listbox select clear
      Replace
      if {$entry1!=""} {
         set modfile 1
	 set i 1
	 set nflist ""
	 set len [string length $entry1]
	 foreach name $flist {
            regsub -all $entry1 $name $entry2 newname
            set name $newname
            set nflist [linsert $nflist [llength $nflist] $name]
            set i [expr $i+1]
	 }
	 set flist $nflist
	 .addsrc.f3.listbox delete 0 end
	 for {set i 0} {$i < [llength $flist]} {set i [expr $i+3]} {
	    .addsrc.f3.listbox insert end [concat [lindex $flist $i] "-->" \
               [lindex $flist [expr $i+1]]]
	 }
      }
      AddSrcConfigBtns
   }
   
#-------------------------------------------------------------------------------

#  edit the selected file
   button $w.f1.edit -text "Edit File" -command {
      set index7 ""
      set index7 [.addsrc.f3.listbox curselection]
      if {$index7==""} {
	 .addsrc.f5.text delete 1.0 end
	 .addsrc.f5.text insert end \
	    "You must first select an entry from the File list" 

#  send just the filename (not the --> and the remote filename)
      } else {
	 .addsrc.f5.text delete 1.0 end
         EditFile [lindex [split [.addsrc.f3.listbox get $index7] " -->"] 0]
         .addsrc.f3.listbox select from $index7
      }
   }

#-------------------------------------------------------------------------------
#
#  # Modify the dependencies of a file
#  button $w.f1.dependencies -text "Setup Dependency" -command {
#  get all highlighted files
#      set index8 ""
#    set index8 [.addsrc.f3.listbox curselection]
#  find how many there are
#    set i [llength $index8]
#
#  nothing is selected
#    if {$i==0} {
#	 if {$confirm=="on"} {Dialog .d 230 338 {PADE Warning} \
#	    {You must first select an entry from the File list} error 0 {OK}}
#    }
#
#    # if exactly one file is selected, call getdepencies with the name of the
#    # selected file and the list of the dependencies
#    if {$i==1} {
#      AddDepend [lindex8 $flist [expr 3*$index8]] \
#         [lindex8 $flist [expr 3*$index8+2]]
#
#      # if AddDepend was not exited with the "Cancel" command, replace
#      # the file's dependency list with the one returned by AddDepend
#      if {$gdlist!="CANCEL"} {
#        set flist [lreplace $flist [expr 3*$index8+2] [expr 3*$index8+2] \
#          $gdlist]
#      }
#    }
#  }
#

   pack $w.f1.add $w.f1.copy1 $w.f1.copy2 $w.f1.modify \
      $w.f1.replace $w.f1.delete $w.f1.edit -side left -ipadx 2m -ipady 1m

#-------------------------------------------------------------------------------

#  send back the new list of files in gflist and exit
   button $w.f4.save -text "Save" -command {
      .addsrc.f5.text delete 1.0 end
      set gflist $flist
      destroy .addsrc
   }

#  send back "CANCEL" inplace o the dependency list and exit
   button $w.f4.cancel -text "Cancel" -command {
      .addsrc.f5.text delete 1.0 end
      if {$modfile} {
         if {$confirm=="on"} {
            set pick [Dialog .d 230 338 {PADE Question} \
               {Are you sure you want to Cancel your changes?} \
               questhead 0 {Yes} {No}]
         } else {
            set pick 0
         }
      } else {
         set pick 0
      }
      if {$pick==0} { 
	 set modfile 0
	 set gflist "CANCEL"
	 destroy .addsrc
      }
   }

#-------------------------------------------------------------------------------

   pack $w.f4.save $w.f4.cancel \
      -side left -expand 1 -padx 3m -pady 4m -ipadx 2m -ipady 1m
   
   AddSrcConfigBtns

   tkwait window $w
}

################################################################################

proc AddSrcConfigBtns { } {
   global flist
   if {$flist==""} {
      .addsrc.f1.delete configure -state disabled
      .addsrc.f1.modify configure -state disabled
      .addsrc.f1.copy1 configure -state disabled
      .addsrc.f1.edit configure -state disabled
      .addsrc.f1.replace configure -state disabled
      .addsrc.f4.save configure -state disabled
   } else {
      .addsrc.f1.delete configure -state normal
      .addsrc.f1.modify configure -state normal
      .addsrc.f1.copy1 configure -state normal
      .addsrc.f1.edit configure -state normal
      .addsrc.f1.replace configure -state normal
      .addsrc.f4.save configure -state normal
   }
}

################################################################################

#
#  PADE input the local and remote names for a file or dependency
#
#  Pre: remotefile and localfile are names to be modified
#
#  Post: entry1 and entry2 are the local and remote names respectively
#

proc AddFile {localfile remotefile mode {w .addfil}} {
   global lfile rfile afmode localpath remotepath confirm
   catch {destroy $w}
   toplevel $w
   if {$mode=="ADD"} {
      wm title $w "PADE Add File"
      wm iconname $w "Add File"
   } elseif {$mode=="MOD"} {
      wm title $w "PADE Modify File"
      wm iconname $w "Modify File"
   }
   wm geometry $w +260+398
   $w config -cursor {arrow red white}

   tkwait visibility $w
   grab set $w

   set lfile $localfile
   set rfile $remotefile
   set afmode $mode

#-------------------------------------------------------------------------------
   frame   $w.f1 -bd 2 -relief raised
   frame   $w.f1.top
   frame   $w.f1.bot
   message $w.f1.top.msg -text "Local file:   " -width 1000
   entry   $w.f1.top.entry -textvariable localname -relief sunken -width 55
   $w.f1.top.entry delete 0 end
   $w.f1.top.entry insert 0 $localfile

   button  $w.f1.bot.clear -text "Clear" -command {
      .addfil.f1.top.entry delete 0 end
      focus .addfil.f1.top.entry
   }
   button  $w.f1.bot.fill -text "Fill with last path" -command {
      if {$localpath!=""} {
	 .addfil.f1.top.entry delete 0 end
	 .addfil.f1.top.entry insert 0 $localpath
         focus .addfil.f1.top.entry
      }
   }
   button  $w.f1.bot.filefind -text "File Browser" -command {
      set ffile [FSBox "Select existing file"]
      if {$ffile!=""} {set localname $ffile}
      focus .addfil.f1.top.entry
   }
   pack    $w.f1.top.msg $w.f1.top.entry -side left -padx 3m
   pack    $w.f1.bot.clear $w.f1.bot.fill $w.f1.bot.filefind \
      -side left -expand 1 -padx 3m -ipadx 2m -ipady 1m
   pack    $w.f1.top $w.f1.bot -fill x -pady 4m

#-------------------------------------------------------------------------------
   frame   $w.f2 -bd 2 -relief raised
   frame   $w.f2.top
   frame   $w.f2.bot
   message $w.f2.top.msg -text "Remote file:" -width 1000
   entry   $w.f2.top.entry -textvariable remotename -relief sunken -width 55
   $w.f2.top.entry delete 0 end
   $w.f2.top.entry insert 0 $remotefile
   button  $w.f2.bot.clear -text "Clear" -command {
      .addfil.f2.top.entry delete 0 end
      focus .addfil.f2.top.entry
   }
   button  $w.f2.bot.fill -text "Fill with last path" -command {
      if {$remotepath!=""} {
	 .addfil.f2.top.entry delete 0 end
	 .addfil.f2.top.entry insert 0 $remotepath
         focus .addfil.f2.top.entry
      }
   }
   pack    $w.f2.top.msg $w.f2.top.entry -side left -padx 3m -pady 4m
   pack    $w.f2.bot.clear $w.f2.bot.fill \
      -side left -expand 1 -padx 3m -pady 4m -ipadx 2m -ipady 1m
   pack    $w.f2.top $w.f2.bot -fill x

#-------------------------------------------------------------------------------
   frame  $w.f3 -bd 2 -relief raised
   button $w.f3.save -text "Save" -command {
      set localname [string trim $localname]
      set remotename [string trim $remotename]
      
      if {$confirm=="on"} {
	 if {$afmode=="ADD"} {
            if {($localname=="" && $remotename!="") ||
               ($localname!="" && $remotename=="") } {
               Dialog .d 290 458 {PADE Warning} \
        	  {No local or remote file entered} error 0 {OK}
            }
	 } else {
            if {($localname=="" || $remotename=="")} {
               Dialog .d 290 458 {PADE Warning} \
        	  {No local or remote file entered} error 0 {OK}
            }
	 }
	 set iblank 0
	 if {[string first " " $localname]!=-1} {set iblank 1}
	 if {[string first " " $remotename]!=-1} {set iblank 1}
	 if {$iblank} {Dialog .d 290 458 {PADE Warning} \
               {The local or remote file name has a blank in it} error 0 {OK}}

	 set islash 0
	 if {[string index $localname \
	    [expr [string length $localname]-1]]=="/"} {set islash 1}
	 if {[string index $remotename \
	    [expr [string length $remotename]-1]]=="/"} {set islash 1}
	 if {$islash} {Dialog .d 290 458 {PADE Warning} \
               {The local or remote file name is a directory} error 0 {OK}}
      }
      
      set entry1 $localname
      set entry2 $remotename

      if {$localname!=""} {
	 set temp  [split $localname /]
	 set ltemp [llength $temp]
	 set temp  [lreplace $temp [expr $ltemp-1] [expr $ltemp-1] {}] 
	 set localpath [join $temp /]
      }
      if {$remotename!=""} {
	 set temp  [split $remotename /]
	 set ltemp [llength $temp]
	 set temp  [lreplace $temp [expr $ltemp-1] [expr $ltemp-1] {}] 
	 set remotepath [join $temp /]
      }
      destroy .addfil
   }
   button $w.f3.cancel -text "Cancel" -command {
      if {$afmode=="MOD"} {
         set entry1 $lfile
         set entry2 $rfile
      } else {
         set entry1 ""
         set entry2 ""
      }
      destroy .addfil
   }
   pack $w.f3.save $w.f3.cancel \
      -side left -expand 1 -padx 3m -pady 4m -ipadx 2m -ipady 1m

#-------------------------------------------------------------------------------

   pack $w.f1 $w.f2 $w.f3 -fill x
   focus $w.f1.top.entry

   bind $w.f1.top.entry <Return> {
      focus .addfil.f2.top.entry
   }
   bind $w.f1.top.entry <Tab> {
      focus .addfil.f2.top.entry
   }
   bind $w.f2.top.entry <Return> { }

   if {$localpath==""} {
      $w.f1.bot.fill configure -state disabled
   } else {
      $w.f1.bot.fill configure -state normal
   }
   if {$remotepath==""} {
      $w.f2.bot.fill configure -state disabled
   } else {
      $w.f2.bot.fill configure -state normal
   }

   tkwait window $w
}

################################################################################

#  PADE copy the files from one host to another

proc CopyHost {clist cmode chost {w .cphst}} {
   global entry1
   global hlist
   global confirm
   global ccount ccount1
   catch {destroy $w}
   toplevel $w
   wm title $w "PADE Copy"
   wm iconname $w "Copy"
   wm geometry $w +260+398
   $w config -cursor {arrow red white}

   grab set $w

   frame   $w.f1 -bd 1 -relief raised
   message $w.f1.msg -text "Host list" -width 300
   pack    $w.f1.msg -expand 1 -pady 5m

   frame   $w.f2 -bd 1 -relief raised
   frame   $w.f3 -bd 1 -relief raised
   frame   $w.f4 -bd 1 -relief raised
   pack    $w.f1 $w.f2 $w.f3 $w.f4 -side top -fill x

#-------------------------------------------------------------------------------
#  scroll box
   scrollbar $w.f2.scroll -relief sunken -command "$w.f2.listbox yview"
   listbox $w.f2.listbox -yscroll "$w.f2.scroll set" -relief sunken
   pack $w.f2.scroll -side right -fill y
   pack $w.f2.listbox -expand 1 -fill both
   tk_listboxSingleSelect $w.f2.listbox

   set ccount 0
   foreach host $hlist {
      set ccount [expr $ccount+1]
      if {[expr $ccount%2]!=0} {.cphst.f2.listbox insert end $host}
   }

#-------------------------------------------------------------------------------

   message $w.f3.msg -text "Copy which files: " -width 300
   radiobutton $w.f3.lr -text "Local and remote" -variable cmode -value "LR" \
      -padx 10
   radiobutton $w.f3.lo -text "Local only" -variable cmode -value "LO" \
      -padx 10
   pack $w.f3.msg $w.f3.lr $w.f3.lo \
      -side left -expand 1 -padx 3m -pady 4m -ipadx 2m -ipady 1m
   
#-------------------------------------------------------------------------------

#  send back the new list of files in clist and exit
   button $w.f4.ok -text "OK" -command {
      set ccount 0
      set index9 [.cphst.f2.listbox curselection]
      if {$index9==""} {
	 if {$confirm=="on"} {Dialog .d 290 458 {PADE Warning} \
	    {You must first select a host from the Host list} error 0 {OK}}
      } else {
         set chost [.cphst.f2.listbox get $index9]
         foreach lhost $hlist {
            set ccount [expr $ccount+1]
            if {$ccount%2!=0} {
               if {$lhost == $chost} {
                  set cindex [expr $ccount+1]
                  set ccount1 0
                  foreach lfile $hlist {
                     set ccount1 [expr $ccount1+1]
                     if {$cindex == $ccount1} {set clist $lfile}
                  }
               }
            }
         }
         if {$cmode=="LO" && $confirm=="on"} {Dialog .d 290 458 {PADE Warning} \
	       {Entries must be Modified to add remote file names} error 0 {OK} }
         destroy .cphst
      }
   }
   
   button $w.f4.cancel -text "Cancel" -command {
      set clist "CANCEL"
      destroy .cphst
   }

   pack $w.f4.ok $w.f4.cancel \
      -side left -expand 1 -padx 3m -pady 4m -ipadx 2m -ipady 1m

   bind $w.f2.listbox <Double-1> {
      set ccount 0
      set index9 [.cphst.f2.listbox curselection]
      set chost [.cphst.f2.listbox get $index9]
      foreach lhost $hlist {
         set ccount [expr $ccount+1]
         if {$ccount%%2 != 0} {
            if {$lhost == $chost} {
               set cindex [expr $ccount+1]
               set ccount1 0
               foreach lfile $hlist {
                  set ccount1 [expr $ccount1+1]
                  if {$cindex == $ccount1} {set clist $lfile}
               }
            }
         }
      }
      if {$cmode=="LO" && $confirm=="on"} {Dialog .d 290 458 {PADE Warning} \
	    {Modify Entries to add remote file names} error 0 {OK} }
      destroy .cphst
   }

   tkwait window $w
}

################################################################################

#  PADE global string replacement for file names

proc Replace {{w .rep}} {
   global entry1 entry2
   catch {destroy $w}
   toplevel $w
   wm title $w "PADE Global Replace"
   wm iconname $w "Replace"
   wm geometry $w +260+398
   $w config -cursor {arrow red white}

   grab set $w

   frame   $w.f1 -bd 1 -relief raised
   message $w.f1.msg -text "Global replace from:" -width 1000
   entry   $w.f1.entry -textvariable string1 -relief sunken -width 55
   pack    $w.f1.msg $w.f1.entry -side left -expand 1 -padx 2m -pady 5m
   $w.f1.entry delete 0 end

   frame   $w.f2 -bd 1 -relief raised
   message $w.f2.msg -text "Global replace to:  " -width 1000
   entry   $w.f2.entry -textvariable string2 -relief sunken -width 55
   pack    $w.f2.msg $w.f2.entry -side left -expand 1 -padx 2m -pady 5m
   $w.f2.entry delete 0 end

   frame   $w.f4 -bd 1 -relief raised
   button  $w.f4.save -text "Save" -command {
      set ok 1
      set string1 [string trim $string1]
      set string2 [string trim $string2]
      if {$string1==""} {
	 Dialog .d 290 458 {PADE Warning} \
	    {The 'Global replace from:' string is blank} error 0 {OK}
         set ok 0
      }      
      set blank1 [string first " " $string1]
      set blank2 [string first " " $string2]
      if {$blank1!=-1 || $blank2!=-1} { 
	 Dialog .d 290 458 {PADE Warning} \
	    {One of the 'Global replace' strings has a blank in it} error 0 {OK}
         set ok 0
      }
      if {$ok} {     
	 set entry1 $string1
	 set entry2 $string2
	 destroy .rep
      }
   }
   button  $w.f4.cancel -text "Cancel" -command {
      set entry1 "CANCEL"
      destroy .rep
   }
   pack $w.f4.save $w.f4.cancel \
     -side left -expand 1 -padx 3m -pady 4m -ipadx 2m -ipady 1m
    

   pack  $w.f1 $w.f2 -anchor w -fill x
   pack  $w.f4 -fill x
   focus $w.f1.entry

   bind $w.f1.entry <Return> {
      focus .rep.f2.entry
   }
   bind $w.f1.entry <Tab> {
      focus .rep.f2.entry
   }

   bind $w.f2.entry <Return> {
   }
   bind $w.f2.entry <Tab> {
   }

   tkwait window $w
}
