/* version 1.0 Feb 16, 1995 */
#include "pvm3.h"

#include "jlib.h"

#define DEBUG 0
#define WILDCARD -1
#define OPENFILENAME 4
#define ALLDONE 5
#define FILECONTENTS 6
#define EXECOMMAND 7
#define RESCOMMAND 8
#define CLOSINGDOWN 9
char EoMes[] = "end of message";
#define MAXCHARS 2048

main(){
int found;
int stat;
int n = {MAXCHARS};
int mytid;
int bufid;
int msgtag;
int info;
int tid;
int bsize;
char file1[MAXCHARS];
char file2[MAXCHARS];
int ParentTid;
int size;
char ecommand[MAXCHARS];
char machine1[MAXCHARS];
char buf[MAXCHARS];
char dir[MAXCHARS];
char tdir[MAXCHARS];
	
FILE *fp;
FILE *ptr;

int i,i1,i2;
int dirsize;
int tdirsize;
char *cs;
char *cs2;
int lstart,lstop;

/* enroll in pvm */
mytid = pvm_mytid();
info = pvm_setopt(3,2); /* set error messages ON; die if not proper responses */
if(info == PvmBadParam)circuit_breaker("invalid set value to pvm_setopt");

ParentTid = pvm_parent();
if((ptr = popen("cd; pwd","r")) != NULL)
  if(fgets(dir,MAXCHARS,ptr)== NULL)circuit_breaker("pipe error\n");
pclose(ptr);
i = 0; 
while(dir[i] != '\0')i++; dirsize = i-1; /* there is a newline before /0 */
dirsize = strlen(dir);
i = dirsize-1;
found = 0;
do{ if(dir[i] == '/')
      found = 1;
    else
      i--;
  }while( (found == 0) && (i > 0));
if(found == 1)
  {dirsize = i; dir[dirsize] = '\0';}
else
  circuit_breaker("Top level directory has an unexpected format; see Judy");



if(mytid < 0)circuit_breaker("spawned tid < 0");
if(ParentTid == PvmNoParent)circuit_breaker("PvmNoParent");

#if DEBUG == 1
printf("hi from process %d\n",mytid);
printf("The current working directory is %s. It has %d characters\n",dir,dirsize); 
#endif

do {
 bufid = pvm_recv(WILDCARD,WILDCARD);
 info = pvm_bufinfo(bufid, &bsize, &msgtag, &tid);

 if(bufid < 0)circuit_breaker("receive buffer bad");
 if(info < 0)circuit_breaker("pvm_bufinfo routine not working");
 if(tid != ParentTid)circuit_breaker("tid != parent tid");

#if DEBUG == 1
 printf("msgtag = %d, from tid = %d, mytid = %d\n",msgtag,tid,mytid);
#endif

 if(msgtag != ALLDONE){

   switch(msgtag) {

   case OPENFILENAME:
     info = pvm_upkstr(file1);
     if(info < 0)circuit_breaker("pvm_upkstr routine not working");

#if DEBUG == 1
     printf("the file to be opened is %s, mytid = %d \n",file1,mytid);
#endif

     if(file1[0] == '~'){ /* build filename */
      for(i=0;i<dirsize;i++)file2[i] = dir[i];
      file2[dirsize] = '/';
      file2[dirsize+1] = '\0';

#if DEBUG == 1
      printf("The partially constructed filename is %s\n",file2);
#endif

      i=1; while(file1[i] != '\0'){
              file2[i+dirsize] = file1[i];i++;}
      file2[i+dirsize] = '\0';

#if DEBUG == 1
       printf("The constructed filename is %s\n",file2);
#endif

       for(i1=0;i1<=i+dirsize;i1++)file1[i1] = file2[i1];
                         } /* done building filename */
     if((fp = fopen(file1,"w")) == NULL)circuit_breaker("can't open file"); 
   break;


   case FILECONTENTS:
#if DEBUG == 1
     printf("file buffer size = %d, mytid = %d \n",bsize,mytid);
#endif
     cs = (char *)malloc(bsize);
     cs2 = cs;
     info = pvm_upkint(&size,1,1); 
     if(info < 0)circuit_breaker("pvm_upkint routine not working");
     info = pvm_upkstr(cs); 
     if(info < 0)circuit_breaker("pvm_upkstr routine not working");
     i1 = 0;
     while(i1 < size){ i2 = *cs2; putc(i2,fp); cs2++; i1++;}
     fclose(fp); 
     fflush(stdout);
     free(cs);
   break;
     

   case EXECOMMAND:
     info = pvm_upkstr(ecommand); 
     if(info < 0)circuit_breaker("pvm_upkstr routine not working");
#if DEBUG == 1
     printf("ecommand = %s,mytid = %d \n",ecommand,mytid);
#endif
     bufid = pvm_initsend(PvmDataDefault);
     if(bufid < 0)circuit_breaker("can't allocate memory to buffer"); 
     info = pvm_pkstr(ecommand);
     /* execute command and pipe output back to this routine; then send to 
        parent for display of results. */

     i = 1;
     while(ecommand[i] == ' ')i++;
     sscanf(&ecommand[1],"%s",machine1);
     i2 = strlen(machine1);
     i += i2;
     i++;
     while(ecommand[i] == ' ')i++;
     lstart = i;
     lstop = i;
     while((ecommand[lstop] != '\0') && (ecommand[lstop] != '+'))lstop++;
     if(ecommand[lstop] == '+')
         {ecommand[lstop] = '2'; 
          ecommand[lstop+1] = '>'; 
          ecommand[lstop+2] = '&'; 
          ecommand[lstop+3] = '1'; 
          ecommand[lstop+4] = '\0'; }
#if DEBUG == 1
     printf("&ecommand[lstart] = %s,mytid = %d \n",ecommand,mytid);
#endif
     if( (ptr = popen(&ecommand[lstart],"r")) == NULL)
        circuit_breaker("can't open pipe");
     while( fgets(buf,n,ptr) != NULL){
#if DEBUG == 1
        printf("command results = %s %d \n",buf,mytid);
#endif
        info = pvm_pkstr(buf);
        if(info < 0)circuit_breaker("pvm_pkstr routine not working"); }
     fflush(stdout);
     if( (stat = pclose(ptr)) == -1)circuit_breaker("ACK!! can't close pipe");
     info = pvm_pkstr(EoMes);
     if(info < 0)circuit_breaker("pvm_pkstr routine not working");
     info = pvm_send(ParentTid,RESCOMMAND);
     if(info < 0)circuit_breaker("pvm_send routine not working"); 
   break;  

   default:
#if DEBUG == 1
     printf("bad msgtag %d\n",msgtag);
#endif
     circuit_breaker("msgtag unknown");
   break;

  } /* end switch */

  }
else { /* msgtag == ALLDONE; so let parent know i am closing down */
   bufid = pvm_initsend(PvmDataDefault);
   info = pvm_pkint(&mytid,1,1);
   info = pvm_send(ParentTid,CLOSINGDOWN);
   if(info < 0)circuit_breaker("can't close down"); 
#if DEBUG == 1
   printf("sending all done from %d\n",mytid);
#endif
     }
}while (msgtag != ALLDONE);



/* program finished *** exit PVM *** then exit program */
if(pvm_exit() < 0)circuit_breaker("pvm_exit() status error ");
exit(0);
}



