/* version 1.0 Feb 16, 1995 */
/* program: pvmmake.c

   program description:
   This program broadcasts files and commands to machines in the virtual 
   machine by sending these to targets.c. These functions are specified
   in a configuration file whose default is pvmmake.config. The user can
   specify another configuration file by running it as 'pvmmake -f filename'.
   The output of commands (usually compiles) is returned to this program and 
   results are printed out.

   programmers:
     Judith E. Devaney
     Mark Edwards

   date:  June 17, 1994

   change log:
     date  |     problem
     --------------------
           |
           |
           |
     --------------------
*/



#include "pvm3.h"


#include "jlib.h"

int getline(line, max, iop)
char *line;
int max;
FILE *iop;
{
 if(fgets(line,max,iop) == NULL)
   return 0;
 else
   return strlen(line);
}



#define DEBUG 0
#define MAXHOSTS 1024
 
/* defined message tags */

/* for wildcard messages: tags and tids */
#define WILDCARD -1

/* for notify */
#define TASK_EXITED 1
#define HOST_ADDED 2
#define HOST_DELETED 3
#define OPENFILENAME 4
#define ALLDONE 5
#define FILECONTENTS 6
#define EXECOMMAND 7
#define RESCOMMAND 8
#define CLOSINGDOWN 9


#define LINESIZE 1000
#define MAXCHARS 2048
char line[LINESIZE];
char comline[] = "-f";
char cline[LINESIZE];
char filename1[MAXCHARS];
char filename2[MAXCHARS];
char filename3[MAXCHARS];
char machine1[MAXCHARS];
char machines[MAXHOSTS][MAXCHARS];
char files[MAXHOSTS][MAXCHARS];
char command[LINESIZE+3];
FILE *fp;
FILE *fp1;
FILE *fpc;
int fd;    /* for reading files with read */
char EoMes[] = "end of message";

main(argc, argv)
int argc;
char *argv[];
{
    int ProcClose;
    int lstart;
    int lstop;
    int flines;
    int fwords;
    int fchar;

    int slen;
    int stat;                    /* for pipe open status */
    FILE *ptr;                   /* for opening pipe in program */
    char buf[LINESIZE];          /* buffer for pipe */
    char dir[MAXCHARS];          /* buffer for directory */
    char tdir[MAXCHARS];         /* buffer for top level directory */
    char wc[MAXCHARS];           /* word count command */

    int lsize;
    int NumChar;
    int info;                    /* status code */
    int nhost;                   /* number of hosts in virtual machine */
    int narch;                   /* number of different data formats in 
                                   virtual machine */
    struct pvmhostinfo *hostp;   /* info on hosts */
    struct pvmhostinfo *hostn;   /* info on hosts */
    int nhostn;                  /* number of hosts in virtual machine */
    int narchn;                  /* number of different data formats in  */
    struct pvmhostinfo *hosti;   /* info on hosts */
    int numt;                    /* number of tasks */
                                
    int mytid;                   /* my task id */
    int tids[MAXHOSTS];          /* all tids */
    int atids[MAXHOSTS];         /* all tids */
    int dtids[MAXHOSTS];         /* all tids */
    int stids[MAXHOSTS];         /* spawned tids */
    int btids[MAXHOSTS];         /* tids to be broadcast to */
    int blist[MAXHOSTS];         /* list of hosts to broadcast to */
    int ntask;
    int bufid;
    int bytes;
    int msgtag;
    int source;
    int ahost;                  /* number of hosts added virtual machine */
    int found;
    int num_to_broadcast;

    char *cs;
    char *cs1;
    char *cst;

    int i,i1,i2,i3;
    int dirsize;
    int tdirsize;
    int done;
 
    /* enroll in pvm */
    mytid = pvm_mytid();

    /* turn on error reporting */
    if(mytid < 0)circuit_breaker("pvmd not responding on call to pvm_mytid()");
    info = pvm_setopt(3,2); /* set error message flags on */
    if(info == PvmBadParam)circuit_breaker("invalid set value to pvm_setopt");



    if(argc == 1){
      if( (fp = fopen("pvmmake.config","r")) == NULL)circuit_breaker("can't open configuration file");}
    else {
      if(strcmp(comline,argv[1]) != 0)circuit_breaker("Usage: -f filename"); 
      printf("\nReading in configuration file: %s\n", argv[2]);
      if((fp = fopen(argv[2],"r")) == NULL)circuit_breaker("can't open configuration file");
       }



    if((ptr = popen("pwd","r")) != NULL)
      if(fgets(dir,MAXCHARS,ptr)== NULL)circuit_breaker("pipe error\n");
    pclose(ptr);

    if((ptr = popen("cd; pwd","r")) != NULL)
      if(fgets(tdir,MAXCHARS,ptr)== NULL)circuit_breaker("pipe error\n");
    pclose(ptr);


     dirsize = strlen(dir);
     if(dir[dirsize-1] == 0xa){dir[dirsize-1] = '\0'; dirsize--;}

     tdirsize = strlen(tdir);
     if(tdir[tdirsize-1] == 0xa){tdir[tdirsize-1] = '\0'; tdirsize--;}
     i = tdirsize-1; found = 0;
     do{ if(tdir[i] == '/')
         found = 1;
         else
           i--; 
        }while( (found == 0) && (i > 0));
     if(found == 1)
       {tdirsize = i; tdir[tdirsize] = '\0';}
     else circuit_breaker("Top level directory has an unexpected format; see Judy");

     for(i=0;i<dirsize;i++) filename3[i] = dir[i]; 

#if DEBUG == 1
    printf("The current working directory is %s. It has %d characters\n",dir,dirsize); 
    printf("The top level directory is %s. It has %d characters\n",tdir,tdirsize); 
#endif

    /* get and print virtual machine configuration */
    printf("\nYour virtual machine configuration is:\n");
    if(pvm_config(&nhost,&narch, &hostp) < 0)
                 circuit_breaker("pvm_config() status error");
    hosti = hostp; /* get state */
    for(i=0;i<nhost;i++){    
      dtids[i] = hosti->hi_tid;
      printf("%d %s %s %d\n",hosti->hi_tid,hosti->hi_name, hosti->hi_arch,hosti->hi_speed);
      hosti++;}



    /* start up one process for each machine in virtual machine */
    printf("\nSpawning one process on each machine:\n");
    hosti = hostp; /* get state */
    for(i=0;i<nhost;i++){ 
      numt = pvm_spawn("targets",NULL,1,hosti->hi_name,1,&stids[i]);
      if(numt == 1)printf("spawned 1 process on %s with tid %d\n",hosti->hi_name,stids[i]);
      if(numt != 1)circuit_breaker("can't spawn task");
      hosti++;
                        }  /* targets are now in same order as in hostp */
    fflush(stdout);


    wc[0] = 'w';
    wc[1] = 'c';
    wc[2] = ' ';

    /* skip junk */
    i = 0;
    while( ((lsize = getline(line,LINESIZE,fp)) > 0) && ((line[0] == '#') || (line[0] == ' ')|| (line[0] == '\n')) )i++;
if(lsize > 0){ /* make sure there is more than junk in the file */
do{

 /* check if this is a command */
 if(line[0] != '@'){
    /* get filename to be read and broadcast */
    sscanf(line,"%s",filename1);    
    printf("\n\nFILE BROADCAST:\n");
    printf("The file to be broadcast is %s\n",filename1);
    if(filename1[0] == '~'){
      for(i=0;i<tdirsize;i++)filename3[i] = tdir[i];
      filename3[tdirsize] = '/';
      i=1; while(filename1[i] != '\0'){
              filename3[i+tdirsize] = filename1[i];i++;}
      filename3[i+tdirsize] = '\0';
      printf("This file is %s\n",filename3); 
      for(i=0;i<MAXCHARS;i++)filename1[i] = filename3[i];
                            }

    /* get machines and filenames to broadcast file into */
    i = 0;
    while((fgets(line,LINESIZE,fp) != NULL)&&(line[0] != ' ')&&(line[0] != '\n')&&(line[0] != '#')){
       sscanf(line,"%s %s",&machines[i][0],&files[i][0]); 
      /* printf("machine, file = %s %s\n",&machines[i][0],&files[i][0]); */
       hosti = hostp; /* get state */
       blist[i] = -1; /* initialize */
       i1 = 0;
       found = FALSE;
       while((i1 < nhost) && (found == FALSE)){ 
         if(strcmp(&machines[i][0],hosti->hi_name) == 0){ blist[i] = i1;
                                                          btids[i] = stids[i1];
                                                          found = TRUE;}
         hosti++; i1++;
                        } /* host to be broadcast to found  */
       if(found == FALSE)circuit_breaker("can't find host");
       i++;
       }


num_to_broadcast = i;
printf("...Broadcast to %d machines: ",num_to_broadcast);
for(i=0;i<num_to_broadcast;i++)printf("%s ",&machines[i][0]);
printf("\n");


/* broadcast filenames */
for(i=0;i<num_to_broadcast;i++){
    printf("broadcasting to tid %d (%s)\n",btids[i],&machines[i][0]);
    if((bufid = pvm_initsend(PvmDataDefault)) < 0)circuit_breaker("can't allocate memory to buffer - malloc failed");
   printf("...file to be opened on %s is %s \n",&machines[i][0],&files[i][0]);
  if(pvm_pkstr(&files[i][0]) < 0 )circuit_breaker("error packing filenames to be broadcast");
  if(pvm_send(btids[i],OPENFILENAME) < 0)circuit_breaker("error sending filename"); 
}

/* read file to be broadcast and convert to string for packing */
/* get file size */
slen = strlen(filename1);
for(i=0;i<slen;i++)wc[i+3] = filename1[i];
  wc[slen+3] = '\0';

if((ptr = popen(wc,"r")) != NULL)if(fgets(buf,LINESIZE,ptr)== NULL)circuit_breaker("cant get file size with wc");
pclose(ptr);

sscanf(buf,"%d %d %d %s",&flines,&fwords,&fchar,filename2);
if( (i1 = strcmp(filename1,filename2)) != 0)circuit_breaker("filenames NOT equal\n");

 
  cs1 = (char *)malloc(fchar + 1); /* convert to string for packing */
  fd = open(filename1, O_RDONLY, 0);
  i = read(fd,cs1,fchar); /* read whole file in one call */
  close(fd);
 
  if(i != fchar)circuit_breaker("Whole file not read");
  cs1[fchar] = '\0';

if((bufid = pvm_initsend(PvmDataDefault)) < 0)circuit_breaker("can't allocate memory to buffer - malloc failed");
if( (info = pvm_pkint(&fchar,1,1)) < 0)circuit_breaker("int packing failed");
if( (info = pvm_pkstr(cs1)) < 0)circuit_breaker("string packing failed");
                                

 if((info = pvm_mcast(btids,num_to_broadcast,FILECONTENTS)) < 0)circuit_breaker("can't bcast file");
 free(cs1);
/* receive acknowledge and error info */
     

    /* skip junk */
    i = 0;
    while( ((lsize = getline(line,LINESIZE,fp)) > 0) && ((line[0] == '#') || (line[0] == ' ')|| (line[0] == '\n')) )i++;
}
else /* it is a command line */
{

i = 1;
while(line[i] == ' ')i++;
sscanf(&line[1],"%s",machine1);
 i2 = strlen(machine1);
i += i2;
i++;
while(line[i] == ' ')i++;
lstart = i;
lstop = i;
while(line[lstop] != '\0')lstop++;

if((bufid = pvm_initsend(PvmDataDefault)) < 0)circuit_breaker("can't allocate memory to buffer - malloc failed");
info = pvm_pkstr(line); /* send whole command line so can echo it back */
if(info != 0)circuit_breaker("can't pack string for command");

/* find host */
i1 = 0;
found = FALSE;
hosti = hostp; /* get state */
while((i1 < nhost) && (found == FALSE)){ 
  if(strcmp(machine1,hosti->hi_name) == 0){ i3 = i1;
                                            found = TRUE;}
  hosti++; i1++;
                        } /* host to be broadcast to found  */
if(found == FALSE)circuit_breaker("can't find host for command");

info = pvm_send(stids[i3] ,EXECOMMAND);
if(info != 0)circuit_breaker("can't send execute command");

/* skip junk */
i = 0;
while( ((lsize = getline(line,LINESIZE,fp)) > 0) && ((line[0] == '#') || (line[0] == ' ')|| (line[0] == '\n')) )i++;

}
} while(lsize > 0);
} /* end only junk in file test */

fclose(fp);



/* tell everyone to start shutting down */

    if((bufid = pvm_initsend(PvmDataDefault)) < 0)circuit_breaker("can't allocate memory to buffer - malloc failed");
    i = 1024;
  if(pvm_pkint(&i,1,1)< 0)circuit_breaker("error packing alldone flag to be broadcast");
   info = pvm_mcast(stids,nhost,ALLDONE);


/* read all returned messages */
printf("\n\n");
ProcClose = 0;
do{

bufid = pvm_recv(WILDCARD,WILDCARD);
info = pvm_bufinfo(bufid,&bytes,&msgtag,&source);
if(msgtag == CLOSINGDOWN){
  ProcClose++;
  info = pvm_upkint(&i1,1,1);
#if DEBUG == 1
  printf("tid %d closing down\n",i1); 
#endif
}
else{
printf("\n\nCOMMAND RESULTS:\n");
do{
info = pvm_upkstr(line);
if(strcmp(EoMes,line) != 0) printf("%s ",line);
}while(strcmp(EoMes,line) != 0);
}
}while(ProcClose < nhost); /* done when all spawned tasks are done */

printf("\n\n\n\n ********** ALL PROCESSES HAVE EXITED **********. \n");

    /* Program Finished ***  exit PVM ***  then exit program */
    if(pvm_exit() < 0)circuit_breaker("pvm_exit() status error");
    exit(0);
}
