/* timer.h -- timer-related support */

/*
 *	$Id: timer.h,v 1.1 1995/01/27 04:44:50 buhr Exp $
 */

#ifndef INC_TIMER_H
#define INC_TIMER_H

#include <time.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <protocols/routed.h>

#define TM_TIMEOUT		180	/* timeout routes */
#define TM_GARBCOLL		120	/* garbage collect after timeout */

#define	TM_NOW_FUZZ		2	/* fuzz to catch "soon" events */

time_t tm_findnext( void );
void tm_settimeout( int route );
void tm_setgarbcoll( int route );
void tm_killtimer( int route );
time_t tm_expire( time_t now );

#endif INC_TIMER_H
