#
# $Source: /user/nlfm/Working/Zircon/Development/lib/RCS/errors.tcl,v $
# $Date: 1994/12/08 09:43:13 $
# $Revision: 1.15.1.7 $
#
proc irc401 {net prefix param pargs} {
    if [regexp -nocase {^zirconbot$} [set chan [lindex $pargs 1]]] {
	return
    }
    if {[set this [Message :: find $chan]] != {nil}} {
	$this addText @ERROR "*** $chan is not on IRC"
    } {
	$net display @ERROR "*** $param - $chan"
    }
}

proc irc404 {net prefix param pargs} {
    set this [Channel :: find [set chan [lindex $pargs 1]]]
    if {$this != {nil}} {
	$this addText @ERROR "*** $param"
    } {
	$net display @ERROR "*** Cannot send to channel ${chan}"
    }
}

proc irc406 {net prefix param pargs} {
    global whois
    set whois(err) [lindex $pargs 1]
}

proc resetNick {} {
    global nickname
    entrySet .ctl0.oFrm.nSFrm.nickname.entry "$nickname"
}

proc irc432 {net prefix param pargs} {
    resetNick
    mkInfoBox ERROR .@nicker {Nickname Error} "[lindex $pargs 1] : $param" \
      {OK {}}
}

proc irc433 {net prefix param pargs} {
    global startup
    resetNick
    mkInfoBox [expr {$startup ? {SERROR} : {ERROR}}] .@nicker \
      {Nickname Error} "[lindex $pargs 1] : $param" {OK {}}
}

proc irc442 {net prefix param pargs} {
    set ch [Channel :: find [lindex $pargs 1]]
    if {[$ch window] != {}} {
	$ch delete
    } {
	mkInfoBox ERROR .@chaner {Channel Error} \
	  "[$ch name] $param [lindex $pargs 2]" {OK {}}
    }
}

proc irc443 {net prefix param pargs} {
    mkInfoBox ERROR .@inver {Invite Error} \
      "[lindex $pargs 1] $param [lindex $pargs 2]" {OK {}}
}

proc irc471 {net prefix param pargs} {
    set chn [Channel :: find [set chan [lindex $pargs 1]]]
    mkDialog {} .@full {Channel Full} "Channel ${chan} is full!" \
      {} {OK {}} "{Try Again} {$chn sendJoin}"
}

proc irc473 {net prefix param pargs} {
    set ch [Channel :: find [lindex $pargs 1]]
    if {[$ch window] != {}} {
	$ch addText @ERROR "*** \007Channel is invitation only!"
    } {
	mkInfoBox ERROR .@invonly {Invitation Only} \
	  "Channel [lindex $pargs 1] is invitation only!" {OK {}}
    }
}

proc irc474 {net prefix param pargs} {
    set ch [Channel :: find [lindex $pargs 1]]
    if {[$ch window] != {}} {
	$ch addText @ERROR "*** \007You are banned from this channel!"
    } {
	mkInfoBox ERROR .@banned Banned \
	  "You are banned from channel [lindex $pargs 1]!" {OK {}}
    }
}

proc irc475 {net prefix param pargs} {
    set chn [Channel :: find [set chan [lindex $pargs 1]]]
    if [string match {} [$chn key]] {
	mkEntryBox .@key Key "Enter key for channel ${chan}:" \
	  {{Key {}}} "Join {$chn sendJoin}" {Cancel {}}
    } {
	mkDialog {} .@key "Bad Key" \
	  "Bad key for channel ${chan}!" [list [list Key [$chn key]]] \
	  "{Try Again} {$chn sendJoin}" {Cancel {}}
    }
}


