#
# $Source: /user/nlfm/Working/Zircon/Development/lib/RCS/Info.tcl,v $
# $Date: 1995/05/02 09:17:34 $
# $Revision: 1.15.1.6 $
#
#
# Build a Zircon Information Window.
#
proc Info {name args} {
    if {$name == {::}} {
	set op [lindex $args 0]
	return [eval Info_$op [lrange $args 1 end] ]
    }
    global Icon BF Fg Bg Ft Bl OType popInfo Name defChan zircon tk_version
    set w .$name
    set OType($name) Info
    set Name($w) $name
    $name configure -hpos 0 -hbuff {} -open $popInfo \
      -close [$defChan close] -jump 1 -quiet 0 -draw 0 \
      -msg [$defChan msg] \
      -actions 0 -patterns {} -logfile {} -history [$defChan history] \
      -closetime [$defChan closetime] -log {} -menu 0 -join 0 \
      -ops {} -keep 1 -monitor 0
    toplevel $w -relief raised -borderwidth 2 -class Zircon
    wm title $w {Zircon Information Window}
    wm iconname $w [set Icon($name) {Zircon Info}]
    wm minsize $w 10 1
    wm protocol $w WM_DELETE_WINDOW quitZircon

    set f [frame $w.cmdLine]
    scrollbar $f.cscroller -orient horizontal -command "$f.commandLine view"
    if [string match 4* $tk_version] {
	emacsEntry $f.commandLine -xscrollcommand "$f.cscroller set"
    } {
	emacsEntry $f.commandLine -scrollcommand "$f.cscroller set"
    }
    button $f.clear -text Clear -command "$name clear" -width 5
    pack $f.clear -side right 
    pack $f.cscroller -side bottom -expand 1 -fill x
    pack $f.commandLine -side top -expand 1 -fill x
    if $zircon(command) { pack $f -fill x -side bottom}
    doInfoBindings $f.commandLine $name
    bind $f.commandLine <Return> "$name doCmd %W"
    set fr [frame $w.cFrm]
    frame $fr.cFrm -relief raised
    set oft $fr.info
    scrollbar $fr.vscroller -command "doScroll $oft"
    text $oft -height 10 -width 80 \
      -yscrollcommand "setScroll $oft $fr.vscroller" 
    rebind $oft
    bind $oft <Configure> {%W yview -pickplace end ; notIdle %W}
    bind $fr <Visibility> {notIdle %W}
    pack $fr.vscroller -side right -fill y -in $fr.cFrm
    pack $oft -side left -expand 1 -fill both -in $fr.cFrm
    pack $fr.cFrm -expand 1 -fill both
    pack $w.cFrm -expand 1 -fill both
    tkwait visibility $w
    set BF($name) [getOValue $oft font boldFont Font]
    set Fg($name) [getOValue $oft foreground foreground Foreground]
    set Bg($name) [getOValue $oft background background Background]
    set Ft($name) [getOValue $oft font font Font]
    set Bl($name) [option get $oft bell Bell]
    $name configure -window $w
    return $name
}
#
proc info_clear {this} {
   [$this window].cFrm.info delete 1.0 end
   update
}
#
proc info_doCmd {this w} {
    global zircon sock monitorOut
    if $zircon(raw) {
	if {$sock != {}} {
	    set line [$w get]
	    $this addToHist $line	    
	    $this addText {} ":>$line"
	    if {$monitorOut} { puts stdout >$line }
	    if [catch {dp_send $sock "$line\r\n"}] { closeIRC $sock }
	    $w delete 0 end
	}
    } {
	doMisc2 $this $w
    }
}
#
proc info0 {op args} {
    global Cwindow
    switch $op {
    lname -
    name { return info0 }
    crypt { return {} }
    text { return [info0 window].cFrm.info }
    command {
	    if [lindex $args 0] {
		pack [info0 window].cmdLine
	    } {
		pack [info0 window].cmdLine -forget
	    }
	}
    clear { info_clear info0 }
    doCmd {  eval info_doCmd info0 $args }
    window { return $Cwindow(info0) }
    default { eval channel_call info0 $op $args }
    }
}
