/*

Copyright 1993, 1994, Cornell University

Cornell hereby grants permission to use, copy, modify, and distribute this program for any purpose 
and without fee, provided that these copyright and permission notices appear on all copies and 
supporting documentation, the name of Cornell not be used in advertising or publicity pertaining 
to distribution of the program without specific prior permission, notice be given in supporting 
documentation that copying and distribution is by permission of Cornell.  CORNELL MAKES NO 
REPRESENTATIONS OR WARRANTEES, EXPRESS OR IMPLIED.  By way of example, but not limitation, 
CORNELL MAKES NO REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR 
PURPOSE OR THAT THE USE OF THIS SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, 
TRADEMARKS, OR OTHER RIGHTS.  Cornell shall not be held liable for any liability with respect to 
any claim by the user or any other party arising from use of the program.

This material is partially based on work sponsored by the National Science Foundation under Cooperative 
Agreement No. NCR-9318337.  The government has certain rights in this material.

*/



#include <stdio.h>
#include <varargs.h>
#include <signal.h>
#include <errno.h>
#include <malloc.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/time.h>

#ifndef LINUX
#include <sys/socketvar.h>
#include <net/route.h>
#endif

#include <net/if.h>
#include <netinet/in.h>

#include "reflect.h"
#include "refmon.h"
#include "globals.h"

short get_client_id()
{
    client *ctmp;
    short  client_id,id_not_set;

    client_id = 1;
    id_not_set = 1;

    /* find the next free client id  */

    while (id_not_set)
    {
       ctmp = chead;
       while (ctmp != NULL)
       {
         if (ctmp->clnt_id == client_id)
         {
            client_id++;
            break;
         }
         ctmp = ctmp->clnt_nptr;
       }
       if (ctmp == NULL)
         id_not_set = 0;
    }

    return(client_id);
}


client *find_client(caddr) 
    unsigned long caddr;
{
    client *ctmp;

    ctmp = chead;

    while (ctmp != NULL)
    {
      if (ctmp->clnt_addr.addr == caddr)
         return(ctmp);
      ctmp = ctmp->clnt_nptr;
    }
    return(NULL);
}


void hold_down_client(cltptr)
   client *cltptr;
{
    dolog("holding down client %s\n",cltptr->clnt_config.name);
    cltptr->clnt_flags |= HOLD_DOWN;
    cltptr->clnt_hdloop = 0;
}


void delete_client(cltptr)
   client *cltptr;
{
    client *ctmp;
    slist  *stmp,*stmp1;

    dolog("deleting client %s\n",cltptr->clnt_config.name);

    chead = unlink_client(chead,cltptr);

    if ((cltptr->clnt_flags & DELETE) == 0)
    {
       dolog("delete_client: client not found\n");
       exit(-1);
    }

    ctmp = chead;
    while (ctmp != NULL)
    {
       ctmp->clnt_vlist = unlink_slist(ctmp->clnt_vlist,cltptr);
       ctmp->clnt_alist = unlink_slist(ctmp->clnt_alist,cltptr);
       ctmp = ctmp->clnt_nptr;
    }

    stmp = cltptr->clnt_vlist;
    while (stmp != NULL)
    {
       stmp1 = stmp;
       stmp = stmp->snd_nptr;
       free_slist(stmp1);
    }

    stmp = cltptr->clnt_alist;
    while (stmp != NULL)
    {
       stmp1 = stmp;
       stmp = stmp->snd_nptr;
       free_slist(stmp1);
    }

    if (cltptr->clnt_flags & CLIENT)
    {
       client_cnt--;

       if (cltptr->clnt_config.sendMode)
          send_ccnt--; 
       else
          lurker_ccnt--;
    }
    else
    if (cltptr->clnt_flags & BCC_CLIENT)
       bcc_client_cnt--;
    else
    if (cltptr->clnt_flags & BCC_SERVER)
       bcc_client_cnt--;
    else
    if (cltptr->clnt_flags & BCC_ORIGIN)
       bcc_client_cnt--;
    else
    if (cltptr->clnt_flags & REF1_CLIENT)
       ref1_client_cnt--;
    else
    if (cltptr->clnt_flags & REF1_SERVER)
       ref1_server_cnt--;
    else
    if (cltptr->clnt_flags & REF1_ORIGIN)
       ref1_origin_cnt--;
    else
    if (cltptr->clnt_flags & REF2_SERVER)
       ref2_server_cnt--;
    else
    if (cltptr->clnt_flags & REF2_ORIGIN)
       ref2_origin_cnt--;
    else
    if (cltptr->clnt_flags & REF3_SERVER)
       ref3_server_cnt--;
    else
    if (cltptr->clnt_flags & REF3_ORIGIN)
       ref3_origin_cnt--;
    else
    if (cltptr->clnt_flags & (NV_UCLIENT | NV_MCLIENT))
       nv_client_cnt--;
    else
    if (cltptr->clnt_flags & BCC_GCLIENT)
       bcc_gclient_cnt--;
    else
    {
       dolog("delete_client: unknown type\n");
       exit(-1);
    }

    free_client(cltptr);
}


slist *unlink_slist(shead,cltptr)
    slist *shead;
    client *cltptr;
{
    slist *stmp;

    if (shead == NULL)
       return(NULL);
    else
       if (shead->snd_client == cltptr)
       {
          stmp = shead->snd_nptr;
          free_slist(shead);
          return(stmp);
       }

    shead->snd_nptr = unlink_slist(shead->snd_nptr,cltptr);
    return(shead);
}


client *unlink_client(chead,cltptr)
    client *chead,*cltptr;
{
    if (chead == NULL)
       return(NULL);
    else
       if (chead == cltptr)
       {
          cltptr->clnt_flags |= DELETE;
          return(chead->clnt_nptr);
       }

    chead->clnt_nptr = unlink_client(chead->clnt_nptr,cltptr);
    return(chead);
}


void free_client(cltptr)
    client *cltptr;
{
    cltptr->clnt_nptr = clfree;
    clfree = cltptr;
    cfree_cnt++;
}


client *get_client()
{
   client *cltptr;
   struct timeval   tp;
   struct timezone  tzp;


   if (cfree_cnt == 0)
   {
      dolog("No more free clients\n");
      exit(1);
   }

   if (clfree == NULL)
   {
      dolog("Unexpectedly no more free clients\n");
      exit(1);
   }

   cltptr = clfree;
   clfree = clfree->clnt_nptr;
   cfree_cnt--;
   bzero(cltptr,sizeof(client));
   gettimeofday(&tp, &tzp);
   cltptr->clnt_tp.tv_sec = tp.tv_sec;
   cltptr->clnt_tp.tv_usec = tp.tv_usec;
   return(cltptr);
}

void free_slist(sptr)
    slist *sptr;
{
    sptr->snd_nptr = sfree;
    sfree = sptr;
    sfree_cnt++;
}


slist *get_slist()
{
   slist *sptr;

   if (sfree_cnt == 0)
   {
      dolog("No more free slists\n");
      exit(1);
   }

   if (sfree == NULL)
   {
      dolog("Unexpectedly no more free slists\n");
      exit(1);
   }

   sptr = sfree;
   sfree = sfree->snd_nptr;
   sfree_cnt--;
   bzero(sptr,sizeof(slist));
   return(sptr);
}


void remove_some_clients(conf_id)
   int conf_id;
{
   client *cptr,*cptr1;

   cptr = chead;

   while (cptr != NULL)
   {
      cptr1 = cptr->clnt_nptr;
      if ((cptr->clnt_flags & CLIENT) && (cptr->clnt_conf_id != conf_id))
      {
         dolog("client %s is being deleted due to conf-id mis-match\n",cptr->clnt_config.name);
         write_msg(&cptr->clnt_addr,kMessageType1,ci_buf);
         tmp_deny(cptr->clnt_addr.addr,HRATE+5);
         hold_down_client(cptr);
      }
     cptr = cptr1;
   }
}

