/* Copyright (c) 1990 by Carrick Sean Casey. */
/* For copying and distribution information, see the file COPYING. */

/* Modified by Mark Giaquinto for International CB, Copyright (C) 1991 */
/* Slightly modified by Mark Luljak for FLICB */

#include "flicb.h"
#define HISTMAX 10

/* message history routines */

STRLIST *histhead, *histtail;	/* head and tail of history list */

int histnum = 0;		/* current number of history entries */

STRLIST *hp;			/* user current location in history list */


/* add a username to the list */
/* called whenever a user sends a personal message to another */

histput(nick)
char *nick;
{
	char *malloc();
	STRLIST *sp;

	/* hunt for user within list */
	for (sp = histhead; sp; sp = sp->next)
		if (!strcasecmp(nick, sp->str)) {
			/* found user -- put at head of list */
			strunlink(sp, &histhead, &histtail);
			strlinkhead(sp, &histhead, &histtail);
			hp = histhead;
			return;
		}

	/* user wasn't found */
	if (histnum < HISTMAX) {
		/* make a new entry for the user */
		if ((sp = (STRLIST *) malloc (sizeof(STRLIST) + strlen(nick))) == NULL) {
			return;
		}
		strcpy(sp->str, nick);
		strlinkhead(sp, &histhead, &histtail);
		histnum++;
	} else {
		/* history list full, link user to head, remove tail */
		sp = histtail;
		strunlink(sp, &histhead, &histtail);
		free(sp);
		histnum--;
		if ((sp = (STRLIST *)
		 malloc (sizeof(STRLIST) + strlen(nick))) == NULL) {
			return;
		}
		strcpy(sp->str, nick);
		strlinkhead(sp, &histhead, &histtail);
		histnum++;
	}
	hp = histhead;
}

/* return a history entry */
/* repeatedly called, will cycle through history entries */

char *
histget()
{
	STRLIST *p = hp;

	hp = hp->next;
	if (hp == 0)
		hp = histhead;
	return(p->str);
}
	

/* return number of names in current history list */

histcount()
{
	return(histnum);
}

histclear()
{
	STRLIST *tmp, *p = hp;

	while (p) {
		tmp = p->next;
		free(p);
		p = tmp;
	}
	histnum = 0;
	hp = histhead = histtail = 0;
}
