/*
 * tacacs.h - TAC access protocol support
 *
 */

#define	TA_VERSION		0
#define XTA_VERSION		0x80
#define XTA_MINOR_VERSION       0x01	/* This is the largest minor version
					 * that we will support.  We support
					 * all smaller minor versions
					 */
#define XTA_MAJOR_VERSION_MASK  0xf0
#define XTA_MINOR_VERSION_MASK  0x0f

/*
 * global flags in tacacs_extended
 */
#define TACACS_EXTEND		0x01	/* extended tacacs is enabled */
#define TACACS_ASKCONNECT	0x02	/* ask about connection */
#define TACACS_NOTECONNECT	0x04	/* notifiy about connections */
#define TACACS_ASKSLIP		0x08	/* ask about SLIP command */
#define TACACS_NOTESLIP		0x10	/* notify about SLIP command */
#define TACACS_ASKENA		0x20	/* ask about "enable" */
#define TACACS_NOTEENA		0x40	/* notify about enable */
#define TACACS_NOTELOGOUT	0x80	/* notify about logout/disconnect */

/*
 * Operations
 */

#define	TA_QUERY		1
#define	TA_ANSWER		2
#define	TA_CHANGE		3
#define	TA_FOLLOW		4

/*
 * ANSWER responses
 */

#define	TA_A_ACCEPTED	1
#define	TA_A_REJECTED	2

/*
 * Reasons included in ANSWER
 */

#define TA_A_NONE	0
#define	TA_A_EXPIRING	1
#define	TA_A_PASSWORD	2
#define	TA_A_DENIED	3
#define	TA_A_NOROUTE	8	/* Dialup routing not allowed */
#define	TA_A_LOGINREQ	9       /* Login required for requested action */

/*
 * TACACS packet structure and sizes
 */

typedef struct tacacstype_ {
    uchar version;
    uchar type;
    ushort trans;
    uchar namelen;
    uchar pwlen;
} tacacstype;

#define	TACACS_SIZE	6

/*
 * eXtended TACACS
 * Try to keep longwords longword aligned.
 */
typedef struct xtacacstype_ {
    uchar version;		/* version of protocol */
    uchar type;			/* Type of query/response */
    ushort trans;		/* transaction ID */
    /*---------------*/
    uchar namelen;		/* length of name */
    uchar pwlen;		/* length of password */
    uchar response;		/* response code */
    uchar reason;		/* reason for response */
    /*---------------*/
    ulong uuid;			/* user id code assigned. */
    /*---------------*/
    ulong dhost;		/* destination host */
    /*---------------*/
    ushort dport;		/* destination port */
    ushort lport;		/* local line number */
    /*---------------*/
    ulong flags;		/* misc flags */
    /*---------------*/
    ushort accesslist;		/* access list for user */
				/* user name */
				/* password */
} xtacacstype;

#define XTACACSSIZE 26
/*
 * "types"
 */

#define	XTA_LOGIN	1
#define	XTA_ANSWER	2
#define	XTA_CHANGE	3
#define	XTA_FOLLOW	4
#define XTA_CONNECT	5
#define XTA_ENABLE	6
#define XTA_LOGOUT	7
#define XTA_RELOAD	8
#define XTA_SLIPON	9
#define XTA_SLIPOFF	10
#define XTA_SLIPADDR	11
#define XTA_ARAP_AUTH	12
#define XTA_CHAP_AUTH	13
/*
 * ANSWER responses
 */

#define	XTA_A_ACCEPTED	1
#define	XTA_A_REJECTED	2

/*
 * reasons for rejection of request
 */

#define XTA_A_NONE	0
#define	XTA_A_EXPIRING	1
#define	XTA_A_PASSWORD	2
#define	XTA_A_DENIED	3
#define	XTA_A_NOROUTE	8	/* Dialup routing not permitted */
#define	XTA_A_LOGINREQ	9       /* Login required for requested action */

/*
 * The following are reasons for "logout" and "slipoff" xtacacs messages
 */
#define XTA_R_QUIT	4	/* user quit normally */
#define XTA_R_IDLE	5	/* idle timeout */
#define XTA_R_DROP	6	/* carrier dropped */
#define XTA_R_BAD	7	/* too many bad passwords */

/*
 * flags used in response packets
 * NOTE: these codes currently ignored by cisco routers and terminal servers
 */
#define XTA_F_NOENABLE	   1	/* user may not enable */
#define XTA_F_NOENAPASS	   2	/* user may enable without password */
#define XTA_F_NOSLIP	   4	/* user may not run SLIP */
#define XTA_F_SLIPPASS	   8	/* user needs ok to run SLIP */
#define XTA_F_CONNPASS	0x10	/* user needs ok to make connections */
#define XTA_F_ACCESS	0x20	/* use the provided access list number */

/*
 * flags used in request packets
 */
#define XTA_F_ROUTING	0x40	/* user wants to do dialup routing */

/*
 * Positional markers for the supplementary data file
 * Entries in this file should be of the form
 *	username:position_1_value:position_2_value:position_3_value:
 * A colon (`:') is the only recognized separator.
 */
#define XTA_SUP_IPACLIN		1
#define XTA_SUP_IPACLOUT	2
#define XTA_SUP_ARAP_SEC	3
#define XTA_SUP_CHAP_SEC	4

/*
 * ARAP specific info
 */
#define ARAP_CHAL_SIZE		8
#define ARAP_RESP_SIZE		8

/*
 * CHAP specific info
 */
#define MD5_LEN			16


/*
 * Slip acl structure for return data from SLIPON request.
 */
struct xta_slip_acl {
    long        in;
    long        out;
};
