/*
 *
 *	view.h
 *
 *	HNMS User Interface
 *	HNMS 2.0
 *
 *	February 1994
 *
 *	Leslie Schlecht
 *	Computer Sciences Corporation
 *	Numerical Aerodynamic Simulation Systems Division
 *	NASA Ames Research Center
 *
 *	Copyright (c) 1994 Leslie Schlecht
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 1, or (at your option)
 *	any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

typedef	struct viewtype{
	int			class;
	VIEWPANEL		*panel;
	int			announce[NUM_OBJCLASSES];
	char			*objstr[NUM_OBJCLASSES];
	char			*varstr[NUM_OBJCLASSES];
	caddr_t			*varlist[NUM_OBJCLASSES];
	int			interval;
	int			recvonly;
	int			varcnt[NUM_OBJCLASSES];
	int			background;
	char			*name;
	struct viewtype		*next;
	} VIEW;

VIEW*	AllocateView();
void	LoadView();
void	AnnounceObjectToViews();
void	AnnounceObjectToView();
void	AddViewParent();
void	AddObjectToView();
void	Q_AddObjectToView();
void	Q_RemoveViewObject();
void	RemoveViewObject();
void	DestroyView();
void	RemoveView();
void	OpenView();
int	ObjectInViewObjectList();
void	UpdateViewObject();
void	UpdateViewParent();
void	Q_UpdateViewParent();
void	AddViewChild();
void	Q_AddViewChild();
void	Q_AddViewParent();
void	UpdateViewChild();
void	Q_UpdateViewChild();
void	ClearViews();
char*	ViewTitle();
char*	ViewName();
void	MergeViewVariables();
int	ViewRecvonly();
void	SaveViews();
void	GetObjectClass();
void	ConfigureView();
