/*
 *
 *	objectdata.c
 *
 *	HNMS User Interface
 *	HNMS 2.0
 *
 *	February 1994
 *
 *	Leslie Schlecht
 *	Computer Sciences Corporation
 *	Numerical Aerodynamic Simulation Systems Division
 *	NASA Ames Research Center
 *
 *	Copyright (c) 1994 Leslie Schlecht
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 1, or (at your option)
 *	any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include	<stdio.h>
#include	<string.h>
#include	<time.h>

#include	<X11/StringDefs.h>
#include	<X11/Intrinsic.h>
#include	<X11/Shell.h>
#include	<X11/Core.h>
#include	<Xm/Xm.h>
#include	<Xm/Text.h>
#include	<Xm/Form.h>
#include	<Xm/ScrolledW.h>
#include	<Xm/List.h>

#include	"defines.h"
#include	"externs.h"
#include	"viewpanel.h"
#include	"xsupport.h"
#include	"view.h"
#include	"objectdata.h"
#include	"variable.h"

typedef		struct datatext	{
		Widget		*var;
		caddr_t		obj;
		char		*name;
		int		class, count;
		} DT;

static int	datainterval = 60;


/*
 *	Add the object to the data view and load its variables.
 */
void
AddObjectDataObject(view, obj, class, name)
VIEW	*view;
caddr_t	obj;
int	class;
char	*name;
	{
	DT	*d;
	register	i;
	Widget		sw, f;
	caddr_t		*var;

	
	d = (DT*)(view->panel->wa);
	d->obj = obj;
	d->class = class;
	d->name = name;
	d->count = view->varcnt[class];
	XmTextSetString(view->panel->titletext, d->name);
	XtVaSetValues(view->panel->titletext,
		XmNsensitive, False,
		NULL);
	if (!d->count) return;
	d->var = (Widget*)myalloc(NULL, d->count, sizeof(Widget));
	/*
	sw = XtVaCreateManagedWidget("dataview",
		xmScrolledWindowWidgetClass,
		view->panel->viewform,
		XmNscrollingPolicy, XmAUTOMATIC,
		XmNhighlightThickness, 0,
		XmNshadowThickness, 0,
		XmNtopAttachment, XmATTACH_FORM,
		XmNleftAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		NULL);
	*/
	f = XtVaCreateManagedWidget("dataview",
		xmFormWidgetClass,
		view->panel->viewform,
		XmNtopAttachment, XmATTACH_FORM,
		XmNleftAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		NULL);
	var = view->varlist[d->class];
	d->var[0] = XtVaCreateManagedWidget("dataview",
		xmTextWidgetClass,
		f,
		XmNtopAttachment, XmATTACH_FORM,
		XmNleftAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_NONE,
		XmNsensitive, False,
		XmNcursorPositionVisible, False,
		XmNshadowThickness, 0,
		XmNhighlightThickness, 0,
		XmNresizeWidth, True,
		NULL);
	XmTextSetString(d->var[0], VarOde(var[0]));
	for (i=1; i<d->count; i++) {
		d->var[i] = XtVaCreateManagedWidget("dataview",
			xmTextWidgetClass,
			f,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, d->var[i-1],
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_NONE,
			XmNsensitive, False,
			XmNcursorPositionVisible, False,
			XmNshadowThickness, 0,
			XmNhighlightThickness, 0,
			XmNresizeWidth, True,
			NULL);
		XmTextSetString(d->var[i], VarOde(var[i]));
		Q_RequestObjectVariable(obj, view, var[i]);
		}
	XtVaSetValues(d->var[i-1],
		XmNbottomAttachment, XmATTACH_FORM,
		NULL);
	}


/*
 *	Clear the data view work area.
 */
void
ClearObjectData(view)
VIEW	*view;
	{
	DT	*d;
	register	i;
	caddr_t	*var;

	d = (DT*)(view->panel->wa);
	if (!d->count) return;
	var = view->varlist[d->class];
	for (i=0; i<d->count; i++)
		XmTextSetString(d->var[i], VarOde(var[i]));
	d->obj = NULL;
	}


/*
 *	Destroy an object data view.
 */
void
DestroyObjectData(panel)
VIEWPANEL	*panel;
	{
	free(panel->wa);
	}


/*
 *	Create data view.
 */
void
LoadObjectData(view)
VIEW	*view;
	{
	VIEWPANEL	*panel;
	register	i;

	panel = view->panel;
	panel->wa = (caddr_t)myalloc(NULL, 1, sizeof(DT));
	for (i=0; i<NUM_OBJCLASSES; i++) {
		if (view->varcnt[i]) {
			free(view->varlist[i]);
			view->varlist[i] = NULL;
			}
		StrToVariable(view->varstr[i], &(view->varlist[i]),
			view->varcnt[i]);
		view->announce[i] = 1;
		}
	GetHelp(view->panel, 13, 1);
	AddRemoveButton(view, view->panel);
	}


/*
 *	Update the object's variable.
 */
void
UpdateObjectDataObject(view, obj, var, value, tsc)
VIEW		*view;
caddr_t		obj;
caddr_t		var;
caddr_t		value;
unsigned int	tsc;
	{
	DT		*d;
	register	i;
	caddr_t		*viewvar;
	char		buf[BUFSIZ];

	d = (DT*)(view->panel->wa);
	if (!d->count) return;
	viewvar = view->varlist[d->class];
	for (i=0; i<d->count; d++)
		if (viewvar[i] == var)
			break;
	if (i == d->count) return;
	if (IsVarString(var))
		sprintf(buf, "%s  %s  %s", VarOde(var), value, get_time(tsc));
	else
		sprintf(buf, "%s  %d  %s", VarOde(var), (unsigned int)value,
			get_time(tsc));
	XmTextSetString(d->var[i], buf);
	}
