SNMP DEFINITIONS ::= BEGIN

-- Simple Network Management Protocol

-- IMPORTS
--     ObjectName, ObjectSyntax, NetworkAddress, IpAddress, TimeTicks
--	    From RFC1065-SMI;

-- top-level message
    
Message ::=
	SEQUENCE {
		version INTEGER {
			version-1(0)
		},
		community OCTET STRING,
		data PDUs
        }

-- protocol data units

PDUs ::=
	CHOICE {
		get-request GetRequest-PDU,
		get-next-request GetNextRequest-PDU,
		get-response GetResponse-PDU,
		set-request SetRequest-PDU,
		trap Trap-PDU
        }

GetRequest-PDU ::= [0]
	IMPLICIT PDU

GetNextRequest-PDU ::= [1]
	IMPLICIT PDU

GetResponse-PDU ::= [2]
	IMPLICIT PDU

SetRequest-PDU ::= [3]
	IMPLICIT PDU

PDU ::=
	SEQUENCE {
        	request-id INTEGER,
        	error-status INTEGER {
			noError(0),
			tooBig(1),
			noSuchName(2),
			badValue(3),
			readOnly(4),
			genErr(5)
		},
		error-index INTEGER,
		variable-bindings VarBindList
	}

Trap-PDU ::= [4]
	IMPLICIT SEQUENCE {
		enterprise OBJECT IDENTIFIER,
		agent-addr NetworkAddress,
		generic-trap INTEGER {
			coldStart(0),
			warmStart(1),
			linkDown(2),
			linkUp(3),
			authenticationFailure(4),
			egpNeighborLoss(5),
			enterpriseSpecific(6)
		},
		specific-trap INTEGER,
		time-stamp TimeTicks,
		variable-bindings VarBindList
	}

VarBind ::=
	SEQUENCE {
		name ObjectName,
		value ObjectSyntax
        }

VarBindList ::=
	SEQUENCE OF VarBind

-- types from RFC1065-SMI

ObjectName ::=
	OBJECT IDENTIFIER

ObjectSyntax ::=
	ANY

NetworkAddress ::=
	CHOICE {
		internet IpAddress
	}

IpAddress ::= [APPLICATION 0]
	IMPLICIT OCTET STRING (SIZE (4))
    
TimeTicks ::= [APPLICATION 3]
	IMPLICIT INTEGER

END
