/*
  Last updated : Wed Aug  2 16:42:39 1995
  Modified by JSP from code by Charles Hawkins <ceh@eng.cam.ac.uk>,

    J.S.Peatfield@damtp.cam.ac.uk

  Copyright (c) University of Cambridge, 1993,1994,1995
*/

/* Standard headers */
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <linux/if.h>
#include <linux/sockios.h>
#include <net/if_arp.h>
#include <sys/time.h>
#include <unistd.h>
#include <string.h>
#include <getopt.h>
#include <stdlib.h>
#include <errno.h>

/* local headers */
#include "bootp.h"

#define BPCVERSION "BOOTPclient v0.45"

/* These don't seem to be defined in the bootp.h header I have  20/06/94 JSP */
#define TAG_MERIT_DUMP    14
#define TAG_DOMAINNAME    15
#define TAG_SWAP_SERVER   16
#define TAG_ROOTPATH      17
#define TAG_EXTENSIONS    18

/* Back in NET2 (and before?) the ifreq.ifr_hwaddr was a char array,
   but in NET3 it is now a "sockaddr", and we need the data part.

   This detects the difference between the net2 and net3 structures,
   but note that code compiled on net3 will fail on net2, and that the
   net2 code will only work in net3 due to backwards compatability
   code which may disappear at some point.  Recompile bootpc when you
   switch to a kernel newer than 1.1.14 or so.

   The code to work on older kernels will go away soon.  Please use
   newer kernel if you can (I can't test it on the old kernels anymore
   as I don't have any.)  It will go away before the *next* version.

*/
#ifdef OLD_SIOCGIFHWADDR
#define NET3_HWADDR
#define use_hwaddr ifr_hwaddr.sa_data
#else
#define use_hwaddr ifr_hwaddr
#endif


/* Needed for getopt stuff */
extern char *optarg;
extern int optind, opterr, optopt;

/* My forward declarations */
void FatalError();

void ParseCookie(unsigned char *cookie,
		 unsigned char *match,
		 struct in_addr my_addr) ;

void PrintList(char *name,
	       unsigned char *cookie,
	       int pos,
	       int len) ;

void PrintString(char *name,
	       unsigned char *cookie,
	       int pos,
	       int len) ;

void PrintSearch(char *name,
		 unsigned char *cookie,
		 int pos,
		 int len) ;

int in2host(char *address) ;

int pingit(char *address) ;

/* My global variables */
static int verbose = 0 ;   /* verbose mode or not 10/02/94 JSP */
static int debug   = 0 ;   /* debug mode or not 14/02/94 JSP */
static int subnet  = 0 ;   /* if we have seen a subnet TAG yet (sigh) */

int errno ;

int main(int argc,
	 char *argv[])
{
  int sockfd;
  struct sockaddr_in cli_addr, serv_addr;
  struct bootp bppdu;
  struct ifreq ifr;
  fd_set rfds, wfds, xfds;
  struct timeval timeout ;
  long rancopy ;
  struct in_addr temp_addr ;
  int retry_wait, waited;
  int one=1, i, givenhwaddr ;
  struct timeval tp;
  char *device, *bootfile, *server ;
/* See RFC1497, RFC1542  09/02/94   JSP  */
  unsigned char mincookie[] = {99,130,83,99,255} ;

/* defaults unless overridden by command line options 10/02/94  JSP */
  device = "eth0" ;             /* first ethernet card */
  bootfile = "" ;               /* No bootfile by default */
  server = "255.255.255.255" ;  /* i.e broadcast to everyone */
  givenhwaddr = 0 ;             /* i.e. use our real HW address */

/* Setting the default bootfile to "linux" seemed to cause problems for
   the CMU-2.1 bootpd, though I can't tell why, I don't run it here...
   Perhaps it really should default to "vmlinuz" ... 17/06/94  JSP
*/

  while (1) {
    int option_index = 0, option ;
    static struct option long_options[] = {
      {"bootfile", 1, 0, 1},
      {"dev", 1, 0, 2},
      {"verbose", 0, 0, 3},
      {"debug", 0, 0, 4},
      {"server", 1, 0, 5},
      {"hwaddr", 1, 0, 6},
      {"in2host", 1, 0, 10},
      {"ping", 1, 0, 20},
      {"help", 0, 0, 100},
      {0, 0, 0, 0},
    } ;

    option = getopt_long (argc, argv, "", long_options, &option_index);

    if (option == -1)
      break ;

    switch (option) {
    case 1:  /* New bootfile */
      bootfile = optarg ;
      if (strlen(bootfile) > 127) { /* buffer space for 128 only */
	if (verbose)
	  fprintf(stderr, "Bootfile %s too long, truncating\n", bootfile) ;
	bootfile[127] = 0;
      }
      break ;
    case 2:  /* New device */
      device = optarg ;
      if (strlen(device) > IFNAMSIZ-1) {  /* only IFNAMSIZ space in struct */
	if (verbose)
	  fprintf(stderr, "device name %s too long, truncating\n", device) ;
	device[IFNAMSIZ -1] = 0;
      }
      break ;
    case 3:
      verbose = 1 ;
      break ;
    case 4:
      debug = 1 ;
      break ;
    case 5:
      server = optarg ;
      break ;
    case 6:
      /* This MAY be useful for some types of debugging, however all
	 the bootpd programs I have reply to the hardware address
	 given here, thus we never see the replies.  Other bootpds may
	 not so it may be possible to use this to test a bootpd will
	 respond for another HW address.  17/08/94  JSP */
      { int error, count ;
	unsigned int value ;
	char cc ;

	for (i=0; i < IFHWADDRLEN; ++i) {  /* get the MAC address from user */
	  error = sscanf(optarg, "%2x%n%[ :.]%n", &value,&count,&cc,&count) ;
	  ifr.use_hwaddr[i] = value ;
	  if (error <= 0) {   /* Not enough given */
	    if (debug)
	      fprintf(stderr, "Ran out of numbers in hwaddr, ignoring\n") ;
	    break ;
	  }
	  optarg += count ;
	}
	givenhwaddr = 1 ;
      }
      break ;
    case 10:
      /* used for the reverse lookup to hostname */
      return in2host(optarg) ;
      break ;
    case 20:
      /* used as a sanity check on the IP number we get back in case of
	 duplicate addresses */
      return pingit(optarg) ;
      break ;
    case 100:
      fprintf (stderr, "%s is used to find the IP number and other setup\n"
	      "information for a machine\n"
	      "\n", argv[0]) ;
    default:
      fprintf (stderr, "\t%s\n", BPCVERSION) ;
      fprintf (stderr,
	       "Usage: %s\t[--dev device] [--bootfile file] [--verbose]\n"
	       "\t\t\t[--server address] [--hwaddr mac-address]\n"
	       "\t\t[--in2host address]\n"
	       "\t\t[--ping    address]\n"
	       "\t\t[--help]\n", argv[0]) ;
      exit (1) ;
    }
  }

  if (verbose) {
    fprintf (stderr, "\t%s\n\tdevice=%s  bootfile=%s\n\n",
	     BPCVERSION, device, bootfile ) ;
  }

/* zero structure before use */
  memset((char *) &serv_addr, 0, sizeof(serv_addr));

  serv_addr.sin_family = AF_INET;
  serv_addr.sin_addr.s_addr = inet_addr(server) ;
  serv_addr.sin_port = htons(IPPORT_BOOTPS);

  if((sockfd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
    perror("bootpc: socket failed");
    FatalError();
  }
  
  if (setsockopt(sockfd,SOL_SOCKET,SO_BROADCAST,&one,sizeof(one))==-1) {
    perror("bootpc: setsockopt failed");
    FatalError();
  }
  
  memset((char *) &cli_addr, 0, sizeof(cli_addr));
  cli_addr.sin_family = AF_INET;
  cli_addr.sin_addr.s_addr = htonl(INADDR_ANY);
  cli_addr.sin_port = htons(IPPORT_BOOTPC);

  if(bind(sockfd, (struct sockaddr *) &cli_addr, sizeof(cli_addr)) < 0) {
    perror("bootpc: bind failed");
    FatalError();
  }

/* zero bootp packet before we use it */
  memset((char *) &bppdu, 0, sizeof(bppdu)) ;

/* Don't do this if we were given the MAC address to use.  27/09/94  JSP */
  if (givenhwaddr) {
    /* If I'm spoofing my HW address then have the reply broadcast */
    bppdu.bp_flags |= BPFLAG_BROADCAST;
    ifr.ifr_hwaddr.sa_family = ARPHRD_ETHER ;  /* Assuming ETHER if given HW */
  } else {
/* Get the hardware address, and family information */
    memcpy(ifr.ifr_name, device, strlen(device)+1);
    if (ioctl(sockfd, SIOCGIFHWADDR, &ifr) < 0) {
      perror("bootpc: ioctl failed");
      FatalError();
    }
  }

#ifdef NET3_HWADDR
/* Check the network family if in NET3 or later, before NET3 you couldn't
   examine this info (as far as I know.) */

/* set the htype field from the sa.family of the hardware address, if
   this doesn't work for your interface type let me know please. */

  bppdu.bp_htype = ifr.ifr_hwaddr.sa_family;
  bppdu.bp_hlen = IFHWADDRLEN ;  /* All MAC addresses are the same length */
  if (debug)
    fprintf(stderr, "Got family=%d (Ether=%d)\n",
	    bppdu.bp_htype, ARPHRD_ETHER);
#else   /* NET3_HWADDR */
  /* This is wrong but since we can't do better than assume ethernet
     it will have to do.  The real solution is to upgrade to NET3
     (Linux 1.1.14+) code when it works as above.

     THIS CODE IS GOING IN THE NEXT RELEASE AS I CAN't TEST IT ANYMORE
   */
  bppdu.bp_htype = ARPHRD_ETHER ;
  bppdu.bp_hlen  = IFHWADDRLEN ;
#endif  /* NET3_HWADDR */

/* If we have the time seed with it xor the hardware address, otherwise
   use the hardware address 12/02/94 JSP */
  if (gettimeofday(&tp, NULL) == -1)
    rancopy = 0 ;
  else
    rancopy = tp.tv_sec + tp.tv_usec ;

/* Do the XOR */
  for (i=0; i < IFHWADDRLEN ; ++i) {
    ((unsigned char *)&rancopy)[ i % sizeof(rancopy) ] ^=
      ((unsigned char *)(ifr.use_hwaddr))[i] ;
  }
/* and set the seed */
  srand(rancopy) ;

  if(debug) {
    fprintf(stderr, "hardware addr is :") ;
    for (i=0; i < bppdu.bp_hlen ; ++i)
      fprintf (stderr, "%2.2X ", ((unsigned char *)(ifr.use_hwaddr))[i]) ;
    fprintf(stderr, "\n") ;
  }

/* Now fill in the packet. */
  bppdu.bp_op = BOOTREQUEST ;

/* Now with my understanding of the bootp protocol we *should* just
   need to copy the hwaddr over, but it seems that at least ARCNET
   bootb servers are wird in this respect.  So here is a switch in
   case of other weirdness.  JSP */

  switch(bppdu.bp_htype) {
/* ARCNET uses a "fake" ethernet address, with the ARCNET address at
   the wrong end.  At least the Novell bootp server on ARCNET assumes
   this.  Thanks to Tomasz Motylewski <motyl@tichy.ch.uj.edu.pl> for
   reporting this.  */
  case ARPHRD_ARCNET :
    memcpy(bppdu.bp_chaddr+IFHWADDRLEN-1, (char *)(ifr.use_hwaddr), 1) ;
    bppdu.bp_htype=ARPHRD_ETHER;
    bppdu.bp_hlen=IFHWADDRLEN;
    break ;

/* Add other network weirdness here */

/* For sensible networks the rest is normal */
  default :
    memcpy(bppdu.bp_chaddr, (char *)(ifr.use_hwaddr), bppdu.bp_hlen) ;
  }

  bppdu.bp_secs = 0;  /* Must start with zero here, see RFC1542 09/02/94 JSP */

/* Put in the minimal RFC1497 Magic cookie 09/02/94 JSP */
  memcpy(bppdu.bp_vend, mincookie, sizeof(mincookie));

/* Put the user precified bootfile name in place 12/02/94 */
  memcpy(bppdu.bp_file, bootfile, strlen(bootfile)+1);

  retry_wait = 2 ;
  if (verbose)
    fprintf(stderr,"BOOTPclient broadcast...\n");
  while (retry_wait <= 64){
  
/* putf a random value in here, but keep a copy to check later 09/02/94  JSP */
    bppdu.bp_xid = rancopy = rand() ;
    if (verbose) {
      fprintf(stderr,".");
      fflush(stderr);
    }

    if(sendto(sockfd, &bppdu, sizeof(bppdu), 0, 
	      (struct sockaddr *)&serv_addr, sizeof(serv_addr)) < 0) {
      perror("bootpc: sendto");
      FatalError();
    }
    
    FD_SET(sockfd,&rfds);
    FD_ZERO(&wfds);
    FD_ZERO(&xfds);

/* Randomise the delays a little as suggested in RFC1542  09/02/94  JSP */
    timeout.tv_sec = waited = retry_wait + (1+(rand() & (retry_wait-1))) ;
    timeout.tv_usec = 0;
    
    if(select(sockfd+1, &rfds, &wfds, &xfds, &timeout)<0) {
      perror("bootpc: select");
      FatalError();
    }

    if(!FD_ISSET(sockfd, &rfds)) {
      bppdu.bp_secs += waited ;  /* add time of this timeout  09/02/94  JSP */
      retry_wait = retry_wait*2;
    } else{
      if (recvfrom(sockfd, &bppdu, sizeof(bppdu), 0,
		   (struct sockaddr *)NULL, (int *)NULL) < 0){
	perror("bootpc: recvfrom");
	FatalError();
      }
      
/* Check xid is what we asked for  09/02/94  JSP */
      if (bppdu.bp_xid != rancopy) {
	fprintf(stderr, "WARNING bp_xid mismatch\n") ;
	/* Should we quit here, ignore the packet or carry on??? */
      }

      temp_addr.s_addr = bppdu.bp_siaddr.s_addr ;
      printf("SERVER=%s\n", inet_ntoa(temp_addr));

      temp_addr.s_addr = bppdu.bp_yiaddr.s_addr ;
      printf("IPADDR=%s\n", inet_ntoa(temp_addr));

      printf("BOOTFILE=%s\n", bppdu.bp_file );

/* Pass the cookie info, the mincookie to look for and our address to
   the cookie parser.  It needs our address to get the network and
   broadcast bits right if the SUBNET is defined in the cookie.
   10/02/94  JSP */

      ParseCookie((unsigned char *)&bppdu.bp_vend,
		  mincookie, temp_addr) ;

/* No SUBNET TAG in the cookie so we fake guess here, if this is wrong
   then fix your bootp server to tell us the answer rather than
   hacking this code. */

      if (!subnet) {
	struct in_addr network ;
	int type ;
	
	if (verbose)
	  fprintf(stderr, "Guessing network from IP number\n") ;

	type = ntohl(temp_addr.s_addr) ;
	if ((type & 0x80000000) == 0) {
	  /* Class A */
	  network.s_addr = htonl(0xFF000000) ;
	} else if ((type & 0x40000000) == 0) {
	  /* Class B */
	  network.s_addr = htonl(0xFFFF0000) ;
	} else if ((type & 0x20000000) == 0) {
	  /* Class C */
	  network.s_addr = htonl(0xFFFFFF00) ;
	} else { /* GOD KNOWS... other classes are weird */
	  if (verbose)
	    fprintf(stderr, "IP number not Class A,B or C,\n"
		    "setting NETMASK to zero\n") ;
	  network.s_addr = htonl(0x00000000) ;
	}
	temp_addr.s_addr &= network.s_addr ;
	printf("NETWORK=%s\n", inet_ntoa(temp_addr));
	temp_addr.s_addr |= ~network.s_addr ;
	printf("BROADCAST=%s\n", inet_ntoa(temp_addr));
      }

      exit(0);
    }
  }
  fprintf(stderr, "\nNo response from BOOTP server\n");
  FatalError();

  return 0 ;  /* Never reached */
}
    
void FatalError()
{
  if (debug)
    fprintf(stderr, "In FatalError(), errno was %d\n", errno) ;

  fprintf(stderr,
	  " Unable to locate an IP address for this host.\n"
	  "     ***Please report this problem**\n\n"
	  "          [Unable to continue]\n\n");

  if (debug)
    fprintf(stderr, "Will now loop forerver, break out of this to fix\n\n") ;

  while(1) {
    /* your eyes are getting heavy.... */
    sleep(1000) ;
  }
}

/* Parse Magic cookies as specified in RFC1497, well only the bits we
   are actually interested in...  09/02/94 JSP
*/
void ParseCookie(unsigned char *cookie,
		 unsigned char *match,
		 struct in_addr my_addr)
{
  int i=0, len ;
  struct in_addr temp ;

  if (debug) {  /* dump cookie contents in HEX 10/02/94  JSP */
    for (i=0; i<64; i++) {
      if ((i%8) == 0)
	fprintf(stderr, "\n %2.2d :", i) ;
      fprintf(stderr, " 0x%2.2X", cookie[i]) ;
    }
    fprintf(stderr, "\n") ;
  }

/* Must get the same cookie back as we sent  09/02/94  JSP */
  for (i=0; i < 4; ++i) {
    if (cookie[i] != match[i]) {
      if (verbose)
	fprintf(stderr, "RFC1497 Cookie mismatch at offset %d\n", i) ;
      return ;
    }
  }

  if (verbose)
    fprintf(stderr, "found valid RFC1497 cookie, parsing...\n") ;

/* Carry on after the cookie for other data  09/02/94  JSP */
  while (i < 64) {
    if (verbose)
      fprintf(stderr, "cookie position %d is %d\n", i, cookie[i]) ;

    switch (cookie[i]) {  /* The monster switch statement ... */
/* PAD cookie */
    case TAG_PAD :
      i++ ;
      break ;

/* SUBNET we are in */
    case TAG_SUBNET_MASK :
      if (verbose && cookie[i+1] != 4)
	fprintf(stderr, "WARNING len of tag 1 is %d not 4\n", cookie[i+1]) ;
      memcpy((char *)&temp, cookie + i + 2, 4) ;
      printf("NETMASK=%s\n", inet_ntoa(temp)) ;

/* Both values are in network order so this doesn't care about the
   ordering 10/02/94 JSP */
      my_addr.s_addr &=  temp.s_addr ;
      printf("NETWORK=%s\n", inet_ntoa(my_addr)) ;
      my_addr.s_addr |= ~temp.s_addr ;
      printf("BROADCAST=%s\n", inet_ntoa(my_addr)) ;

/* defined so we know later that subnet info has been printed 11/02/94  JSP */
      subnet = 1 ;
      i += 6 ;
      break ;

/* Time of day */
    case TAG_TIME_OFFSET :
      len = cookie[i+1] ;
      printf("TIMEOFFSET=%li\n", ntohl(*(unsigned int *)&cookie[i+2]) ) ;
      i += len + 2 ;
      break ;

/* IP Gateways (routers) */
    case TAG_GATEWAY :
      len = cookie[i+1] ;
      PrintList("GATEWAYS", cookie, i+2, len) ;
      i += len + 2 ;
      break ; 

/* Timeservers (see RFC-868) */
    case TAG_TIME_SERVER :
      len = cookie[i+1] ;
      PrintList("TIMESRVS", cookie, i+2, len) ;
      i += len + 2 ;
      break ; 

/* IEN-116 Nameservers */
    case TAG_NAME_SERVER :
      len = cookie[i+1] ;
      PrintList("IEN116SRVS", cookie, i+2, len) ;
      i += len + 2 ;
      break ; 

/* DNS Nameservers */
    case TAG_DOMAIN_SERVER :
      len = cookie[i+1] ;
      PrintList("DNSSRVS", cookie, i+2, len) ;
      i += len + 2 ;
      break ; 

/* LOGGING servers */
    case TAG_LOG_SERVER :
      len = cookie[i+1] ;
      PrintList("LOGSRVS", cookie, i+2, len) ;
      i += len + 2 ;
      break ; 

/* Quote of day/Cookie servers */
    case TAG_COOKIE_SERVER :
      len = cookie[i+1] ;
      PrintList("QODSRVS", cookie, i+2, len) ;
      i += len + 2 ;
      break ; 

/* LPR servers */
    case TAG_LPR_SERVER :
      len = cookie[i+1] ;
      PrintList("LPRSRVS", cookie, i+2, len) ;
      i += len + 2 ;
      break ; 

/* Impress (Imogen) servers */
    case TAG_IMPRESS_SERVER :
      len = cookie[i+1] ;
      PrintList("IMPRESSSRVS", cookie, i+2, len) ;
      i += len + 2 ;
      break ; 

/* Remote Location Protocol servers */
    case TAG_RLP_SERVER :
      len = cookie[i+1] ;
      PrintList("RLPSRVS", cookie, i+2, len) ;
      i += len + 2 ;
      break ; 

/* HOSTNAME (may be fqdn or leaf) */
    case TAG_HOSTNAME :
      len = cookie[i+1] ;
      PrintString("HOSTNAME", cookie, i+2, len) ;
      i += len + 2 ;
      break ;

/* BOOT File Size (ignored) */
    case TAG_BOOTSIZE :
      len = cookie[i+1] ;
      printf("BOOTSIZE=%i\n", ntohs(*(unsigned short int *)&cookie[i+2]) ) ;
      i += len + 2 ;
      break ;

/* Merit DUMP File name (ignored) */
    case TAG_MERIT_DUMP :
      len = cookie[i+1] ;
      i += len + 2 ;
      break ;

/* DOMAIN */
    case TAG_DOMAINNAME :
      len = cookie[i+1] ;
      PrintString("DOMAIN", cookie, i+2, len) ;
      PrintSearch("SEARCH", cookie, i+2, len) ;
      i += len + 2 ;
      break ;

/* SWAPServer address */
    case TAG_SWAP_SERVER :
      memcpy((char *)&temp, cookie + i + 2, 4) ;
      printf("SWAPSRVR=%s\n", inet_ntoa(temp)) ;
      i += 5 ;
      break ;

/* Root pathname to mount as root filesystem (ignored) */
    case TAG_ROOTPATH :
      len = cookie[i+1] ;
      i += len + 2 ;
      break ;

/* Extensions.  Name of further Cookie data (ignored) */
    case TAG_EXTENSIONS :
      len = cookie[i+1] ;
      i += len + 2 ;
      break ;

/* END of cookie (phew) */
    case TAG_END :
      if (verbose)
	fprintf(stderr, "end of cookie parsing, END tag found\n") ;
      return ;

    default:
      if (cookie[i] >= 128 && cookie[i] <= 254) {  /* reserved */
	if (verbose)
	  fprintf(stderr, "reserved TAG %d at %d (len %d) ignored\n",
		  cookie[i], i, cookie[i+1]) ;
	i += 2 + cookie[i+1] ;  /* skip reserved TAG (as per RFC1497)  JSP */
      } else if (verbose) {
	fprintf(stderr, "Not understood TAG %d at %d\n", cookie[i], i) ;
      }
      ++i ;
      break ;
    }
  }
}

/* Print out a list of IP numbers */
void PrintList(char *name,
	       unsigned char *cookie,
	       int pos,
	       int len)
{
  struct in_addr temp ;

  if (verbose)
    fprintf(stderr, "%s found len=%d\n", name, len) ;

  if ((len % 4) != 0) {
    if (verbose)
      fprintf (stderr, "ERROR %s length (%d) not 4 div\n", name, len) ;
    return ;
  }
  if (len == 0) /* Nothing to do  10/02/94  JSP */
    return ;

  printf("%s=\"", name) ;
  for ( ; len; len -= 4, pos += 4) {
    memcpy((char *)&temp, cookie + pos, 4) ;
    printf("%s", inet_ntoa(temp)) ;
    if (len > 4)
      putchar(' ') ;
  }
  printf("\"\n") ;
}

/* Prints the string passed */
void PrintString(char *name,
	       unsigned char *cookie,
	       int pos,
	       int len)
{
  printf("%s=\"", name) ;
  for (; len ; ++pos, --len) {
    putchar(cookie[pos]) ;
  }
  printf ("\"\n") ;
}

/* Prints the string as usable in a DNS search */
void PrintSearch(char *name,
		 unsigned char *cookie,
		 int pos,
		 int len)
{
  char *ptr, *nptr, buf[BUFSIZ] ;
  int i ;

  ptr = (char *)cookie + pos ;
  for (i=0; i < len ; ++i) {  /* Always print the full domain */
    buf[i] = ptr[i] ;
  }
  buf[len] = 0 ; ptr = buf ;
  printf("%s=\"%s", name, buf) ;

  /* And other bits if here */
  nptr = strchr(ptr, '.') ;
  while ((ptr = nptr) != NULL) {
    if ((nptr = strchr(++ptr, '.')) != NULL)
      printf(" %s", ptr) ;
  }
  printf ("\"\n") ;
}

/* Takes an address and returns useful bits of the name after lookup,
   this was a seperate program, but it is more compact to have both
   together.  17/02/94  JSP */

int in2host(char *address)
{
  struct in_addr sin_addr;
  struct hostent *hp;
  char *c ;

/* convert to standard network form */
  sin_addr.s_addr = inet_addr(address);

/* perform lookup, must have DNS running or have local hosts file at
   this point */

  hp = gethostbyaddr((char *)&sin_addr, sizeof(sin_addr), AF_INET) ;

  if (hp == NULL) {
    perror ("bootpc: gethostbyaddr") ;
    return -1;
  }

/* Print out a known name to stop repeated calls */
  printf("DONEIN2HOST=1\n") ;

/* Print out full name as returned by the call */
  printf("HOSTFULL=\"%s\"\n", hp->h_name) ;

  for(c=(char *)hp->h_name; *c ; ++c)
    if(*c == '.') {
/* Zap first 'dot' to give leaf and domain names */
      printf("HOSTDOMAIN=\"%s\"\n", c+1) ;
      PrintSearch("HOSTSEARCH", (unsigned char *)(c+1), 0, strlen(c+1)) ;
      *c = 0 ;
      printf("HOSTLEAF=\"%s\"\n", hp->h_name) ;
      return 0 ;
    }
  return 0 ;
}

/* This is lifted from the BSD ping.c */

/*
 * in_cksum --
 *	Checksum routine for Internet Protocol family headers (C Version)
 */
u_short in_cksum(addr, len)
	u_short *addr;
	int len;
{
	register int nleft = len;
	register u_short *w = addr;
	register int sum = 0;
	u_short answer = 0;

	/*
	 * Our algorithm is simple, using a 32 bit accumulator (sum), we add
	 * sequential 16 bit words to it, and at the end, fold back all the
	 * carry bits from the top 16 bits into the lower 16 bits.
	 */
	while (nleft > 1)  {
		sum += *w++;
		nleft -= 2;
	}

	/* mop up an odd byte, if necessary */
	if (nleft == 1) {
		*(u_char *)(&answer) = *(u_char *)w ;
		sum += answer;
	}

	/* add back carry outs from top 16 bits to low 16 bits */
	sum = (sum >> 16) + (sum & 0xffff);	/* add hi 16 to low 16 */
	sum += (sum >> 16);			/* add carry */
	answer = ~sum;				/* truncate to 16 bits */
	return(answer);
}

#define icmp_type type
#define icmp_code code
#define icmp_cksum checksum
#define icmp_id un.echo.id
#define icmp_seq un.echo.sequence
#define icmp_gwaddr un.gateway
#define ip_hl ihl
#define ip_v version
#define ip_tos tos
#define ip_len tot_len
#define ip_id id
#define ip_off frag_off
#define ip_ttl ttl
#define ip_p protocol
#define ip_sum check
#define ip_src saddr
#define ip_dst daddr

#define ICMP_MINLEN	32
#define	DEFDATALEN	(64 - 8)	/* default data length */
#define	MAXIPLEN	60
#define	MAXICMPLEN	76
#define	MAXPACKET	(65536 - 60 - 8)/* max packet size */
#define	MAXWAIT		10		/* max seconds to wait for response */
#define	NROUTES		9		/* number of record route slots */


/* Takes an address and sends an ICMP request to it.  If we get a reply
   then this is not a good address to use.  If we don't get a reply then
   hopefully we are ok.  This is a very simple version of ping not suitable
   for industrial use.
*/

#define PRETRIES     (6)
#define TIMEOUTSEC   (0)
#define TIMEOUTUSEC  (200000)

/* We send 6 Pings out waiting a total of 1.2 seconds (0.2 sec each),
   if you have a very lossy network, (say 10%), then the chances of
   this failing (assuming a losses are at random, which isn't fair)
   are "a million to one".  But it might just happen!
*/

int pingit(char *address)
{
  struct sockaddr whereto;	/* who to ping */
  struct sockaddr_in *to ;
  struct protoent *proto;
  char packet[BUFSIZ] ;         /* packet we will send */
  int sockfd, ident, datalen = DEFDATALEN ;
  struct icmphdr *icp;
  int cc, i, count = PRETRIES ;
  fd_set rfds, wfds, xfds;
  struct timeval timeout ;
  struct iphdr *ip;

  memset((char *)&whereto, 0, sizeof(struct sockaddr));
  to = (struct sockaddr_in *)&whereto;
  to->sin_family = AF_INET;
  to->sin_addr.s_addr = inet_addr(address);

  ident = getpid() & 0xFFFF;

  if (!(proto = getprotobyname("icmp"))) {
    (void)fprintf(stderr, "bootpc: unknown protocol icmp.\n");
    FatalError();
  }
  if ((sockfd = socket(AF_INET, SOCK_RAW, proto->p_proto)) < 0) {
    perror("bootpc: socket");
    FatalError();
  }

  while (count--) {
    if (debug)
      printf("bootpc: Ping %s count = %d\n", address, count) ;
    icp = (struct icmphdr *)packet;
    icp->icmp_type = ICMP_ECHO;
    icp->icmp_code = 0;
    icp->icmp_cksum = 0;
    icp->icmp_seq = count;
    icp->icmp_id = ident;			/* ID */

    cc = datalen + 8;			/* skips ICMP portion */
    /* compute ICMP checksum here */
    icp->icmp_cksum = in_cksum((u_short *)icp, cc);

    i = sendto(sockfd, packet, cc, 0, &whereto, sizeof(struct sockaddr));

    if (i < 0 || i != cc)  {
      if (i < 0)
	perror("bootpc: sendto");
      (void)printf("bootpc: wrote %s %d chars, ret=%d\n",
		   address, cc, i);
    }

    FD_SET(sockfd,&rfds);
    FD_ZERO(&wfds);
    FD_ZERO(&xfds);
    timeout.tv_sec =  TIMEOUTSEC ;
    timeout.tv_usec = TIMEOUTUSEC ;
  
    if(select(sockfd+1, &rfds, &wfds, &xfds, &timeout)<0) {
      perror("bootpc: select");
      FatalError();
    }

    if(!FD_ISSET(sockfd, &rfds)) {
      continue ;
    } else {
      if (recvfrom(sockfd, (char *)packet, datalen + MAXIPLEN + MAXICMPLEN, 0,
		   (struct sockaddr *)NULL, (int *)NULL) < 0){
	if (errno != EINTR)
	  perror("bootpc: recvfrom");
	continue ;
      }
      ip = (struct iphdr *)packet;
      icp = (struct icmphdr *)(packet + (ip->ip_hl <<2));
      if (icp->icmp_type == ICMP_ECHOREPLY) {  /* a reply */
	if (icp->icmp_id == ident)  /* OUR reply */
	  if (verbose)
	    printf("%s is alive\n", address) ;
	  return 0 ;
      }
    }
  }
  if (verbose)
    printf("No reply from %s\n", address) ;
  return 1 ;
}
