#!/usr/bin/perl
#
# chkdupexe version 1.2
#
# Simple script to look for and list duplicate executables in the
# system executable directories.
#
# Copyright 1993 Nicolai Langfeldt. Distribute under gnu copyleft
#  (included in perl package)
#
# NOTE: ls is invoked with a gnu specific option close to the very end
#  of this script, so if you don't have gnu ls...
# 

# These are the "official" directories of executables, space separated

$execdirs='/bin /sbin /usr/bin /usr/sbin /usr/local/bin /usr/local/sbin /local/bin /local/sbin /usr/X11/bin /usr/local/X11/bin /local/X11/bin /usr/TeX/bin /usr/tex/bin /usr/local/graph/bin /usr/games /usr/intervies/bin/LINUX';

############ You should not have to edit anything below here ############

@dirs = split(/\s/,$execdirs);

#
# Scan all exec directories, rememer all the executables we find in them
#   so the purpose of this program can be fullfilled.
#

foreach $dir (@dirs) {
  opendir(DIR,$dir) || next;
  foreach $_ (readdir(DIR)) {
    ($dum,$dum,$mode) = lstat("$dir/$_");
    if (-l _) {
      ($dum)=stat("$dir/$_");
      # Might as well report these since we discover them anyway
      print "Dangling symlink: $dir/$_\n" if (!$dum);
      next;
    }
    # Only handle regular executable files
    next unless ((($mode & 0100000) == 0100000) && ($mode & 0000111));
    if ($count{$_}) {
      $progs{$_}.=" $dir/$_";
      $count{$_}++;
    } else {
      $progs{$_}="$dir/$_";
      $count{$_}=1;
    }
  }
}

print "Duplicates:\n";
open(LS,"| xargs ls -ld --sort=none");
while (($prog,$paths)=each %progs) {
  print LS "$paths\n" if ($count{$prog}>1);
}
close(LS);
